/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.platform.event.v1;

import com.linkedin.avro2pegasus.events.KafkaAuditHeader;
import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.platform.event.v1.RelationshipChangeOperation;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RelationshipChangeEvent
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.platform.event.v1/**Kafka event for proposing a relationship change between two entities.\nFor example, when dataset1 establishes a new downstream relationship with dataset2.*/@Event.name=\"relationshipChangeEvent\"record RelationshipChangeEvent{/**Kafka audit header containing metadata about the message itself.\nIncludes information like message ID, timestamp, and server details.*/auditHeader:optional{namespace com.linkedin.avro2pegasus.events/**This header records information about the context of an event as it is emitted into kafka and is intended to be used by the kafka audit application.  For more information see go/kafkaauditheader*/record KafkaAuditHeader{/**The time at which the event was emitted into kafka.*/@compliance=[{\"policy\":\"EVENT_TIME\"}]time:long/**The fully qualified name of the host from which the event is being emitted.*/@compliance=\"NONE\"server:string/**The instance on the server from which the event is being emitted. e.g. i001*/@compliance=\"NONE\"instance:optional string/**The name of the application from which the event is being emitted. see go/appname*/@compliance=\"NONE\"appName:string/**A unique identifier for the message*/@compliance=\"NONE\"messageId:fixed UUID 16/**The version that is being used for auditing. In version 0, the audit trail buckets events into 10 minute audit windows based on the EventHeader timestamp. In version 1, the audit trail buckets events as follows: if the schema has an outer KafkaAuditHeader, use the outer audit header timestamp for bucketing; else if the EventHeader has an inner KafkaAuditHeader use that inner audit header's timestamp for bucketing*/@compliance=\"NONE\"auditVersion:optional int/**The fabricUrn of the host from which the event is being emitted. Fabric Urn in the format of urn:li:fabric:{fabric_name}. See go/fabric.*/@compliance=\"NONE\"fabricUrn:optional string/**This is a String that the client uses to establish some kind of connection with the Kafka cluster. The exact format of it depends on specific versions of clients and brokers. This information could potentially identify the fabric and cluster with which the client is producing to or consuming from.*/@compliance=\"NONE\"clusterConnectionString:optional string}}/**The URN (Uniform Resource Name) of the source entity in the relationship.\nIn a downstream relationship example, this would be the URN of the upstream dataset.*/sourceUrn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The URN of the destination entity in the relationship.\nIn a downstream relationship example, this would be the URN of the downstream dataset.*/destinationUrn:com.linkedin.common.Urn/**The operation being performed on this relationship.\nTypically includes operations like ADD, REMOVE, or RESTATE.*/operation:enum RelationshipChangeOperation{ADD,REMOVE,RESTATE}/**The type/category of relationship being established or modified.\nExamples: \"DownstreamOf\", \"Contains\", \"OwnedBy\", \"DerivedFrom\", etc.*/relationshipType:string/**The system or service responsible for managing the lifecycle of this relationship.\nThis helps identify which component has authority over the relationship.*/lifecycleOwner:optional string/**Information about how or through what means this relationship was established.\nCould indicate a specific pipeline, process, or tool that discovered/created the relationship.*/via:optional string/**Additional custom properties associated with this relationship.\nAllows for flexible extension without changing the schema.*/properties:optional map[string,string]/**Stores information about who made this change and when.\nContains the actor (user or system) that performed the action and the timestamp.*/auditStamp:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}", SchemaFormatType.PDL);
    private KafkaAuditHeader _auditHeaderField = null;
    private Urn _sourceUrnField = null;
    private Urn _destinationUrnField = null;
    private RelationshipChangeOperation _operationField = null;
    private String _relationshipTypeField = null;
    private String _lifecycleOwnerField = null;
    private String _viaField = null;
    private StringMap _propertiesField = null;
    private AuditStamp _auditStampField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_AuditHeader = SCHEMA.getField("auditHeader");
    private static final RecordDataSchema.Field FIELD_SourceUrn = SCHEMA.getField("sourceUrn");
    private static final RecordDataSchema.Field FIELD_DestinationUrn = SCHEMA.getField("destinationUrn");
    private static final RecordDataSchema.Field FIELD_Operation = SCHEMA.getField("operation");
    private static final RecordDataSchema.Field FIELD_RelationshipType = SCHEMA.getField("relationshipType");
    private static final RecordDataSchema.Field FIELD_LifecycleOwner = SCHEMA.getField("lifecycleOwner");
    private static final RecordDataSchema.Field FIELD_Via = SCHEMA.getField("via");
    private static final RecordDataSchema.Field FIELD_Properties = SCHEMA.getField("properties");
    private static final RecordDataSchema.Field FIELD_AuditStamp = SCHEMA.getField("auditStamp");

    public RelationshipChangeEvent() {
        super(new DataMap(12, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public RelationshipChangeEvent(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasAuditHeader() {
        if (this._auditHeaderField != null) {
            return true;
        }
        return this._map.containsKey("auditHeader");
    }

    public void removeAuditHeader() {
        this._map.remove("auditHeader");
    }

    @Nullable
    public KafkaAuditHeader getAuditHeader(GetMode mode) {
        return this.getAuditHeader();
    }

    @Nullable
    public KafkaAuditHeader getAuditHeader() {
        if (this._auditHeaderField != null) {
            return this._auditHeaderField;
        }
        Object __rawValue = this._map.get("auditHeader");
        this._auditHeaderField = __rawValue == null ? null : new KafkaAuditHeader(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._auditHeaderField;
    }

    public RelationshipChangeEvent setAuditHeader(@Nullable KafkaAuditHeader value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAuditHeader(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAuditHeader();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "auditHeader", value.data());
                this._auditHeaderField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "auditHeader", value.data());
                this._auditHeaderField = value;
            }
        }
        return this;
    }

    public RelationshipChangeEvent setAuditHeader(@Nonnull KafkaAuditHeader value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field auditHeader of com.linkedin.platform.event.v1.RelationshipChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "auditHeader", value.data());
        this._auditHeaderField = value;
        return this;
    }

    public boolean hasSourceUrn() {
        if (this._sourceUrnField != null) {
            return true;
        }
        return this._map.containsKey("sourceUrn");
    }

    public void removeSourceUrn() {
        this._map.remove("sourceUrn");
    }

    @Nullable
    public Urn getSourceUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSourceUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._sourceUrnField != null) {
                    return this._sourceUrnField;
                }
                Object __rawValue = this._map.get("sourceUrn");
                this._sourceUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._sourceUrnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getSourceUrn() {
        if (this._sourceUrnField != null) {
            return this._sourceUrnField;
        }
        Object __rawValue = this._map.get("sourceUrn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("sourceUrn");
        }
        this._sourceUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._sourceUrnField;
    }

    public RelationshipChangeEvent setSourceUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSourceUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field sourceUrn of com.linkedin.platform.event.v1.RelationshipChangeEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "sourceUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._sourceUrnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSourceUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sourceUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._sourceUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sourceUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._sourceUrnField = value;
            }
        }
        return this;
    }

    public RelationshipChangeEvent setSourceUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sourceUrn of com.linkedin.platform.event.v1.RelationshipChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sourceUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._sourceUrnField = value;
        return this;
    }

    public boolean hasDestinationUrn() {
        if (this._destinationUrnField != null) {
            return true;
        }
        return this._map.containsKey("destinationUrn");
    }

    public void removeDestinationUrn() {
        this._map.remove("destinationUrn");
    }

    @Nullable
    public Urn getDestinationUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDestinationUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._destinationUrnField != null) {
                    return this._destinationUrnField;
                }
                Object __rawValue = this._map.get("destinationUrn");
                this._destinationUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._destinationUrnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getDestinationUrn() {
        if (this._destinationUrnField != null) {
            return this._destinationUrnField;
        }
        Object __rawValue = this._map.get("destinationUrn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("destinationUrn");
        }
        this._destinationUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._destinationUrnField;
    }

    public RelationshipChangeEvent setDestinationUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDestinationUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field destinationUrn of com.linkedin.platform.event.v1.RelationshipChangeEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "destinationUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._destinationUrnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDestinationUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "destinationUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._destinationUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "destinationUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._destinationUrnField = value;
            }
        }
        return this;
    }

    public RelationshipChangeEvent setDestinationUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field destinationUrn of com.linkedin.platform.event.v1.RelationshipChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "destinationUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._destinationUrnField = value;
        return this;
    }

    public boolean hasOperation() {
        if (this._operationField != null) {
            return true;
        }
        return this._map.containsKey("operation");
    }

    public void removeOperation() {
        this._map.remove("operation");
    }

    @Nullable
    public RelationshipChangeOperation getOperation(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getOperation();
            }
            case DEFAULT: 
            case NULL: {
                if (this._operationField != null) {
                    return this._operationField;
                }
                Object __rawValue = this._map.get("operation");
                this._operationField = DataTemplateUtil.coerceEnumOutput(__rawValue, RelationshipChangeOperation.class, RelationshipChangeOperation.$UNKNOWN);
                return this._operationField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public RelationshipChangeOperation getOperation() {
        if (this._operationField != null) {
            return this._operationField;
        }
        Object __rawValue = this._map.get("operation");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("operation");
        }
        this._operationField = DataTemplateUtil.coerceEnumOutput(__rawValue, RelationshipChangeOperation.class, RelationshipChangeOperation.$UNKNOWN);
        return this._operationField;
    }

    public RelationshipChangeEvent setOperation(@Nullable RelationshipChangeOperation value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOperation(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field operation of com.linkedin.platform.event.v1.RelationshipChangeEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "operation", value.name());
                this._operationField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOperation();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "operation", value.name());
                this._operationField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "operation", value.name());
                this._operationField = value;
            }
        }
        return this;
    }

    public RelationshipChangeEvent setOperation(@Nonnull RelationshipChangeOperation value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field operation of com.linkedin.platform.event.v1.RelationshipChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "operation", value.name());
        this._operationField = value;
        return this;
    }

    public boolean hasRelationshipType() {
        if (this._relationshipTypeField != null) {
            return true;
        }
        return this._map.containsKey("relationshipType");
    }

    public void removeRelationshipType() {
        this._map.remove("relationshipType");
    }

    @Nullable
    public String getRelationshipType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRelationshipType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._relationshipTypeField != null) {
                    return this._relationshipTypeField;
                }
                Object __rawValue = this._map.get("relationshipType");
                this._relationshipTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._relationshipTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getRelationshipType() {
        if (this._relationshipTypeField != null) {
            return this._relationshipTypeField;
        }
        Object __rawValue = this._map.get("relationshipType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("relationshipType");
        }
        this._relationshipTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._relationshipTypeField;
    }

    public RelationshipChangeEvent setRelationshipType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRelationshipType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field relationshipType of com.linkedin.platform.event.v1.RelationshipChangeEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "relationshipType", value);
                this._relationshipTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRelationshipType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "relationshipType", value);
                this._relationshipTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "relationshipType", value);
                this._relationshipTypeField = value;
            }
        }
        return this;
    }

    public RelationshipChangeEvent setRelationshipType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field relationshipType of com.linkedin.platform.event.v1.RelationshipChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "relationshipType", value);
        this._relationshipTypeField = value;
        return this;
    }

    public boolean hasLifecycleOwner() {
        if (this._lifecycleOwnerField != null) {
            return true;
        }
        return this._map.containsKey("lifecycleOwner");
    }

    public void removeLifecycleOwner() {
        this._map.remove("lifecycleOwner");
    }

    @Nullable
    public String getLifecycleOwner(GetMode mode) {
        return this.getLifecycleOwner();
    }

    @Nullable
    public String getLifecycleOwner() {
        if (this._lifecycleOwnerField != null) {
            return this._lifecycleOwnerField;
        }
        Object __rawValue = this._map.get("lifecycleOwner");
        this._lifecycleOwnerField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._lifecycleOwnerField;
    }

    public RelationshipChangeEvent setLifecycleOwner(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLifecycleOwner(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLifecycleOwner();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lifecycleOwner", value);
                this._lifecycleOwnerField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lifecycleOwner", value);
                this._lifecycleOwnerField = value;
            }
        }
        return this;
    }

    public RelationshipChangeEvent setLifecycleOwner(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lifecycleOwner of com.linkedin.platform.event.v1.RelationshipChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lifecycleOwner", value);
        this._lifecycleOwnerField = value;
        return this;
    }

    public boolean hasVia() {
        if (this._viaField != null) {
            return true;
        }
        return this._map.containsKey("via");
    }

    public void removeVia() {
        this._map.remove("via");
    }

    @Nullable
    public String getVia(GetMode mode) {
        return this.getVia();
    }

    @Nullable
    public String getVia() {
        if (this._viaField != null) {
            return this._viaField;
        }
        Object __rawValue = this._map.get("via");
        this._viaField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._viaField;
    }

    public RelationshipChangeEvent setVia(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVia(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVia();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "via", value);
                this._viaField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "via", value);
                this._viaField = value;
            }
        }
        return this;
    }

    public RelationshipChangeEvent setVia(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field via of com.linkedin.platform.event.v1.RelationshipChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "via", value);
        this._viaField = value;
        return this;
    }

    public boolean hasProperties() {
        if (this._propertiesField != null) {
            return true;
        }
        return this._map.containsKey("properties");
    }

    public void removeProperties() {
        this._map.remove("properties");
    }

    @Nullable
    public StringMap getProperties(GetMode mode) {
        return this.getProperties();
    }

    @Nullable
    public StringMap getProperties() {
        if (this._propertiesField != null) {
            return this._propertiesField;
        }
        Object __rawValue = this._map.get("properties");
        this._propertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._propertiesField;
    }

    public RelationshipChangeEvent setProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
                this._propertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
                this._propertiesField = value;
            }
        }
        return this;
    }

    public RelationshipChangeEvent setProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field properties of com.linkedin.platform.event.v1.RelationshipChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
        this._propertiesField = value;
        return this;
    }

    public boolean hasAuditStamp() {
        if (this._auditStampField != null) {
            return true;
        }
        return this._map.containsKey("auditStamp");
    }

    public void removeAuditStamp() {
        this._map.remove("auditStamp");
    }

    @Nullable
    public AuditStamp getAuditStamp(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAuditStamp();
            }
            case DEFAULT: 
            case NULL: {
                if (this._auditStampField != null) {
                    return this._auditStampField;
                }
                Object __rawValue = this._map.get("auditStamp");
                this._auditStampField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._auditStampField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getAuditStamp() {
        if (this._auditStampField != null) {
            return this._auditStampField;
        }
        Object __rawValue = this._map.get("auditStamp");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("auditStamp");
        }
        this._auditStampField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._auditStampField;
    }

    public RelationshipChangeEvent setAuditStamp(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAuditStamp(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field auditStamp of com.linkedin.platform.event.v1.RelationshipChangeEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
                this._auditStampField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAuditStamp();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
                this._auditStampField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
                this._auditStampField = value;
            }
        }
        return this;
    }

    public RelationshipChangeEvent setAuditStamp(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field auditStamp of com.linkedin.platform.event.v1.RelationshipChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
        this._auditStampField = value;
        return this;
    }

    @Override
    public RelationshipChangeEvent clone() throws CloneNotSupportedException {
        RelationshipChangeEvent __clone = (RelationshipChangeEvent)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public RelationshipChangeEvent copy() throws CloneNotSupportedException {
        RelationshipChangeEvent __copy = (RelationshipChangeEvent)super.copy();
        __copy._auditStampField = null;
        __copy._sourceUrnField = null;
        __copy._auditHeaderField = null;
        __copy._relationshipTypeField = null;
        __copy._destinationUrnField = null;
        __copy._lifecycleOwnerField = null;
        __copy._operationField = null;
        __copy._propertiesField = null;
        __copy._viaField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final RelationshipChangeEvent __objectRef;

        private ChangeListener(RelationshipChangeEvent reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "auditStamp": {
                    this.__objectRef._auditStampField = null;
                    break;
                }
                case "sourceUrn": {
                    this.__objectRef._sourceUrnField = null;
                    break;
                }
                case "auditHeader": {
                    this.__objectRef._auditHeaderField = null;
                    break;
                }
                case "relationshipType": {
                    this.__objectRef._relationshipTypeField = null;
                    break;
                }
                case "destinationUrn": {
                    this.__objectRef._destinationUrnField = null;
                    break;
                }
                case "lifecycleOwner": {
                    this.__objectRef._lifecycleOwnerField = null;
                    break;
                }
                case "operation": {
                    this.__objectRef._operationField = null;
                    break;
                }
                case "properties": {
                    this.__objectRef._propertiesField = null;
                    break;
                }
                case "via": {
                    this.__objectRef._viaField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public KafkaAuditHeader.Fields auditHeader() {
            return new KafkaAuditHeader.Fields(this.getPathComponents(), "auditHeader");
        }

        public PathSpec sourceUrn() {
            return new PathSpec(this.getPathComponents(), "sourceUrn");
        }

        public PathSpec destinationUrn() {
            return new PathSpec(this.getPathComponents(), "destinationUrn");
        }

        public PathSpec operation() {
            return new PathSpec(this.getPathComponents(), "operation");
        }

        public PathSpec relationshipType() {
            return new PathSpec(this.getPathComponents(), "relationshipType");
        }

        public PathSpec lifecycleOwner() {
            return new PathSpec(this.getPathComponents(), "lifecycleOwner");
        }

        public PathSpec via() {
            return new PathSpec(this.getPathComponents(), "via");
        }

        public PathSpec properties() {
            return new PathSpec(this.getPathComponents(), "properties");
        }

        public AuditStamp.Fields auditStamp() {
            return new AuditStamp.Fields(this.getPathComponents(), "auditStamp");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private KafkaAuditHeader.ProjectionMask _auditHeaderMask;
        private AuditStamp.ProjectionMask _auditStampMask;

        ProjectionMask() {
            super(12);
        }

        public ProjectionMask withAuditHeader(Function<KafkaAuditHeader.ProjectionMask, KafkaAuditHeader.ProjectionMask> nestedMask) {
            this._auditHeaderMask = nestedMask.apply(this._auditHeaderMask == null ? KafkaAuditHeader.createMask() : this._auditHeaderMask);
            this.getDataMap().put("auditHeader", this._auditHeaderMask.getDataMap());
            return this;
        }

        public ProjectionMask withAuditHeader() {
            this._auditHeaderMask = null;
            this.getDataMap().put("auditHeader", 1);
            return this;
        }

        public ProjectionMask withSourceUrn() {
            this.getDataMap().put("sourceUrn", 1);
            return this;
        }

        public ProjectionMask withDestinationUrn() {
            this.getDataMap().put("destinationUrn", 1);
            return this;
        }

        public ProjectionMask withOperation() {
            this.getDataMap().put("operation", 1);
            return this;
        }

        public ProjectionMask withRelationshipType() {
            this.getDataMap().put("relationshipType", 1);
            return this;
        }

        public ProjectionMask withLifecycleOwner() {
            this.getDataMap().put("lifecycleOwner", 1);
            return this;
        }

        public ProjectionMask withVia() {
            this.getDataMap().put("via", 1);
            return this;
        }

        public ProjectionMask withProperties() {
            this.getDataMap().put("properties", 1);
            return this;
        }

        public ProjectionMask withAuditStamp(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._auditStampMask = nestedMask.apply(this._auditStampMask == null ? AuditStamp.createMask() : this._auditStampMask);
            this.getDataMap().put("auditStamp", this._auditStampMask.getDataMap());
            return this;
        }

        public ProjectionMask withAuditStamp(MaskMap nestedMask) {
            this.getDataMap().put("auditStamp", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withAuditStamp() {
            this._auditStampMask = null;
            this.getDataMap().put("auditStamp", 1);
            return this;
        }
    }
}

