/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils.aws;

import java.net.URI;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedPutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PutObjectPresignRequest;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;

public class S3Util {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3Util.class);
    private final S3Client s3Client;
    @Nullable
    private final S3Presigner s3Presigner;

    public S3Util(@Nonnull S3Client s3Client) {
        this(s3Client, null);
    }

    public S3Util(@Nonnull S3Client s3Client, @Nullable S3Presigner s3Presigner) {
        this.s3Client = s3Client;
        this.s3Presigner = s3Presigner;
    }

    public S3Util(@Nonnull StsClient stsClient, @Nonnull String roleArn) {
        this(stsClient, roleArn, null);
    }

    public S3Util(@Nonnull StsClient stsClient, @Nonnull String roleArn, @Nullable S3Presigner s3Presigner) {
        this.s3Presigner = s3Presigner;
        this.s3Client = S3Util.createS3Client(stsClient, roleArn);
    }

    private static S3Client createS3Client(@Nonnull StsClient stsClient, @Nonnull String roleArn) {
        try {
            log.info("Creating S3Client for role: {}", (Object)roleArn);
            StsAssumeRoleCredentialsProvider credentialsProvider = ((StsAssumeRoleCredentialsProvider.Builder)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(r -> r.roleArn(roleArn).roleSessionName("s3-session")).asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build();
            S3ClientBuilder clientBuilder = (S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider);
            String endpointUrl = System.getenv("AWS_ENDPOINT_URL");
            if (endpointUrl != null && !endpointUrl.isEmpty()) {
                log.info("Configuring S3Client with custom endpoint: {}", (Object)endpointUrl);
                clientBuilder.endpointOverride(URI.create(endpointUrl));
                clientBuilder.forcePathStyle(Boolean.valueOf(true));
            }
            S3Client client = (S3Client)clientBuilder.build();
            log.info("Successfully created S3Client for role: {}", (Object)roleArn);
            return client;
        }
        catch (Exception e) {
            log.error("Failed to create S3 client: roleArn={}", (Object)roleArn, (Object)e);
            throw new RuntimeException("Failed to create S3 clien: " + e.getMessage(), e);
        }
    }

    private S3Presigner getPresigner() {
        if (this.s3Presigner != null) {
            return this.s3Presigner;
        }
        S3Presigner.Builder presignerBuilder = S3Presigner.builder().credentialsProvider(this.s3Client.serviceClientConfiguration().credentialsProvider()).region(this.s3Client.serviceClientConfiguration().region());
        String endpointUrl = System.getenv("AWS_ENDPOINT_URL");
        if (endpointUrl != null && !endpointUrl.isEmpty()) {
            presignerBuilder.endpointOverride(URI.create(endpointUrl));
        }
        return presignerBuilder.build();
    }

    public String generatePresignedDownloadUrl(@Nonnull String bucket, @Nonnull String key, int expirationSeconds) {
        String string;
        block8: {
            S3Presigner presigner = this.getPresigner();
            try {
                GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).build();
                GetObjectPresignRequest presignRequest = GetObjectPresignRequest.builder().signatureDuration(Duration.ofSeconds(expirationSeconds)).getObjectRequest(getObjectRequest).build();
                PresignedGetObjectRequest presignedRequest = presigner.presignGetObject(presignRequest);
                string = presignedRequest.url().toString();
                if (presigner == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (presigner != null) {
                        try {
                            presigner.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Failed to generate presigned URL for bucket: {}, key: {}", bucket, key, e);
                    throw new RuntimeException("Failed to generate presigned URL: " + e.getMessage(), e);
                }
            }
            presigner.close();
        }
        return string;
    }

    public String generatePresignedUploadUrl(@Nonnull String bucket, @Nonnull String key, int expirationSeconds, @Nullable String contentType) {
        String string;
        block8: {
            S3Presigner presigner = this.getPresigner();
            try {
                PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(bucket).contentType(contentType).key(key).build();
                PutObjectPresignRequest presignRequest = PutObjectPresignRequest.builder().signatureDuration(Duration.ofSeconds(expirationSeconds)).putObjectRequest(putObjectRequest).build();
                PresignedPutObjectRequest presignedRequest = presigner.presignPutObject(presignRequest);
                string = presignedRequest.url().toString();
                if (presigner == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (presigner != null) {
                        try {
                            presigner.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Failed to generate presigned upload URL for bucket: {}, key: {}", bucket, key, e);
                    throw new RuntimeException("Failed to generate presigned upload URL: " + e.getMessage(), e);
                }
            }
            presigner.close();
        }
        return string;
    }
}

