/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils;

import com.linkedin.common.urn.UrnValidator;
import com.linkedin.data.schema.validation.CoercionMode;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.UnrecognizedFieldMode;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.schema.validation.ValidationResult;
import com.linkedin.data.schema.validator.Validator;
import com.linkedin.data.template.RecordTemplate;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordTemplateValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecordTemplateValidator.class);
    private static final ValidationOptions DEFAULT_VALIDATION_OPTIONS = new ValidationOptions(RequiredMode.CAN_BE_ABSENT_IF_HAS_DEFAULT, CoercionMode.NORMAL, UnrecognizedFieldMode.DISALLOW);
    private static final ValidationOptions TRIM_VALIDATION_OPTIONS = new ValidationOptions(RequiredMode.CAN_BE_ABSENT_IF_HAS_DEFAULT, CoercionMode.NORMAL, UnrecognizedFieldMode.TRIM);
    private static final UrnValidator URN_VALIDATOR = new UrnValidator();

    public static void validate(RecordTemplate record, Consumer<ValidationResult> onValidationFailure) {
        ValidationResult result = ValidateDataAgainstSchema.validate(record, DEFAULT_VALIDATION_OPTIONS, (Validator)URN_VALIDATOR);
        if (!result.isValid()) {
            onValidationFailure.accept(result);
        }
    }

    public static void validateTrim(RecordTemplate record, Consumer<ValidationResult> onValidationFailure) {
        ValidationResult result = ValidateDataAgainstSchema.validate(record, TRIM_VALIDATION_OPTIONS, (Validator)URN_VALIDATOR);
        if (!result.isValid()) {
            onValidationFailure.accept(result);
        }
    }

    public static void validate(RecordTemplate record, Consumer<ValidationResult> onValidationFailure, Validator validator) {
        ValidationResult result = ValidateDataAgainstSchema.validate(record, DEFAULT_VALIDATION_OPTIONS, validator);
        if (!result.isValid()) {
            onValidationFailure.accept(result);
        }
    }

    public static void validateTrim(RecordTemplate record, Consumer<ValidationResult> onValidationFailure, Validator validator) {
        ValidationResult result = ValidateDataAgainstSchema.validate(record, TRIM_VALIDATION_OPTIONS, validator);
        if (!result.isValid()) {
            onValidationFailure.accept(result);
        }
    }

    private RecordTemplateValidator() {
    }
}

