/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.search;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.search.AggregationMetadataArray;
import com.linkedin.metadata.search.SearchSuggestionArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SearchResultMetadata
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.search/**The model for the search result*/record SearchResultMetadata{/**A list of search result metadata such as aggregations*/aggregations:array[record AggregationMetadata{/**The name of the aggregation, e.g, platform, origin*/name:string/**Name of the filter to be displayed in the UI*/displayName:optional string/**Entity associated with this facet*/entity:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**List of aggregations showing the number of documents falling into each bucket. e.g, for platform aggregation, the bucket can be hive, kafka, etc*/aggregations:map[string,long]filterValues:array[record FilterValue{value:string,entity:optional com.linkedin.common.Urn,facetCount:long,filtered:optional boolean}]}]=[]/**A list of search query suggestions based on the given query*/suggestions:array[/**The model for the search result*/record SearchSuggestion{/**The suggestion text for this search query*/text:string/**The score for how close this suggestion is to the original search query.\nThe closer to 1 means it is closer to the original query and 0 is further away.*/score:float/**How many matches there are with the suggested text for the given field*/frequency:long}]=[]}", SchemaFormatType.PDL);
    private AggregationMetadataArray _aggregationsField = null;
    private SearchSuggestionArray _suggestionsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Aggregations = SCHEMA.getField("aggregations");
    private static final AggregationMetadataArray DEFAULT_Aggregations;
    private static final RecordDataSchema.Field FIELD_Suggestions;
    private static final SearchSuggestionArray DEFAULT_Suggestions;

    public SearchResultMetadata() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public SearchResultMetadata(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasAggregations() {
        if (this._aggregationsField != null) {
            return true;
        }
        return this._map.containsKey("aggregations");
    }

    public void removeAggregations() {
        this._map.remove("aggregations");
    }

    @Nullable
    public AggregationMetadataArray getAggregations(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getAggregations();
            }
            case NULL: {
                if (this._aggregationsField != null) {
                    return this._aggregationsField;
                }
                Object __rawValue = this._map.get("aggregations");
                this._aggregationsField = __rawValue == null ? null : new AggregationMetadataArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._aggregationsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AggregationMetadataArray getAggregations() {
        if (this._aggregationsField != null) {
            return this._aggregationsField;
        }
        Object __rawValue = this._map.get("aggregations");
        if (__rawValue == null) {
            return DEFAULT_Aggregations;
        }
        this._aggregationsField = __rawValue == null ? null : new AggregationMetadataArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._aggregationsField;
    }

    public SearchResultMetadata setAggregations(@Nullable AggregationMetadataArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAggregations(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field aggregations of com.linkedin.metadata.search.SearchResultMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAggregations();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
            }
        }
        return this;
    }

    public SearchResultMetadata setAggregations(@Nonnull AggregationMetadataArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aggregations of com.linkedin.metadata.search.SearchResultMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
        this._aggregationsField = value;
        return this;
    }

    public boolean hasSuggestions() {
        if (this._suggestionsField != null) {
            return true;
        }
        return this._map.containsKey("suggestions");
    }

    public void removeSuggestions() {
        this._map.remove("suggestions");
    }

    @Nullable
    public SearchSuggestionArray getSuggestions(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getSuggestions();
            }
            case NULL: {
                if (this._suggestionsField != null) {
                    return this._suggestionsField;
                }
                Object __rawValue = this._map.get("suggestions");
                this._suggestionsField = __rawValue == null ? null : new SearchSuggestionArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._suggestionsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public SearchSuggestionArray getSuggestions() {
        if (this._suggestionsField != null) {
            return this._suggestionsField;
        }
        Object __rawValue = this._map.get("suggestions");
        if (__rawValue == null) {
            return DEFAULT_Suggestions;
        }
        this._suggestionsField = __rawValue == null ? null : new SearchSuggestionArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._suggestionsField;
    }

    public SearchResultMetadata setSuggestions(@Nullable SearchSuggestionArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSuggestions(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field suggestions of com.linkedin.metadata.search.SearchResultMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "suggestions", value.data());
                this._suggestionsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSuggestions();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "suggestions", value.data());
                this._suggestionsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "suggestions", value.data());
                this._suggestionsField = value;
            }
        }
        return this;
    }

    public SearchResultMetadata setSuggestions(@Nonnull SearchSuggestionArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field suggestions of com.linkedin.metadata.search.SearchResultMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "suggestions", value.data());
        this._suggestionsField = value;
        return this;
    }

    @Override
    public SearchResultMetadata clone() throws CloneNotSupportedException {
        SearchResultMetadata __clone = (SearchResultMetadata)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SearchResultMetadata copy() throws CloneNotSupportedException {
        SearchResultMetadata __copy = (SearchResultMetadata)super.copy();
        __copy._suggestionsField = null;
        __copy._aggregationsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Suggestions = SCHEMA.getField("suggestions");
        DEFAULT_Aggregations = FIELD_Aggregations.getDefault() == null ? null : new AggregationMetadataArray(DataTemplateUtil.castOrThrow(FIELD_Aggregations.getDefault(), DataList.class));
        DEFAULT_Suggestions = FIELD_Suggestions.getDefault() == null ? null : new SearchSuggestionArray(DataTemplateUtil.castOrThrow(FIELD_Suggestions.getDefault(), DataList.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SearchResultMetadata __objectRef;

        private ChangeListener(SearchResultMetadata reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "suggestions": {
                    this.__objectRef._suggestionsField = null;
                    break;
                }
                case "aggregations": {
                    this.__objectRef._aggregationsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public AggregationMetadataArray.Fields aggregations() {
            return new AggregationMetadataArray.Fields(this.getPathComponents(), "aggregations");
        }

        public PathSpec aggregations(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "aggregations");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public SearchSuggestionArray.Fields suggestions() {
            return new SearchSuggestionArray.Fields(this.getPathComponents(), "suggestions");
        }

        public PathSpec suggestions(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "suggestions");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AggregationMetadataArray.ProjectionMask _aggregationsMask;
        private SearchSuggestionArray.ProjectionMask _suggestionsMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withAggregations(Function<AggregationMetadataArray.ProjectionMask, AggregationMetadataArray.ProjectionMask> nestedMask) {
            this._aggregationsMask = nestedMask.apply(this._aggregationsMask == null ? AggregationMetadataArray.createMask() : this._aggregationsMask);
            this.getDataMap().put("aggregations", this._aggregationsMask.getDataMap());
            return this;
        }

        public ProjectionMask withAggregations() {
            this._aggregationsMask = null;
            this.getDataMap().put("aggregations", 1);
            return this;
        }

        public ProjectionMask withAggregations(Function<AggregationMetadataArray.ProjectionMask, AggregationMetadataArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._aggregationsMask = nestedMask.apply(this._aggregationsMask == null ? AggregationMetadataArray.createMask() : this._aggregationsMask);
            this.getDataMap().put("aggregations", this._aggregationsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("aggregations").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("aggregations").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withAggregations(Integer start, Integer count) {
            this._aggregationsMask = null;
            this.getDataMap().put("aggregations", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("aggregations").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("aggregations").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withSuggestions(Function<SearchSuggestionArray.ProjectionMask, SearchSuggestionArray.ProjectionMask> nestedMask) {
            this._suggestionsMask = nestedMask.apply(this._suggestionsMask == null ? SearchSuggestionArray.createMask() : this._suggestionsMask);
            this.getDataMap().put("suggestions", this._suggestionsMask.getDataMap());
            return this;
        }

        public ProjectionMask withSuggestions() {
            this._suggestionsMask = null;
            this.getDataMap().put("suggestions", 1);
            return this;
        }

        public ProjectionMask withSuggestions(Function<SearchSuggestionArray.ProjectionMask, SearchSuggestionArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._suggestionsMask = nestedMask.apply(this._suggestionsMask == null ? SearchSuggestionArray.createMask() : this._suggestionsMask);
            this.getDataMap().put("suggestions", this._suggestionsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("suggestions").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("suggestions").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withSuggestions(Integer start, Integer count) {
            this._suggestionsMask = null;
            this.getDataMap().put("suggestions", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("suggestions").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("suggestions").put("$count", count);
            }
            return this;
        }
    }
}

