/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.run;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.run.RelatedAspectArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeleteReferencesResponse
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.run/**The model for the result of a relationship query.\nUsed to get the relationships of a given entity run.*/record DeleteReferencesResponse{relatedAspects:array[/**Metadata about how an aspect is related to some urn*/record RelatedAspect{/** Urn of the entity that is referenced by the aspect.*/entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}aspect:string,relationship:string}]/**Total number of relationships that an entity urn has.*/total:int}", SchemaFormatType.PDL);
    private RelatedAspectArray _relatedAspectsField = null;
    private Integer _totalField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_RelatedAspects = SCHEMA.getField("relatedAspects");
    private static final RecordDataSchema.Field FIELD_Total = SCHEMA.getField("total");

    public DeleteReferencesResponse() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public DeleteReferencesResponse(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasRelatedAspects() {
        if (this._relatedAspectsField != null) {
            return true;
        }
        return this._map.containsKey("relatedAspects");
    }

    public void removeRelatedAspects() {
        this._map.remove("relatedAspects");
    }

    @Nullable
    public RelatedAspectArray getRelatedAspects(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRelatedAspects();
            }
            case DEFAULT: 
            case NULL: {
                if (this._relatedAspectsField != null) {
                    return this._relatedAspectsField;
                }
                Object __rawValue = this._map.get("relatedAspects");
                this._relatedAspectsField = __rawValue == null ? null : new RelatedAspectArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._relatedAspectsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public RelatedAspectArray getRelatedAspects() {
        if (this._relatedAspectsField != null) {
            return this._relatedAspectsField;
        }
        Object __rawValue = this._map.get("relatedAspects");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("relatedAspects");
        }
        this._relatedAspectsField = __rawValue == null ? null : new RelatedAspectArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._relatedAspectsField;
    }

    public DeleteReferencesResponse setRelatedAspects(@Nullable RelatedAspectArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRelatedAspects(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field relatedAspects of com.linkedin.metadata.run.DeleteReferencesResponse");
                }
                CheckedUtil.putWithoutChecking(this._map, "relatedAspects", value.data());
                this._relatedAspectsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRelatedAspects();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "relatedAspects", value.data());
                this._relatedAspectsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "relatedAspects", value.data());
                this._relatedAspectsField = value;
            }
        }
        return this;
    }

    public DeleteReferencesResponse setRelatedAspects(@Nonnull RelatedAspectArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field relatedAspects of com.linkedin.metadata.run.DeleteReferencesResponse to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "relatedAspects", value.data());
        this._relatedAspectsField = value;
        return this;
    }

    public boolean hasTotal() {
        if (this._totalField != null) {
            return true;
        }
        return this._map.containsKey("total");
    }

    public void removeTotal() {
        this._map.remove("total");
    }

    @Nullable
    public Integer getTotal(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTotal();
            }
            case DEFAULT: 
            case NULL: {
                if (this._totalField != null) {
                    return this._totalField;
                }
                Object __rawValue = this._map.get("total");
                this._totalField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._totalField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getTotal() {
        if (this._totalField != null) {
            return this._totalField;
        }
        Object __rawValue = this._map.get("total");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("total");
        }
        this._totalField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._totalField;
    }

    public DeleteReferencesResponse setTotal(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotal(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field total of com.linkedin.metadata.run.DeleteReferencesResponse");
                }
                CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
                this._totalField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotal();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
                this._totalField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
                this._totalField = value;
            }
        }
        return this;
    }

    public DeleteReferencesResponse setTotal(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field total of com.linkedin.metadata.run.DeleteReferencesResponse to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
        this._totalField = value;
        return this;
    }

    public DeleteReferencesResponse setTotal(int value) {
        CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
        this._totalField = value;
        return this;
    }

    @Override
    public DeleteReferencesResponse clone() throws CloneNotSupportedException {
        DeleteReferencesResponse __clone = (DeleteReferencesResponse)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DeleteReferencesResponse copy() throws CloneNotSupportedException {
        DeleteReferencesResponse __copy = (DeleteReferencesResponse)super.copy();
        __copy._totalField = null;
        __copy._relatedAspectsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DeleteReferencesResponse __objectRef;

        private ChangeListener(DeleteReferencesResponse reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "total": {
                    this.__objectRef._totalField = null;
                    break;
                }
                case "relatedAspects": {
                    this.__objectRef._relatedAspectsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public RelatedAspectArray.Fields relatedAspects() {
            return new RelatedAspectArray.Fields(this.getPathComponents(), "relatedAspects");
        }

        public PathSpec relatedAspects(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "relatedAspects");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec total() {
            return new PathSpec(this.getPathComponents(), "total");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private RelatedAspectArray.ProjectionMask _relatedAspectsMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withRelatedAspects(Function<RelatedAspectArray.ProjectionMask, RelatedAspectArray.ProjectionMask> nestedMask) {
            this._relatedAspectsMask = nestedMask.apply(this._relatedAspectsMask == null ? RelatedAspectArray.createMask() : this._relatedAspectsMask);
            this.getDataMap().put("relatedAspects", this._relatedAspectsMask.getDataMap());
            return this;
        }

        public ProjectionMask withRelatedAspects() {
            this._relatedAspectsMask = null;
            this.getDataMap().put("relatedAspects", 1);
            return this;
        }

        public ProjectionMask withRelatedAspects(Function<RelatedAspectArray.ProjectionMask, RelatedAspectArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._relatedAspectsMask = nestedMask.apply(this._relatedAspectsMask == null ? RelatedAspectArray.createMask() : this._relatedAspectsMask);
            this.getDataMap().put("relatedAspects", this._relatedAspectsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("relatedAspects").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("relatedAspects").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withRelatedAspects(Integer start, Integer count) {
            this._relatedAspectsMask = null;
            this.getDataMap().put("relatedAspects", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("relatedAspects").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("relatedAspects").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withTotal() {
            this.getDataMap().put("total", 1);
            return this;
        }
    }
}

