/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.recommendation;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.metadata.query.filter.CriterionArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SearchParams
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.recommendation/**Context to define the search recommendations*/record SearchParams{/**Entity types to be searched. If this is not provided, all entities will be searched.*/types:array[string]=[]/**Search query*/query:string/**Filters*/filters:array[{namespace com.linkedin.metadata.query.filter/**A criterion for matching a field with given value*/record Criterion{/**The name of the field that the criterion refers to*/field:string/**The value of the intended field*/value:string/**Values. one of which the intended field should match\nNote, if values is set, the above \"value\" field will be ignored*/values:array[string]=[]/**The condition for the criterion, e.g. EQUAL, START_WITH*/condition:/**The matching condition in a filter criterion*/enum Condition{/**Represent the relation: String field contains value, e.g. name contains Profile*/CONTAIN/**Represent the relation: String field ends with value, e.g. name ends with Event*/END_WITH/**Represent the relation: field = value, e.g. platform = hdfs*/EQUAL/**Represent the relation: field = value and support case insensitive values, e.g. platform = hdfs*/IEQUAL/**Represent the relation: field is null, e.g. platform is null*/IS_NULL/**Represents the relation: field exists and is non-empty, e.g. owners is not null and != [] (empty)*/EXISTS/**Represent the relation greater than, e.g. ownerCount > 5*/GREATER_THAN/**Represent the relation greater than or equal to, e.g. ownerCount >= 5*/GREATER_THAN_OR_EQUAL_TO/**Represent the relation: String field is one of the array values to, e.g. name in [\"Profile\", \"Event\"]*/IN/**Represent the relation less than, e.g. ownerCount < 3*/LESS_THAN/**Represent the relation less than or equal to, e.g. ownerCount <= 3*/LESS_THAN_OR_EQUAL_TO/**Represent the relation: String field starts with value, e.g. name starts with PageView*/START_WITH/**Represent the relation: URN field any nested children in addition to the given URN*/DESCENDANTS_INCL/**Represent the relation: URN field matches any nested parent in addition to the given URN*/ANCESTORS_INCL/**Represent the relation: URN field matches any nested child or parent in addition to the given URN*/RELATED_INCL}=\"EQUAL\"/**Whether the condition should be negated*/negated:boolean=false}}]=[]}", SchemaFormatType.PDL);
    private StringArray _typesField = null;
    private String _queryField = null;
    private CriterionArray _filtersField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Types = SCHEMA.getField("types");
    private static final StringArray DEFAULT_Types;
    private static final RecordDataSchema.Field FIELD_Query;
    private static final RecordDataSchema.Field FIELD_Filters;
    private static final CriterionArray DEFAULT_Filters;

    public SearchParams() {
        super(new DataMap(4, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public SearchParams(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTypes() {
        if (this._typesField != null) {
            return true;
        }
        return this._map.containsKey("types");
    }

    public void removeTypes() {
        this._map.remove("types");
    }

    @Nullable
    public StringArray getTypes(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getTypes();
            }
            case NULL: {
                if (this._typesField != null) {
                    return this._typesField;
                }
                Object __rawValue = this._map.get("types");
                this._typesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._typesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringArray getTypes() {
        if (this._typesField != null) {
            return this._typesField;
        }
        Object __rawValue = this._map.get("types");
        if (__rawValue == null) {
            return DEFAULT_Types;
        }
        this._typesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._typesField;
    }

    public SearchParams setTypes(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTypes(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field types of com.linkedin.metadata.recommendation.SearchParams");
                }
                CheckedUtil.putWithoutChecking(this._map, "types", value.data());
                this._typesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTypes();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "types", value.data());
                this._typesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "types", value.data());
                this._typesField = value;
            }
        }
        return this;
    }

    public SearchParams setTypes(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field types of com.linkedin.metadata.recommendation.SearchParams to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "types", value.data());
        this._typesField = value;
        return this;
    }

    public boolean hasQuery() {
        if (this._queryField != null) {
            return true;
        }
        return this._map.containsKey("query");
    }

    public void removeQuery() {
        this._map.remove("query");
    }

    @Nullable
    public String getQuery(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getQuery();
            }
            case DEFAULT: 
            case NULL: {
                if (this._queryField != null) {
                    return this._queryField;
                }
                Object __rawValue = this._map.get("query");
                this._queryField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._queryField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getQuery() {
        if (this._queryField != null) {
            return this._queryField;
        }
        Object __rawValue = this._map.get("query");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("query");
        }
        this._queryField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._queryField;
    }

    public SearchParams setQuery(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setQuery(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field query of com.linkedin.metadata.recommendation.SearchParams");
                }
                CheckedUtil.putWithoutChecking(this._map, "query", value);
                this._queryField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeQuery();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "query", value);
                this._queryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "query", value);
                this._queryField = value;
            }
        }
        return this;
    }

    public SearchParams setQuery(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field query of com.linkedin.metadata.recommendation.SearchParams to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "query", value);
        this._queryField = value;
        return this;
    }

    public boolean hasFilters() {
        if (this._filtersField != null) {
            return true;
        }
        return this._map.containsKey("filters");
    }

    public void removeFilters() {
        this._map.remove("filters");
    }

    @Nullable
    public CriterionArray getFilters(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getFilters();
            }
            case NULL: {
                if (this._filtersField != null) {
                    return this._filtersField;
                }
                Object __rawValue = this._map.get("filters");
                this._filtersField = __rawValue == null ? null : new CriterionArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._filtersField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public CriterionArray getFilters() {
        if (this._filtersField != null) {
            return this._filtersField;
        }
        Object __rawValue = this._map.get("filters");
        if (__rawValue == null) {
            return DEFAULT_Filters;
        }
        this._filtersField = __rawValue == null ? null : new CriterionArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._filtersField;
    }

    public SearchParams setFilters(@Nullable CriterionArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFilters(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field filters of com.linkedin.metadata.recommendation.SearchParams");
                }
                CheckedUtil.putWithoutChecking(this._map, "filters", value.data());
                this._filtersField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFilters();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "filters", value.data());
                this._filtersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "filters", value.data());
                this._filtersField = value;
            }
        }
        return this;
    }

    public SearchParams setFilters(@Nonnull CriterionArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field filters of com.linkedin.metadata.recommendation.SearchParams to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "filters", value.data());
        this._filtersField = value;
        return this;
    }

    @Override
    public SearchParams clone() throws CloneNotSupportedException {
        SearchParams __clone = (SearchParams)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SearchParams copy() throws CloneNotSupportedException {
        SearchParams __copy = (SearchParams)super.copy();
        __copy._typesField = null;
        __copy._queryField = null;
        __copy._filtersField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Query = SCHEMA.getField("query");
        FIELD_Filters = SCHEMA.getField("filters");
        DEFAULT_Types = FIELD_Types.getDefault() == null ? null : new StringArray(DataTemplateUtil.castOrThrow(FIELD_Types.getDefault(), DataList.class));
        DEFAULT_Filters = FIELD_Filters.getDefault() == null ? null : new CriterionArray(DataTemplateUtil.castOrThrow(FIELD_Filters.getDefault(), DataList.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SearchParams __objectRef;

        private ChangeListener(SearchParams reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "types": {
                    this.__objectRef._typesField = null;
                    break;
                }
                case "query": {
                    this.__objectRef._queryField = null;
                    break;
                }
                case "filters": {
                    this.__objectRef._filtersField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec types() {
            return new PathSpec(this.getPathComponents(), "types");
        }

        public PathSpec types(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "types");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec query() {
            return new PathSpec(this.getPathComponents(), "query");
        }

        public CriterionArray.Fields filters() {
            return new CriterionArray.Fields(this.getPathComponents(), "filters");
        }

        public PathSpec filters(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "filters");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private CriterionArray.ProjectionMask _filtersMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withTypes() {
            this.getDataMap().put("types", 1);
            return this;
        }

        public ProjectionMask withTypes(Integer start, Integer count) {
            this.getDataMap().put("types", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("types").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("types").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withQuery() {
            this.getDataMap().put("query", 1);
            return this;
        }

        public ProjectionMask withFilters(Function<CriterionArray.ProjectionMask, CriterionArray.ProjectionMask> nestedMask) {
            this._filtersMask = nestedMask.apply(this._filtersMask == null ? CriterionArray.createMask() : this._filtersMask);
            this.getDataMap().put("filters", this._filtersMask.getDataMap());
            return this;
        }

        public ProjectionMask withFilters() {
            this._filtersMask = null;
            this.getDataMap().put("filters", 1);
            return this;
        }

        public ProjectionMask withFilters(Function<CriterionArray.ProjectionMask, CriterionArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._filtersMask = nestedMask.apply(this._filtersMask == null ? CriterionArray.createMask() : this._filtersMask);
            this.getDataMap().put("filters", this._filtersMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("filters").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("filters").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFilters(Integer start, Integer count) {
            this._filtersMask = null;
            this.getDataMap().put("filters", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("filters").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("filters").put("$count", count);
            }
            return this;
        }
    }
}

