/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.annotation;

import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.annotation.AnnotationUtils;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class EventAnnotation {
    public static final String ANNOTATION_NAME = "Event";
    private static final String NAME_FIELD = "name";
    private final String name;

    @Nonnull
    public static EventAnnotation fromPegasusAnnotationObject(@Nonnull Object annotationObj, @Nonnull String context) {
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid value type provided (Expected Map)", ANNOTATION_NAME, context));
        }
        Map map = (Map)annotationObj;
        Optional<String> name = AnnotationUtils.getField(map, NAME_FIELD, String.class);
        if (!name.isPresent()) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation at %s: Invalid field '%s'. Expected type String", ANNOTATION_NAME, context, NAME_FIELD));
        }
        return new EventAnnotation(name.get());
    }

    @Generated
    public EventAnnotation(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventAnnotation)) {
            return false;
        }
        EventAnnotation other = (EventAnnotation)o;
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EventAnnotation(name=" + this.getName() + ")";
    }
}

