/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class AnnotationUtils {
    static <T> Optional<T> getField(Map fieldMap, String fieldName, Class<T> fieldType) {
        if (fieldMap.containsKey(fieldName) && fieldType.isAssignableFrom(fieldMap.get(fieldName).getClass())) {
            return Optional.of(fieldType.cast(fieldMap.get(fieldName)));
        }
        return Optional.empty();
    }

    static <T> List<T> getFieldList(Map<String, ?> fieldMap, String fieldName, Class<T> itemType) {
        Object value = fieldMap.get(fieldName);
        if (!(value instanceof List)) {
            return Collections.emptyList();
        }
        List list = (List)value;
        ArrayList<T> result = new ArrayList<T>();
        for (Object item : list) {
            if (!itemType.isInstance(item)) continue;
            result.add(itemType.cast(item));
        }
        return Collections.unmodifiableList(result);
    }

    @Generated
    private AnnotationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

