/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.google.common.collect.ImmutableSet;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaTraverse;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.annotation.SchemaVisitorTraversalResult;
import com.linkedin.data.schema.annotation.TraverserContext;
import com.linkedin.metadata.models.FieldSpecUtils;
import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.SearchScoreFieldSpec;
import com.linkedin.metadata.models.annotation.SearchScoreAnnotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SearchScoreFieldSpecExtractor
implements SchemaVisitor {
    private final List<SearchScoreFieldSpec> _specs = new ArrayList<SearchScoreFieldSpec>();
    private static final Set<DataSchema.Type> NUMERIC_TYPES = ImmutableSet.of(DataSchema.Type.INT, DataSchema.Type.LONG, DataSchema.Type.FLOAT, DataSchema.Type.DOUBLE);

    public List<SearchScoreFieldSpec> getSpecs() {
        return this._specs;
    }

    @Override
    public void callbackOnContext(TraverserContext context, DataSchemaTraverse.Order order) {
        if (context.getEnclosingField() == null) {
            return;
        }
        if (DataSchemaTraverse.Order.PRE_ORDER.equals((Object)order)) {
            DataSchema currentSchema = context.getCurrentSchema().getDereferencedDataSchema();
            Object annotationObj = this.getAnnotationObj(context);
            if (annotationObj != null) {
                if (currentSchema.isPrimitive() && this.isNumericType((PrimitiveDataSchema)currentSchema).booleanValue()) {
                    this.extractAnnotation(annotationObj, currentSchema, context);
                } else {
                    throw new ModelValidationException(String.format("Invalid @SearchScore Annotation at %s. This annotation can only be put in on a numeric singular (non-array) field", context.getSchemaPathSpec().toString()));
                }
            }
        }
    }

    private Object getAnnotationObj(TraverserContext context) {
        Map<String, Object> properties = context.getEnclosingField().getProperties();
        return properties.get("SearchScore");
    }

    private void extractAnnotation(Object annotationObj, DataSchema currentSchema, TraverserContext context) {
        PathSpec path = new PathSpec(context.getSchemaPathSpec());
        Optional<PathSpec> fullPath = FieldSpecUtils.getPathSpecWithAspectName(context);
        if (context.getSchemaPathSpec().contains(PathSpec.WILDCARD)) {
            throw new ModelValidationException(String.format("SearchScore annotation can only be put on singular fields (non-arrays): path %s", fullPath.orElse(path)));
        }
        SearchScoreAnnotation annotation = SearchScoreAnnotation.fromPegasusAnnotationObject(annotationObj, FieldSpecUtils.getSchemaFieldName(path), path.toString());
        SearchScoreFieldSpec fieldSpec = new SearchScoreFieldSpec(path, annotation, currentSchema);
        this._specs.add(fieldSpec);
    }

    @Override
    public SchemaVisitor.VisitorContext getInitialVisitorContext() {
        return null;
    }

    @Override
    public SchemaVisitorTraversalResult getSchemaVisitorTraversalResult() {
        return new SchemaVisitorTraversalResult();
    }

    private Boolean isNumericType(PrimitiveDataSchema schema) {
        return NUMERIC_TYPES.contains((Object)schema.getDereferencedType());
    }
}

