/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.entity.validation;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.schema.validation.ValidationResult;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.aspect.AspectRetriever;
import com.linkedin.metadata.entity.validation.ValidationException;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.metadata.utils.EntityApiUtils;
import com.linkedin.metadata.utils.EntityKeyUtils;
import com.linkedin.metadata.utils.EntityRegistryUrnValidator;
import com.linkedin.metadata.utils.RecordTemplateValidator;
import com.linkedin.metadata.utils.UrnValidationUtil;
import com.linkedin.mxe.MetadataChangeProposal;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationApiUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidationApiUtils.class);
    public static final String STRICT_URN_VALIDATION_ENABLED = "STRICT_URN_VALIDATION_ENABLED";

    public static void validateOrThrow(RecordTemplate record) {
        RecordTemplateValidator.validate(record, validationResult -> {
            throw new ValidationException(String.format("Failed to validate record with class %s: %s", record.getClass().getName(), validationResult.getMessages().toString()));
        });
    }

    public static void validateTrimOrThrow(RecordTemplate record) {
        RecordTemplateValidator.validateTrim(record, validationResult -> {
            throw new ValidationException(String.format("Failed to validate record with class %s: %s", record.getClass().getName(), validationResult.getMessages().toString()));
        });
    }

    @Nonnull
    public static Urn validateUrn(@Nonnull EntityRegistry entityRegistry, Urn urn) {
        if (urn == null) {
            throw new ValidationException("Cannot validate null URN.");
        }
        UrnValidationUtil.validateUrn(entityRegistry, urn, Boolean.TRUE.equals(Boolean.parseBoolean(System.getenv().getOrDefault(STRICT_URN_VALIDATION_ENABLED, "false"))));
        return urn;
    }

    @Nonnull
    public static EntitySpec validateEntity(@Nonnull EntityRegistry entityRegistry, String entityType) {
        try {
            EntitySpec entitySpec = entityRegistry.getEntitySpec(entityType);
            if (entitySpec == null) {
                throw new ValidationException("Unknown entity: " + entityType);
            }
            return entitySpec;
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    @Nonnull
    public static AspectSpec validateAspect(@Nonnull EntitySpec entitySpec, String aspectName) {
        if (aspectName == null || aspectName.isEmpty()) {
            throw new UnsupportedOperationException("Aspect name is required for create and update operations");
        }
        AspectSpec aspectSpec = entitySpec.getAspectSpec(aspectName);
        if (aspectSpec == null) {
            throw new ValidationException(String.format("Unknown aspect %s for entity %s", aspectName, entitySpec.getName()));
        }
        return aspectSpec;
    }

    public static void validateRecordTemplate(EntitySpec entitySpec, Urn urn, @Nullable RecordTemplate aspect, @Nonnull AspectRetriever aspectRetriever) {
        EntityRegistry entityRegistry = aspectRetriever.getEntityRegistry();
        EntityRegistryUrnValidator validator = new EntityRegistryUrnValidator(entityRegistry);
        validator.setCurrentEntitySpec(entitySpec);
        Consumer<ValidationResult> resultFunction = validationResult -> {
            throw new ValidationException("Invalid format for aspect: " + entitySpec.getName() + "\n Cause: " + String.valueOf(validationResult.getMessages()));
        };
        RecordTemplateValidator.validate(EntityApiUtils.buildKeyAspect(entityRegistry, urn), resultFunction, validator);
        if (aspect != null) {
            RecordTemplateValidator.validateTrim(aspect, resultFunction, validator);
        }
    }

    public static MetadataChangeProposal validateMCP(@Nonnull EntityRegistry entityRegistry, MetadataChangeProposal mcp) {
        EntitySpec entitySpec;
        Urn urn;
        if (mcp == null) {
            throw new UnsupportedOperationException("MetadataChangeProposal is required.");
        }
        if (mcp.getEntityUrn() != null) {
            urn = mcp.getEntityUrn();
            entitySpec = ValidationApiUtils.validateEntity(entityRegistry, urn.getEntityType());
        } else {
            entitySpec = ValidationApiUtils.validateEntity(entityRegistry, mcp.getEntityType());
            urn = EntityKeyUtils.getUrnFromProposal(mcp, entitySpec.getKeyAspectSpec());
            mcp.setEntityUrn(urn);
        }
        if (!mcp.getEntityType().equalsIgnoreCase(urn.getEntityType())) {
            throw new ValidationException(String.format("URN entity type does not match MCP entity type. %s != %s", urn.getEntityType(), mcp.getEntityType()));
        }
        mcp.setEntityType(urn.getEntityType());
        ValidationApiUtils.validateUrn(entityRegistry, urn);
        ValidationApiUtils.validateAspect(entitySpec, mcp.getAspectName());
        return mcp;
    }
}

