/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.browse;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.browse.BrowseResultEntityArray;
import com.linkedin.metadata.browse.BrowseResultGroupArray;
import com.linkedin.metadata.browse.BrowseResultMetadata;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BrowseResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.browse/**The model for the result of a browse query*/record BrowseResult{/**A list of entities under the queried path*/entities:array[/**Data model for an entity returned as part of a browse query*/record BrowseResultEntity{/**Name of the entity*/name:optional string/**URN of the entity*/urn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}]/**A list of groups and total number of entities inside those groups under the queried path*/groups:array[record BrowseResultGroup{/**Name of the group*/name:string/**Number of entities that can be reached from this path*/count:long}]=[]/**Metadata specific to the browse result of the queried path*/metadata:/**The model for browse result metadata*/record BrowseResultMetadata{/**Path that is being browsed*/path:string/**Total number of entities we can reach from path*/totalNumEntities:long}/**Offset of the first entity in the result*/from:int/**Size of each page in the result*/pageSize:int/**The total number of entities directly under queried path*/numEntities:int/**The total number of groups directly under queried path*/numGroups:int/**The total number of elements (entities + groups) directly under queried path*/numElements:int}", SchemaFormatType.PDL);
    private BrowseResultEntityArray _entitiesField = null;
    private BrowseResultGroupArray _groupsField = null;
    private BrowseResultMetadata _metadataField = null;
    private Integer _fromField = null;
    private Integer _pageSizeField = null;
    private Integer _numEntitiesField = null;
    private Integer _numGroupsField = null;
    private Integer _numElementsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Entities = SCHEMA.getField("entities");
    private static final RecordDataSchema.Field FIELD_Groups = SCHEMA.getField("groups");
    private static final BrowseResultGroupArray DEFAULT_Groups;
    private static final RecordDataSchema.Field FIELD_Metadata;
    private static final RecordDataSchema.Field FIELD_From;
    private static final RecordDataSchema.Field FIELD_PageSize;
    private static final RecordDataSchema.Field FIELD_NumEntities;
    private static final RecordDataSchema.Field FIELD_NumGroups;
    private static final RecordDataSchema.Field FIELD_NumElements;

    public BrowseResult() {
        super(new DataMap(11, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public BrowseResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEntities() {
        if (this._entitiesField != null) {
            return true;
        }
        return this._map.containsKey("entities");
    }

    public void removeEntities() {
        this._map.remove("entities");
    }

    @Nullable
    public BrowseResultEntityArray getEntities(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntities();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entitiesField != null) {
                    return this._entitiesField;
                }
                Object __rawValue = this._map.get("entities");
                this._entitiesField = __rawValue == null ? null : new BrowseResultEntityArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._entitiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public BrowseResultEntityArray getEntities() {
        if (this._entitiesField != null) {
            return this._entitiesField;
        }
        Object __rawValue = this._map.get("entities");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entities");
        }
        this._entitiesField = __rawValue == null ? null : new BrowseResultEntityArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._entitiesField;
    }

    public BrowseResult setEntities(@Nullable BrowseResultEntityArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntities(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entities of com.linkedin.metadata.browse.BrowseResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntities();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
            }
        }
        return this;
    }

    public BrowseResult setEntities(@Nonnull BrowseResultEntityArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entities of com.linkedin.metadata.browse.BrowseResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
        this._entitiesField = value;
        return this;
    }

    public boolean hasGroups() {
        if (this._groupsField != null) {
            return true;
        }
        return this._map.containsKey("groups");
    }

    public void removeGroups() {
        this._map.remove("groups");
    }

    @Nullable
    public BrowseResultGroupArray getGroups(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getGroups();
            }
            case NULL: {
                if (this._groupsField != null) {
                    return this._groupsField;
                }
                Object __rawValue = this._map.get("groups");
                this._groupsField = __rawValue == null ? null : new BrowseResultGroupArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._groupsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public BrowseResultGroupArray getGroups() {
        if (this._groupsField != null) {
            return this._groupsField;
        }
        Object __rawValue = this._map.get("groups");
        if (__rawValue == null) {
            return DEFAULT_Groups;
        }
        this._groupsField = __rawValue == null ? null : new BrowseResultGroupArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._groupsField;
    }

    public BrowseResult setGroups(@Nullable BrowseResultGroupArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGroups(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field groups of com.linkedin.metadata.browse.BrowseResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGroups();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
            }
        }
        return this;
    }

    public BrowseResult setGroups(@Nonnull BrowseResultGroupArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field groups of com.linkedin.metadata.browse.BrowseResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
        this._groupsField = value;
        return this;
    }

    public boolean hasMetadata() {
        if (this._metadataField != null) {
            return true;
        }
        return this._map.containsKey("metadata");
    }

    public void removeMetadata() {
        this._map.remove("metadata");
    }

    @Nullable
    public BrowseResultMetadata getMetadata(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getMetadata();
            }
            case DEFAULT: 
            case NULL: {
                if (this._metadataField != null) {
                    return this._metadataField;
                }
                Object __rawValue = this._map.get("metadata");
                this._metadataField = __rawValue == null ? null : new BrowseResultMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._metadataField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public BrowseResultMetadata getMetadata() {
        if (this._metadataField != null) {
            return this._metadataField;
        }
        Object __rawValue = this._map.get("metadata");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("metadata");
        }
        this._metadataField = __rawValue == null ? null : new BrowseResultMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._metadataField;
    }

    public BrowseResult setMetadata(@Nullable BrowseResultMetadata value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMetadata(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field metadata of com.linkedin.metadata.browse.BrowseResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
                this._metadataField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMetadata();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
                this._metadataField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
                this._metadataField = value;
            }
        }
        return this;
    }

    public BrowseResult setMetadata(@Nonnull BrowseResultMetadata value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field metadata of com.linkedin.metadata.browse.BrowseResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
        this._metadataField = value;
        return this;
    }

    public boolean hasFrom() {
        if (this._fromField != null) {
            return true;
        }
        return this._map.containsKey("from");
    }

    public void removeFrom() {
        this._map.remove("from");
    }

    @Nullable
    public Integer getFrom(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFrom();
            }
            case DEFAULT: 
            case NULL: {
                if (this._fromField != null) {
                    return this._fromField;
                }
                Object __rawValue = this._map.get("from");
                this._fromField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._fromField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getFrom() {
        if (this._fromField != null) {
            return this._fromField;
        }
        Object __rawValue = this._map.get("from");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("from");
        }
        this._fromField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._fromField;
    }

    public BrowseResult setFrom(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFrom(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field from of com.linkedin.metadata.browse.BrowseResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
                this._fromField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFrom();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
                this._fromField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
                this._fromField = value;
            }
        }
        return this;
    }

    public BrowseResult setFrom(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field from of com.linkedin.metadata.browse.BrowseResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
        this._fromField = value;
        return this;
    }

    public BrowseResult setFrom(int value) {
        CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
        this._fromField = value;
        return this;
    }

    public boolean hasPageSize() {
        if (this._pageSizeField != null) {
            return true;
        }
        return this._map.containsKey("pageSize");
    }

    public void removePageSize() {
        this._map.remove("pageSize");
    }

    @Nullable
    public Integer getPageSize(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPageSize();
            }
            case DEFAULT: 
            case NULL: {
                if (this._pageSizeField != null) {
                    return this._pageSizeField;
                }
                Object __rawValue = this._map.get("pageSize");
                this._pageSizeField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._pageSizeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getPageSize() {
        if (this._pageSizeField != null) {
            return this._pageSizeField;
        }
        Object __rawValue = this._map.get("pageSize");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("pageSize");
        }
        this._pageSizeField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._pageSizeField;
    }

    public BrowseResult setPageSize(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPageSize(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field pageSize of com.linkedin.metadata.browse.BrowseResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
                this._pageSizeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePageSize();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
                this._pageSizeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
                this._pageSizeField = value;
            }
        }
        return this;
    }

    public BrowseResult setPageSize(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field pageSize of com.linkedin.metadata.browse.BrowseResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
        this._pageSizeField = value;
        return this;
    }

    public BrowseResult setPageSize(int value) {
        CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
        this._pageSizeField = value;
        return this;
    }

    public boolean hasNumEntities() {
        if (this._numEntitiesField != null) {
            return true;
        }
        return this._map.containsKey("numEntities");
    }

    public void removeNumEntities() {
        this._map.remove("numEntities");
    }

    @Nullable
    public Integer getNumEntities(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getNumEntities();
            }
            case DEFAULT: 
            case NULL: {
                if (this._numEntitiesField != null) {
                    return this._numEntitiesField;
                }
                Object __rawValue = this._map.get("numEntities");
                this._numEntitiesField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._numEntitiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getNumEntities() {
        if (this._numEntitiesField != null) {
            return this._numEntitiesField;
        }
        Object __rawValue = this._map.get("numEntities");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("numEntities");
        }
        this._numEntitiesField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._numEntitiesField;
    }

    public BrowseResult setNumEntities(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumEntities(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field numEntities of com.linkedin.metadata.browse.BrowseResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
                this._numEntitiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumEntities();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
                this._numEntitiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
                this._numEntitiesField = value;
            }
        }
        return this;
    }

    public BrowseResult setNumEntities(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numEntities of com.linkedin.metadata.browse.BrowseResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
        this._numEntitiesField = value;
        return this;
    }

    public BrowseResult setNumEntities(int value) {
        CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
        this._numEntitiesField = value;
        return this;
    }

    public boolean hasNumGroups() {
        if (this._numGroupsField != null) {
            return true;
        }
        return this._map.containsKey("numGroups");
    }

    public void removeNumGroups() {
        this._map.remove("numGroups");
    }

    @Nullable
    public Integer getNumGroups(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getNumGroups();
            }
            case DEFAULT: 
            case NULL: {
                if (this._numGroupsField != null) {
                    return this._numGroupsField;
                }
                Object __rawValue = this._map.get("numGroups");
                this._numGroupsField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._numGroupsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getNumGroups() {
        if (this._numGroupsField != null) {
            return this._numGroupsField;
        }
        Object __rawValue = this._map.get("numGroups");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("numGroups");
        }
        this._numGroupsField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._numGroupsField;
    }

    public BrowseResult setNumGroups(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumGroups(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field numGroups of com.linkedin.metadata.browse.BrowseResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "numGroups", DataTemplateUtil.coerceIntInput(value));
                this._numGroupsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumGroups();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numGroups", DataTemplateUtil.coerceIntInput(value));
                this._numGroupsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numGroups", DataTemplateUtil.coerceIntInput(value));
                this._numGroupsField = value;
            }
        }
        return this;
    }

    public BrowseResult setNumGroups(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numGroups of com.linkedin.metadata.browse.BrowseResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numGroups", DataTemplateUtil.coerceIntInput(value));
        this._numGroupsField = value;
        return this;
    }

    public BrowseResult setNumGroups(int value) {
        CheckedUtil.putWithoutChecking(this._map, "numGroups", DataTemplateUtil.coerceIntInput(value));
        this._numGroupsField = value;
        return this;
    }

    public boolean hasNumElements() {
        if (this._numElementsField != null) {
            return true;
        }
        return this._map.containsKey("numElements");
    }

    public void removeNumElements() {
        this._map.remove("numElements");
    }

    @Nullable
    public Integer getNumElements(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getNumElements();
            }
            case DEFAULT: 
            case NULL: {
                if (this._numElementsField != null) {
                    return this._numElementsField;
                }
                Object __rawValue = this._map.get("numElements");
                this._numElementsField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._numElementsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getNumElements() {
        if (this._numElementsField != null) {
            return this._numElementsField;
        }
        Object __rawValue = this._map.get("numElements");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("numElements");
        }
        this._numElementsField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._numElementsField;
    }

    public BrowseResult setNumElements(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumElements(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field numElements of com.linkedin.metadata.browse.BrowseResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "numElements", DataTemplateUtil.coerceIntInput(value));
                this._numElementsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumElements();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numElements", DataTemplateUtil.coerceIntInput(value));
                this._numElementsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numElements", DataTemplateUtil.coerceIntInput(value));
                this._numElementsField = value;
            }
        }
        return this;
    }

    public BrowseResult setNumElements(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numElements of com.linkedin.metadata.browse.BrowseResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numElements", DataTemplateUtil.coerceIntInput(value));
        this._numElementsField = value;
        return this;
    }

    public BrowseResult setNumElements(int value) {
        CheckedUtil.putWithoutChecking(this._map, "numElements", DataTemplateUtil.coerceIntInput(value));
        this._numElementsField = value;
        return this;
    }

    @Override
    public BrowseResult clone() throws CloneNotSupportedException {
        BrowseResult __clone = (BrowseResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public BrowseResult copy() throws CloneNotSupportedException {
        BrowseResult __copy = (BrowseResult)super.copy();
        __copy._numEntitiesField = null;
        __copy._numGroupsField = null;
        __copy._metadataField = null;
        __copy._entitiesField = null;
        __copy._groupsField = null;
        __copy._pageSizeField = null;
        __copy._fromField = null;
        __copy._numElementsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Metadata = SCHEMA.getField("metadata");
        FIELD_From = SCHEMA.getField("from");
        FIELD_PageSize = SCHEMA.getField("pageSize");
        FIELD_NumEntities = SCHEMA.getField("numEntities");
        FIELD_NumGroups = SCHEMA.getField("numGroups");
        FIELD_NumElements = SCHEMA.getField("numElements");
        DEFAULT_Groups = FIELD_Groups.getDefault() == null ? null : new BrowseResultGroupArray(DataTemplateUtil.castOrThrow(FIELD_Groups.getDefault(), DataList.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final BrowseResult __objectRef;

        private ChangeListener(BrowseResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "numEntities": {
                    this.__objectRef._numEntitiesField = null;
                    break;
                }
                case "numGroups": {
                    this.__objectRef._numGroupsField = null;
                    break;
                }
                case "metadata": {
                    this.__objectRef._metadataField = null;
                    break;
                }
                case "entities": {
                    this.__objectRef._entitiesField = null;
                    break;
                }
                case "groups": {
                    this.__objectRef._groupsField = null;
                    break;
                }
                case "pageSize": {
                    this.__objectRef._pageSizeField = null;
                    break;
                }
                case "from": {
                    this.__objectRef._fromField = null;
                    break;
                }
                case "numElements": {
                    this.__objectRef._numElementsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public BrowseResultEntityArray.Fields entities() {
            return new BrowseResultEntityArray.Fields(this.getPathComponents(), "entities");
        }

        public PathSpec entities(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "entities");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public BrowseResultGroupArray.Fields groups() {
            return new BrowseResultGroupArray.Fields(this.getPathComponents(), "groups");
        }

        public PathSpec groups(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "groups");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public BrowseResultMetadata.Fields metadata() {
            return new BrowseResultMetadata.Fields(this.getPathComponents(), "metadata");
        }

        public PathSpec from() {
            return new PathSpec(this.getPathComponents(), "from");
        }

        public PathSpec pageSize() {
            return new PathSpec(this.getPathComponents(), "pageSize");
        }

        public PathSpec numEntities() {
            return new PathSpec(this.getPathComponents(), "numEntities");
        }

        public PathSpec numGroups() {
            return new PathSpec(this.getPathComponents(), "numGroups");
        }

        public PathSpec numElements() {
            return new PathSpec(this.getPathComponents(), "numElements");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private BrowseResultEntityArray.ProjectionMask _entitiesMask;
        private BrowseResultGroupArray.ProjectionMask _groupsMask;
        private BrowseResultMetadata.ProjectionMask _metadataMask;

        ProjectionMask() {
            super(11);
        }

        public ProjectionMask withEntities(Function<BrowseResultEntityArray.ProjectionMask, BrowseResultEntityArray.ProjectionMask> nestedMask) {
            this._entitiesMask = nestedMask.apply(this._entitiesMask == null ? BrowseResultEntityArray.createMask() : this._entitiesMask);
            this.getDataMap().put("entities", this._entitiesMask.getDataMap());
            return this;
        }

        public ProjectionMask withEntities() {
            this._entitiesMask = null;
            this.getDataMap().put("entities", 1);
            return this;
        }

        public ProjectionMask withEntities(Function<BrowseResultEntityArray.ProjectionMask, BrowseResultEntityArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._entitiesMask = nestedMask.apply(this._entitiesMask == null ? BrowseResultEntityArray.createMask() : this._entitiesMask);
            this.getDataMap().put("entities", this._entitiesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("entities").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("entities").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withEntities(Integer start, Integer count) {
            this._entitiesMask = null;
            this.getDataMap().put("entities", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("entities").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("entities").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withGroups(Function<BrowseResultGroupArray.ProjectionMask, BrowseResultGroupArray.ProjectionMask> nestedMask) {
            this._groupsMask = nestedMask.apply(this._groupsMask == null ? BrowseResultGroupArray.createMask() : this._groupsMask);
            this.getDataMap().put("groups", this._groupsMask.getDataMap());
            return this;
        }

        public ProjectionMask withGroups() {
            this._groupsMask = null;
            this.getDataMap().put("groups", 1);
            return this;
        }

        public ProjectionMask withGroups(Function<BrowseResultGroupArray.ProjectionMask, BrowseResultGroupArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._groupsMask = nestedMask.apply(this._groupsMask == null ? BrowseResultGroupArray.createMask() : this._groupsMask);
            this.getDataMap().put("groups", this._groupsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("groups").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("groups").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withGroups(Integer start, Integer count) {
            this._groupsMask = null;
            this.getDataMap().put("groups", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("groups").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("groups").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withMetadata(Function<BrowseResultMetadata.ProjectionMask, BrowseResultMetadata.ProjectionMask> nestedMask) {
            this._metadataMask = nestedMask.apply(this._metadataMask == null ? BrowseResultMetadata.createMask() : this._metadataMask);
            this.getDataMap().put("metadata", this._metadataMask.getDataMap());
            return this;
        }

        public ProjectionMask withMetadata() {
            this._metadataMask = null;
            this.getDataMap().put("metadata", 1);
            return this;
        }

        public ProjectionMask withFrom() {
            this.getDataMap().put("from", 1);
            return this;
        }

        public ProjectionMask withPageSize() {
            this.getDataMap().put("pageSize", 1);
            return this;
        }

        public ProjectionMask withNumEntities() {
            this.getDataMap().put("numEntities", 1);
            return this;
        }

        public ProjectionMask withNumGroups() {
            this.getDataMap().put("numGroups", 1);
            return this;
        }

        public ProjectionMask withNumElements() {
            this.getDataMap().put("numElements", 1);
            return this;
        }
    }
}

