/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.validation;

import com.linkedin.metadata.aspect.RetrieverContext;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.batch.ChangeMCP;
import com.linkedin.metadata.aspect.plugins.config.AspectPluginConfig;
import com.linkedin.metadata.aspect.plugins.validation.AspectPayloadValidator;
import com.linkedin.metadata.aspect.plugins.validation.AspectValidationException;
import com.linkedin.metadata.aspect.plugins.validation.ValidationExceptionCollection;
import com.linkedin.schema.EditableSchemaFieldInfo;
import com.linkedin.schema.EditableSchemaMetadata;
import com.linkedin.schema.SchemaField;
import com.linkedin.schema.SchemaMetadata;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;

public class FieldPathValidator
extends AspectPayloadValidator {
    @Nonnull
    private AspectPluginConfig config;

    @Override
    protected Stream<AspectValidationException> validateProposedAspects(@Nonnull Collection<? extends BatchItem> mcpItems, @Nonnull RetrieverContext retrieverContext) {
        ValidationExceptionCollection exceptions = ValidationExceptionCollection.newCollection();
        mcpItems.forEach(i -> {
            if (i.getAspectName().equals("schemaMetadata")) {
                FieldPathValidator.processSchemaMetadataAspect(i, exceptions);
            } else {
                FieldPathValidator.processEditableSchemaMetadataAspect(i, exceptions);
            }
        });
        return exceptions.streamAllExceptions();
    }

    @Override
    protected Stream<AspectValidationException> validatePreCommitAspects(@Nonnull Collection<ChangeMCP> changeMCPs, @Nonnull RetrieverContext retrieverContext) {
        return Stream.of(new AspectValidationException[0]);
    }

    private static void processEditableSchemaMetadataAspect(BatchItem i, ValidationExceptionCollection exceptions) {
        EditableSchemaMetadata schemaMetadata = i.getAspect(EditableSchemaMetadata.class);
        long uniquePaths = FieldPathValidator.validateAndCount(i, schemaMetadata.getEditableSchemaFieldInfo().stream().map(EditableSchemaFieldInfo::getFieldPath), exceptions);
        if (uniquePaths != (long)schemaMetadata.getEditableSchemaFieldInfo().size()) {
            exceptions.addException(i, String.format("Cannot perform %s action on proposal. EditableSchemaMetadata aspect has duplicated field paths", new Object[]{i.getChangeType()}));
        }
    }

    private static void processSchemaMetadataAspect(BatchItem i, ValidationExceptionCollection exceptions) {
        SchemaMetadata schemaMetadata = i.getAspect(SchemaMetadata.class);
        long uniquePaths = FieldPathValidator.validateAndCount(i, schemaMetadata.getFields().stream().map(SchemaField::getFieldPath), exceptions);
        if (uniquePaths != (long)schemaMetadata.getFields().size()) {
            exceptions.addException(i, String.format("Cannot perform %s action on proposal. SchemaMetadata aspect has duplicated field paths", new Object[]{i.getChangeType()}));
        }
    }

    private static long validateAndCount(BatchItem i, Stream<String> fieldPaths, ValidationExceptionCollection exceptions) {
        return fieldPaths.distinct().peek(fieldPath -> FieldPathValidator.validateFieldPath(fieldPath).ifPresent(message -> exceptions.addException(i, (String)message))).count();
    }

    private static Optional<String> validateFieldPath(String fieldPath) {
        if (fieldPath == null || fieldPath.isEmpty()) {
            return Optional.of("SchemaMetadata aspect has empty field path.");
        }
        return Optional.empty();
    }

    @Override
    @Generated
    public FieldPathValidator setConfig(@Nonnull AspectPluginConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        return this;
    }

    @Override
    @Nonnull
    @Generated
    public AspectPluginConfig getConfig() {
        return this.config;
    }
}

