/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.template;

import com.linkedin.metadata.aspect.patch.PatchOperationType;
import com.linkedin.util.Pair;
import datahub.shaded.jackson.core.StreamReadConstraints;
import datahub.shaded.jackson.databind.JsonNode;
import datahub.shaded.jackson.databind.ObjectMapper;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import jakarta.json.JsonPatch;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.List;

public class TemplateUtil {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private TemplateUtil() {
    }

    public static List<Pair<PatchOperationType, String>> getPaths(JsonPatch jsonPatch) {
        ArrayList<Pair<PatchOperationType, String>> paths = new ArrayList<Pair<PatchOperationType, String>>();
        jsonPatch.toJsonArray().stream().map(JsonValue::asJsonObject).forEach(node -> paths.add(Pair.of(PatchOperationType.valueOf(node.getString("op").toUpperCase()), node.getString("path"))));
        return paths;
    }

    public static void validatePatch(JsonPatch jsonPatch) {
        jsonPatch.toJsonArray().stream().map(JsonValue::asJsonObject).forEach(jsonObject -> {
            try {
                PatchOperationType.valueOf(jsonObject.getString("op").toUpperCase());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unsupported PATCH operation: `%s` Operation `%s`", jsonObject.getString("op"), jsonObject), e);
            }
        });
    }

    public static JsonNode populateTopLevelKeys(JsonNode transformedNode, JsonPatch jsonPatch) {
        Object transformedNodeClone = transformedNode.deepCopy();
        List<Pair<PatchOperationType, String>> paths = TemplateUtil.getPaths(jsonPatch);
        for (Pair<PatchOperationType, String> operationPath : paths) {
            String[] keys = operationPath.getSecond().split("/");
            Object parent = transformedNodeClone;
            int endIdx = PatchOperationType.REMOVE.equals((Object)operationPath.getFirst()) ? keys.length : keys.length - 1;
            for (int i = 1; i < endIdx; ++i) {
                String decodedKey = TemplateUtil.decodeValue(keys[i]);
                if (((JsonNode)parent).get(decodedKey) == null) {
                    ((ObjectNode)parent).set(decodedKey, JsonNodeFactory.instance.objectNode());
                }
                parent = ((JsonNode)parent).get(decodedKey);
            }
        }
        return transformedNodeClone;
    }

    private static String decodeValue(String value) {
        return value.replace("~1", "/").replace("~0", "~");
    }

    static {
        int maxSize = Integer.parseInt(System.getenv().getOrDefault("INGESTION_MAX_SERIALIZED_STRING_LENGTH", "16000000"));
        OBJECT_MAPPER.getFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(maxSize).build());
    }
}

