/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.template;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.aspect.patch.template.Template;
import com.linkedin.metadata.models.AspectSpec;
import datahub.shaded.jackson.core.JsonProcessingException;
import jakarta.json.JsonPatch;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AspectTemplateEngine {
    public static final Set<String> SUPPORTED_TEMPLATES = Stream.of("datasetProperties", "editableSchemaMetadata", "globalTags", "glossaryTerms", "ownership", "upstreamLineage", "dataFlowInfo", "dataJobInfo", "dataProductProperties", "dataJobInputOutput", "chartInfo", "dashboardInfo", "structuredProperties", "propertyDefinition", "formInfo", "upstreamLineage", "versionProperties", "siblings").collect(Collectors.toSet());
    private final Map<String, Template<? extends RecordTemplate>> _aspectTemplateMap;

    public AspectTemplateEngine() {
        this._aspectTemplateMap = new HashMap<String, Template<? extends RecordTemplate>>();
    }

    public AspectTemplateEngine(Map<String, Template<? extends RecordTemplate>> aspectTemplateMap) {
        this._aspectTemplateMap = aspectTemplateMap;
    }

    @Nullable
    public RecordTemplate getDefaultTemplate(String aspectSpecName) {
        return this._aspectTemplateMap.containsKey(aspectSpecName) ? this._aspectTemplateMap.get(aspectSpecName).getDefault() : null;
    }

    @Nonnull
    public <T extends RecordTemplate> RecordTemplate applyPatch(RecordTemplate recordTemplate, JsonPatch jsonPatch, AspectSpec aspectSpec) throws JsonProcessingException {
        Template<T> template = this.getTemplate(aspectSpec);
        return template.applyPatch(recordTemplate, jsonPatch);
    }

    private <T extends RecordTemplate> Template<T> getTemplate(AspectSpec aspectSpec) {
        return this._aspectTemplateMap.getOrDefault(aspectSpec.getName(), null);
    }
}

