/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.linkedin.common.urn.TagUrn;
import com.linkedin.metadata.aspect.patch.PatchOperationType;
import com.linkedin.metadata.aspect.patch.builder.AbstractMultiFieldPatchBuilder;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class GlobalTagsPatchBuilder
extends AbstractMultiFieldPatchBuilder<GlobalTagsPatchBuilder> {
    private static final String BASE_PATH = "/tags/";
    private static final String URN_KEY = "urn";
    private static final String CONTEXT_KEY = "context";

    public GlobalTagsPatchBuilder addTag(@Nonnull TagUrn urn, @Nullable String context) {
        ObjectNode value = JsonNodeFactory.instance.objectNode();
        value.put(URN_KEY, urn.toString());
        if (context != null) {
            value.put(CONTEXT_KEY, context);
        }
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), BASE_PATH + GlobalTagsPatchBuilder.encodeValueUrn(urn), value));
        return this;
    }

    public GlobalTagsPatchBuilder removeTag(@Nonnull TagUrn urn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), BASE_PATH + GlobalTagsPatchBuilder.encodeValueUrn(urn), null));
        return this;
    }

    @Override
    protected String getAspectName() {
        return "globalTags";
    }

    @Override
    protected String getEntityType() {
        if (this.targetEntityUrn == null) {
            throw new IllegalStateException("Target Entity Urn must be set to determine entity type before building Patch.");
        }
        return this.targetEntityUrn.getEntityType();
    }
}

