/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataprocess;

import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.dataprocess.DataProcessInstanceRunResult;
import com.linkedin.dataprocess.DataProcessRunStatus;
import com.linkedin.timeseries.PartitionSpec;
import com.linkedin.timeseries.TimeWindowSize;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataProcessInstanceRunEvent
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataprocess/**An event representing the current status of data process run.\nDataProcessRunEvent should be used for reporting the status of a dataProcess' run.*/@Aspect={\"name\":\"dataProcessInstanceRunEvent\",\"type\":\"timeseries\"}record DataProcessInstanceRunEvent includes{namespace com.linkedin.timeseries,record TimeseriesAspectBase{/**The event timestamp field as epoch at UTC in milli seconds.*/timestampMillis:long/**Granularity of the event if applicable*/eventGranularity:optional/**Defines the size of a time window.*/record TimeWindowSize{/**Interval unit such as minute/hour/day etc.*/unit:enum CalendarInterval{SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR}/**How many units. Defaults to 1.*/multiple:int=1}/**The optional partition specification.*/partitionSpec:optional/**A reference to a specific partition in a dataset.*/record PartitionSpec{/**A unique id / value for the partition for which statistics were collected,\ngenerated by applying the key definition to a given row.*/@TimeseriesField={}partition:string/**Time window of the partition, if we are able to extract it from the partition key.*/timePartition:optional record TimeWindow{/**Start time as epoch at UTC.*/startTimeMillis:long/**The length of the window.*/length:TimeWindowSize}/**Unused!*/@deprecated,type:enum PartitionType{FULL_TABLE,QUERY,PARTITION}=\"PARTITION\"}={\"partition\":\"FULL_TABLE_SNAPSHOT\",\"type\":\"FULL_TABLE\"}/**The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value.*/messageId:optional string}}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}{@Searchable.hasValuesFieldName=\"hasRunEvents\"@TimeseriesField={}status:enum DataProcessRunStatus{/**The status where the Data processing run is in.*/STARTED,COMPLETE}/**Return the try number that this Instance Run is in*/attempt:optional int/**The final result of the Data Processing run.*/@TimeseriesField={}result:optional record DataProcessInstanceRunResult{/** The final result, e.g. SUCCESS, FAILURE, SKIPPED, or UP_FOR_RETRY.*/type:enum RunResultType{/** The Run Succeeded*/SUCCESS/** The Run Failed*/FAILURE/** The Run Skipped*/SKIPPED/** The Run Failed and will Retry*/UP_FOR_RETRY}/**It identifies the system where the native result comes from like Airflow, Azkaban, etc..*/nativeResultType:string}/**The duration of the run in milliseconds.*/durationMillis:optional long}", SchemaFormatType.PDL);
    private Long _timestampMillisField = null;
    private TimeWindowSize _eventGranularityField = null;
    private PartitionSpec _partitionSpecField = null;
    private String _messageIdField = null;
    private Url _externalUrlField = null;
    private DataProcessRunStatus _statusField = null;
    private Integer _attemptField = null;
    private DataProcessInstanceRunResult _resultField = null;
    private Long _durationMillisField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TimestampMillis = SCHEMA.getField("timestampMillis");
    private static final RecordDataSchema.Field FIELD_EventGranularity = SCHEMA.getField("eventGranularity");
    private static final RecordDataSchema.Field FIELD_PartitionSpec = SCHEMA.getField("partitionSpec");
    private static final PartitionSpec DEFAULT_PartitionSpec;
    private static final RecordDataSchema.Field FIELD_MessageId;
    private static final RecordDataSchema.Field FIELD_ExternalUrl;
    private static final RecordDataSchema.Field FIELD_Status;
    private static final RecordDataSchema.Field FIELD_Attempt;
    private static final RecordDataSchema.Field FIELD_Result;
    private static final RecordDataSchema.Field FIELD_DurationMillis;

    public DataProcessInstanceRunEvent() {
        super(new DataMap(12, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public DataProcessInstanceRunEvent(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTimestampMillis() {
        if (this._timestampMillisField != null) {
            return true;
        }
        return this._map.containsKey("timestampMillis");
    }

    public void removeTimestampMillis() {
        this._map.remove("timestampMillis");
    }

    @Nullable
    public Long getTimestampMillis(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTimestampMillis();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timestampMillisField != null) {
                    return this._timestampMillisField;
                }
                Object __rawValue = this._map.get("timestampMillis");
                this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._timestampMillisField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getTimestampMillis() {
        if (this._timestampMillisField != null) {
            return this._timestampMillisField;
        }
        Object __rawValue = this._map.get("timestampMillis");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("timestampMillis");
        }
        this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timestampMillisField;
    }

    public DataProcessInstanceRunEvent setTimestampMillis(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimestampMillis(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field timestampMillis of com.linkedin.dataprocess.DataProcessInstanceRunEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimestampMillis();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceRunEvent setTimestampMillis(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timestampMillis of com.linkedin.dataprocess.DataProcessInstanceRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public DataProcessInstanceRunEvent setTimestampMillis(long value) {
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public boolean hasEventGranularity() {
        if (this._eventGranularityField != null) {
            return true;
        }
        return this._map.containsKey("eventGranularity");
    }

    public void removeEventGranularity() {
        this._map.remove("eventGranularity");
    }

    @Nullable
    public TimeWindowSize getEventGranularity(GetMode mode) {
        return this.getEventGranularity();
    }

    @Nullable
    public TimeWindowSize getEventGranularity() {
        if (this._eventGranularityField != null) {
            return this._eventGranularityField;
        }
        Object __rawValue = this._map.get("eventGranularity");
        this._eventGranularityField = __rawValue == null ? null : new TimeWindowSize(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._eventGranularityField;
    }

    public DataProcessInstanceRunEvent setEventGranularity(@Nullable TimeWindowSize value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEventGranularity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEventGranularity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceRunEvent setEventGranularity(@Nonnull TimeWindowSize value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field eventGranularity of com.linkedin.dataprocess.DataProcessInstanceRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
        this._eventGranularityField = value;
        return this;
    }

    public boolean hasPartitionSpec() {
        if (this._partitionSpecField != null) {
            return true;
        }
        return this._map.containsKey("partitionSpec");
    }

    public void removePartitionSpec() {
        this._map.remove("partitionSpec");
    }

    @Nullable
    public PartitionSpec getPartitionSpec(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPartitionSpec();
            }
            case NULL: {
                if (this._partitionSpecField != null) {
                    return this._partitionSpecField;
                }
                Object __rawValue = this._map.get("partitionSpec");
                this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._partitionSpecField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public PartitionSpec getPartitionSpec() {
        if (this._partitionSpecField != null) {
            return this._partitionSpecField;
        }
        Object __rawValue = this._map.get("partitionSpec");
        if (__rawValue == null) {
            return DEFAULT_PartitionSpec;
        }
        this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._partitionSpecField;
    }

    public DataProcessInstanceRunEvent setPartitionSpec(@Nullable PartitionSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPartitionSpec(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePartitionSpec();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceRunEvent setPartitionSpec(@Nonnull PartitionSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field partitionSpec of com.linkedin.dataprocess.DataProcessInstanceRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
        this._partitionSpecField = value;
        return this;
    }

    public boolean hasMessageId() {
        if (this._messageIdField != null) {
            return true;
        }
        return this._map.containsKey("messageId");
    }

    public void removeMessageId() {
        this._map.remove("messageId");
    }

    @Nullable
    public String getMessageId(GetMode mode) {
        return this.getMessageId();
    }

    @Nullable
    public String getMessageId() {
        if (this._messageIdField != null) {
            return this._messageIdField;
        }
        Object __rawValue = this._map.get("messageId");
        this._messageIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._messageIdField;
    }

    public DataProcessInstanceRunEvent setMessageId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMessageId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMessageId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceRunEvent setMessageId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field messageId of com.linkedin.dataprocess.DataProcessInstanceRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "messageId", value);
        this._messageIdField = value;
        return this;
    }

    public boolean hasExternalUrl() {
        if (this._externalUrlField != null) {
            return true;
        }
        return this._map.containsKey("externalUrl");
    }

    public void removeExternalUrl() {
        this._map.remove("externalUrl");
    }

    @Nullable
    public Url getExternalUrl(GetMode mode) {
        return this.getExternalUrl();
    }

    @Nullable
    public Url getExternalUrl() {
        if (this._externalUrlField != null) {
            return this._externalUrlField;
        }
        Object __rawValue = this._map.get("externalUrl");
        this._externalUrlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._externalUrlField;
    }

    public DataProcessInstanceRunEvent setExternalUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExternalUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExternalUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceRunEvent setExternalUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field externalUrl of com.linkedin.dataprocess.DataProcessInstanceRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._externalUrlField = value;
        return this;
    }

    public boolean hasStatus() {
        if (this._statusField != null) {
            return true;
        }
        return this._map.containsKey("status");
    }

    public void removeStatus() {
        this._map.remove("status");
    }

    @Nullable
    public DataProcessRunStatus getStatus(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getStatus();
            }
            case DEFAULT: 
            case NULL: {
                if (this._statusField != null) {
                    return this._statusField;
                }
                Object __rawValue = this._map.get("status");
                this._statusField = DataTemplateUtil.coerceEnumOutput(__rawValue, DataProcessRunStatus.class, DataProcessRunStatus.$UNKNOWN);
                return this._statusField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataProcessRunStatus getStatus() {
        if (this._statusField != null) {
            return this._statusField;
        }
        Object __rawValue = this._map.get("status");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("status");
        }
        this._statusField = DataTemplateUtil.coerceEnumOutput(__rawValue, DataProcessRunStatus.class, DataProcessRunStatus.$UNKNOWN);
        return this._statusField;
    }

    public DataProcessInstanceRunEvent setStatus(@Nullable DataProcessRunStatus value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStatus(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field status of com.linkedin.dataprocess.DataProcessInstanceRunEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "status", value.name());
                this._statusField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStatus();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "status", value.name());
                this._statusField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "status", value.name());
                this._statusField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceRunEvent setStatus(@Nonnull DataProcessRunStatus value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field status of com.linkedin.dataprocess.DataProcessInstanceRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "status", value.name());
        this._statusField = value;
        return this;
    }

    public boolean hasAttempt() {
        if (this._attemptField != null) {
            return true;
        }
        return this._map.containsKey("attempt");
    }

    public void removeAttempt() {
        this._map.remove("attempt");
    }

    @Nullable
    public Integer getAttempt(GetMode mode) {
        return this.getAttempt();
    }

    @Nullable
    public Integer getAttempt() {
        if (this._attemptField != null) {
            return this._attemptField;
        }
        Object __rawValue = this._map.get("attempt");
        this._attemptField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._attemptField;
    }

    public DataProcessInstanceRunEvent setAttempt(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAttempt(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAttempt();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "attempt", DataTemplateUtil.coerceIntInput(value));
                this._attemptField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "attempt", DataTemplateUtil.coerceIntInput(value));
                this._attemptField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceRunEvent setAttempt(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field attempt of com.linkedin.dataprocess.DataProcessInstanceRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "attempt", DataTemplateUtil.coerceIntInput(value));
        this._attemptField = value;
        return this;
    }

    public DataProcessInstanceRunEvent setAttempt(int value) {
        CheckedUtil.putWithoutChecking(this._map, "attempt", DataTemplateUtil.coerceIntInput(value));
        this._attemptField = value;
        return this;
    }

    public boolean hasResult() {
        if (this._resultField != null) {
            return true;
        }
        return this._map.containsKey("result");
    }

    public void removeResult() {
        this._map.remove("result");
    }

    @Nullable
    public DataProcessInstanceRunResult getResult(GetMode mode) {
        return this.getResult();
    }

    @Nullable
    public DataProcessInstanceRunResult getResult() {
        if (this._resultField != null) {
            return this._resultField;
        }
        Object __rawValue = this._map.get("result");
        this._resultField = __rawValue == null ? null : new DataProcessInstanceRunResult(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._resultField;
    }

    public DataProcessInstanceRunEvent setResult(@Nullable DataProcessInstanceRunResult value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setResult(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeResult();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "result", value.data());
                this._resultField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "result", value.data());
                this._resultField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceRunEvent setResult(@Nonnull DataProcessInstanceRunResult value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field result of com.linkedin.dataprocess.DataProcessInstanceRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "result", value.data());
        this._resultField = value;
        return this;
    }

    public boolean hasDurationMillis() {
        if (this._durationMillisField != null) {
            return true;
        }
        return this._map.containsKey("durationMillis");
    }

    public void removeDurationMillis() {
        this._map.remove("durationMillis");
    }

    @Nullable
    public Long getDurationMillis(GetMode mode) {
        return this.getDurationMillis();
    }

    @Nullable
    public Long getDurationMillis() {
        if (this._durationMillisField != null) {
            return this._durationMillisField;
        }
        Object __rawValue = this._map.get("durationMillis");
        this._durationMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._durationMillisField;
    }

    public DataProcessInstanceRunEvent setDurationMillis(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDurationMillis(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDurationMillis();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "durationMillis", DataTemplateUtil.coerceLongInput(value));
                this._durationMillisField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "durationMillis", DataTemplateUtil.coerceLongInput(value));
                this._durationMillisField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceRunEvent setDurationMillis(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field durationMillis of com.linkedin.dataprocess.DataProcessInstanceRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "durationMillis", DataTemplateUtil.coerceLongInput(value));
        this._durationMillisField = value;
        return this;
    }

    public DataProcessInstanceRunEvent setDurationMillis(long value) {
        CheckedUtil.putWithoutChecking(this._map, "durationMillis", DataTemplateUtil.coerceLongInput(value));
        this._durationMillisField = value;
        return this;
    }

    @Override
    public DataProcessInstanceRunEvent clone() throws CloneNotSupportedException {
        DataProcessInstanceRunEvent __clone = (DataProcessInstanceRunEvent)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataProcessInstanceRunEvent copy() throws CloneNotSupportedException {
        DataProcessInstanceRunEvent __copy = (DataProcessInstanceRunEvent)super.copy();
        __copy._resultField = null;
        __copy._externalUrlField = null;
        __copy._timestampMillisField = null;
        __copy._eventGranularityField = null;
        __copy._messageIdField = null;
        __copy._durationMillisField = null;
        __copy._partitionSpecField = null;
        __copy._attemptField = null;
        __copy._statusField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_MessageId = SCHEMA.getField("messageId");
        FIELD_ExternalUrl = SCHEMA.getField("externalUrl");
        FIELD_Status = SCHEMA.getField("status");
        FIELD_Attempt = SCHEMA.getField("attempt");
        FIELD_Result = SCHEMA.getField("result");
        FIELD_DurationMillis = SCHEMA.getField("durationMillis");
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
        DEFAULT_PartitionSpec = FIELD_PartitionSpec.getDefault() == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(FIELD_PartitionSpec.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataProcessInstanceRunEvent __objectRef;

        private ChangeListener(DataProcessInstanceRunEvent reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "result": {
                    this.__objectRef._resultField = null;
                    break;
                }
                case "externalUrl": {
                    this.__objectRef._externalUrlField = null;
                    break;
                }
                case "timestampMillis": {
                    this.__objectRef._timestampMillisField = null;
                    break;
                }
                case "eventGranularity": {
                    this.__objectRef._eventGranularityField = null;
                    break;
                }
                case "messageId": {
                    this.__objectRef._messageIdField = null;
                    break;
                }
                case "durationMillis": {
                    this.__objectRef._durationMillisField = null;
                    break;
                }
                case "partitionSpec": {
                    this.__objectRef._partitionSpecField = null;
                    break;
                }
                case "attempt": {
                    this.__objectRef._attemptField = null;
                    break;
                }
                case "status": {
                    this.__objectRef._statusField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec timestampMillis() {
            return new PathSpec(this.getPathComponents(), "timestampMillis");
        }

        public TimeWindowSize.Fields eventGranularity() {
            return new TimeWindowSize.Fields(this.getPathComponents(), "eventGranularity");
        }

        public PartitionSpec.Fields partitionSpec() {
            return new PartitionSpec.Fields(this.getPathComponents(), "partitionSpec");
        }

        public PathSpec messageId() {
            return new PathSpec(this.getPathComponents(), "messageId");
        }

        public PathSpec externalUrl() {
            return new PathSpec(this.getPathComponents(), "externalUrl");
        }

        public PathSpec status() {
            return new PathSpec(this.getPathComponents(), "status");
        }

        public PathSpec attempt() {
            return new PathSpec(this.getPathComponents(), "attempt");
        }

        public DataProcessInstanceRunResult.Fields result() {
            return new DataProcessInstanceRunResult.Fields(this.getPathComponents(), "result");
        }

        public PathSpec durationMillis() {
            return new PathSpec(this.getPathComponents(), "durationMillis");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeWindowSize.ProjectionMask _eventGranularityMask;
        private PartitionSpec.ProjectionMask _partitionSpecMask;
        private DataProcessInstanceRunResult.ProjectionMask _resultMask;

        ProjectionMask() {
            super(12);
        }

        public ProjectionMask withTimestampMillis() {
            this.getDataMap().put("timestampMillis", 1);
            return this;
        }

        public ProjectionMask withEventGranularity(Function<TimeWindowSize.ProjectionMask, TimeWindowSize.ProjectionMask> nestedMask) {
            this._eventGranularityMask = nestedMask.apply(this._eventGranularityMask == null ? TimeWindowSize.createMask() : this._eventGranularityMask);
            this.getDataMap().put("eventGranularity", this._eventGranularityMask.getDataMap());
            return this;
        }

        public ProjectionMask withEventGranularity() {
            this._eventGranularityMask = null;
            this.getDataMap().put("eventGranularity", 1);
            return this;
        }

        public ProjectionMask withPartitionSpec(Function<PartitionSpec.ProjectionMask, PartitionSpec.ProjectionMask> nestedMask) {
            this._partitionSpecMask = nestedMask.apply(this._partitionSpecMask == null ? PartitionSpec.createMask() : this._partitionSpecMask);
            this.getDataMap().put("partitionSpec", this._partitionSpecMask.getDataMap());
            return this;
        }

        public ProjectionMask withPartitionSpec() {
            this._partitionSpecMask = null;
            this.getDataMap().put("partitionSpec", 1);
            return this;
        }

        public ProjectionMask withMessageId() {
            this.getDataMap().put("messageId", 1);
            return this;
        }

        public ProjectionMask withExternalUrl() {
            this.getDataMap().put("externalUrl", 1);
            return this;
        }

        public ProjectionMask withStatus() {
            this.getDataMap().put("status", 1);
            return this;
        }

        public ProjectionMask withAttempt() {
            this.getDataMap().put("attempt", 1);
            return this;
        }

        public ProjectionMask withResult(Function<DataProcessInstanceRunResult.ProjectionMask, DataProcessInstanceRunResult.ProjectionMask> nestedMask) {
            this._resultMask = nestedMask.apply(this._resultMask == null ? DataProcessInstanceRunResult.createMask() : this._resultMask);
            this.getDataMap().put("result", this._resultMask.getDataMap());
            return this;
        }

        public ProjectionMask withResult() {
            this._resultMask = null;
            this.getDataMap().put("result", 1);
            return this;
        }

        public ProjectionMask withDurationMillis() {
            this.getDataMap().put("durationMillis", 1);
            return this;
        }
    }
}

