/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.generator;

import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.generator.SampleDataCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;

public class DefaultSampleDataCallback
implements SampleDataCallback {
    private final Float[] _floats = new Float[]{Float.valueOf(3.14f), Float.valueOf(2.71f), Float.valueOf(1.41f), Float.valueOf(1.61f)};
    public static final SampleDataCallback INSTANCE = new DefaultSampleDataCallback();
    private static final Random _random = new Random();
    private final Map<String, Pattern> _compiledPatterns = new HashMap<String, Pattern>();
    private final Map<String, String[]> _stringPool;
    private final String[] _defaultStrings;

    public DefaultSampleDataCallback(Map<String, String[]> stringPool, String[] defaultStrings) {
        this._stringPool = stringPool;
        this._defaultStrings = defaultStrings;
        this.compilePatterns(this._stringPool.keySet());
    }

    private int nonNegative(int max) {
        return Math.abs(_random.nextInt(max + 1));
    }

    private <T> T valueFromArray(T[] array) {
        return array[this.nonNegative(array.length - 1)];
    }

    @Override
    public boolean getBoolean(String fieldName) {
        return _random.nextBoolean();
    }

    @Override
    public int getInteger(String fieldName) {
        return this.nonNegative(10);
    }

    @Override
    public long getLong(String fieldName) {
        return this.nonNegative(10);
    }

    @Override
    public float getFloat(String fieldName) {
        return this.valueFromArray(this._floats).floatValue();
    }

    @Override
    public double getDouble(String fieldName) {
        return this.valueFromArray(this._floats).floatValue();
    }

    @Override
    public ByteString getBytes(String fieldName) {
        return ByteString.copy(this.getString(fieldName).getBytes(Data.UTF_8_CHARSET));
    }

    @Override
    public String getString(String fieldName) {
        String[] candidateStrings = null;
        if (fieldName != null) {
            for (Map.Entry<String, String[]> poolPair : this._stringPool.entrySet()) {
                if (!this._compiledPatterns.get(poolPair.getKey()).matcher(fieldName).find()) continue;
                candidateStrings = poolPair.getValue();
                break;
            }
        }
        if (candidateStrings == null) {
            candidateStrings = this._defaultStrings;
        }
        return this.valueFromArray(candidateStrings);
    }

    @Override
    public ByteString getFixed(String fieldName, FixedDataSchema schema) {
        byte[] bytes = new byte[schema.getSize()];
        _random.nextBytes(bytes);
        return ByteString.copy(bytes);
    }

    @Override
    public String getEnum(String fieldName, EnumDataSchema enumDataSchema) {
        List<String> symbols = enumDataSchema.getSymbols();
        if (symbols.size() < 1) {
            return "EmptyEnum";
        }
        return symbols.get(this.nonNegative(symbols.size() - 1));
    }

    private DefaultSampleDataCallback() {
        this._stringPool = new HashMap<String, String[]>();
        this._stringPool.put("url|link", new String[]{"http://www.example.com", "http://rest.li"});
        this._stringPool.put("name", new String[]{"John", "Doe"});
        this._stringPool.put("email|emailAddress|email_address", new String[]{"foo@example.com", "bar@rest.li"});
        this._stringPool.put("description|summary", new String[]{"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.", "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.", "Aesthetic sustainable raw denim messenger bag narwhal 8-bit, ethnic vegan craft beer quinoa selvage authentic dolor.", "Vegan commodo kogi twee, consectetur single-origin coffee readymade swag.", "Organic american apparel eiusmod, high life craft beer mollit polaroid lo-fi sed culpa.", "Lo-fi vinyl 3 wolf moon hoodie PBR eiusmod farm-to-table next level, est aliqua sriracha pour-over raw denim"});
        this._defaultStrings = new String[]{"foo", "bar", "baz"};
        this.compilePatterns(this._stringPool.keySet());
    }

    private void compilePatterns(Set<String> fieldNameRegexs) {
        for (String regex : fieldNameRegexs) {
            this._compiledPatterns.put(regex, Pattern.compile(regex, 2));
        }
    }
}

