/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.entitystream;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.ProtobufCodecOptions;
import com.linkedin.data.codec.entitystream.AbstractDataDecoder;
import com.linkedin.data.codec.entitystream.ProtobufDataDecoder;
import com.linkedin.data.codec.entitystream.ProtobufDataEncoder;
import com.linkedin.data.codec.entitystream.StreamDataCodec;
import com.linkedin.entitystream.EntityStream;
import com.linkedin.entitystream.EntityStreams;
import java.util.concurrent.CompletionStage;

public class ProtobufStreamDataCodec
implements StreamDataCodec {
    protected final int _bufferSize;
    protected final ProtobufCodecOptions _options;

    public ProtobufStreamDataCodec(int bufferSize) {
        this(bufferSize, new ProtobufCodecOptions.Builder().setEnableASCIIOnlyStrings(true).build());
    }

    public ProtobufStreamDataCodec(int bufferSize, ProtobufCodecOptions options) {
        this._bufferSize = bufferSize;
        this._options = options;
    }

    @Override
    public CompletionStage<DataMap> decodeMap(EntityStream<ByteString> entityStream) {
        ProtobufDataDecoder decoder = new ProtobufDataDecoder(this._options.getSymbolTable(), AbstractDataDecoder.START_OBJECT_TOKEN);
        entityStream.setReader(decoder);
        return decoder.getResult();
    }

    @Override
    public CompletionStage<DataList> decodeList(EntityStream<ByteString> entityStream) {
        ProtobufDataDecoder decoder = new ProtobufDataDecoder(this._options.getSymbolTable(), AbstractDataDecoder.START_ARRAY_TOKEN);
        entityStream.setReader(decoder);
        return decoder.getResult();
    }

    @Override
    public EntityStream<ByteString> encodeMap(DataMap map) {
        return EntityStreams.newEntityStream(new ProtobufDataEncoder(map, this._bufferSize, this._options));
    }

    @Override
    public EntityStream<ByteString> encodeList(DataList list) {
        return EntityStreams.newEntityStream(new ProtobufDataEncoder(list, this._bufferSize, this._options));
    }
}

