/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import com.linkedin.common.urn.DataPlatformUrn;
import com.linkedin.common.urn.TupleKey;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DirectCoercer;
import com.linkedin.data.template.TemplateOutputCastException;
import java.net.URISyntaxException;

public final class DataPlatformInstanceUrn
extends Urn {
    public static final String ENTITY_TYPE = "dataPlatformInstance";
    private final DataPlatformUrn _platform;
    private final String _instanceId;

    public DataPlatformInstanceUrn(DataPlatformUrn platform, String instanceId) {
        super(ENTITY_TYPE, TupleKey.create(platform, instanceId));
        this._platform = platform;
        this._instanceId = instanceId;
    }

    public DataPlatformUrn getPlatformEntity() {
        return this._platform;
    }

    public String getInstance() {
        return this._instanceId;
    }

    public static DataPlatformInstanceUrn createFromString(String rawUrn) throws URISyntaxException {
        return DataPlatformInstanceUrn.createFromUrn(Urn.createFromString(rawUrn));
    }

    public static DataPlatformInstanceUrn createFromUrn(Urn urn) throws URISyntaxException {
        if (!"li".equals(urn.getNamespace())) {
            throw new URISyntaxException(urn.toString(), "Urn namespace type should be 'li'.");
        }
        if (!ENTITY_TYPE.equals(urn.getEntityType())) {
            throw new URISyntaxException(urn.toString(), "Urn entity type should be 'dataPlatformInstance'.");
        }
        TupleKey key = urn.getEntityKey();
        if (key.size() != 2) {
            throw new URISyntaxException(urn.toString(), "Invalid number of keys.");
        }
        try {
            return new DataPlatformInstanceUrn(key.getAs(0, DataPlatformUrn.class), key.getAs(1, String.class));
        }
        catch (Exception e) {
            throw new URISyntaxException(urn.toString(), "Invalid URN Parameter: '" + e.getMessage());
        }
    }

    public static DataPlatformInstanceUrn deserialize(String rawUrn) throws URISyntaxException {
        return DataPlatformInstanceUrn.createFromString(rawUrn);
    }

    static {
        Custom.initializeCustomClass(DataPlatformUrn.class);
        Custom.initializeCustomClass(DataPlatformInstanceUrn.class);
        Custom.registerCoercer(new DirectCoercer<DataPlatformInstanceUrn>(){

            @Override
            public Object coerceInput(DataPlatformInstanceUrn object) throws ClassCastException {
                return object.toString();
            }

            @Override
            public DataPlatformInstanceUrn coerceOutput(Object object) throws TemplateOutputCastException {
                try {
                    return DataPlatformInstanceUrn.createFromString((String)object);
                }
                catch (URISyntaxException e) {
                    throw new TemplateOutputCastException("Invalid URN syntax: " + e.getMessage(), e);
                }
            }
        }, DataPlatformInstanceUrn.class);
    }
}

