/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.callback;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.MultiException;
import com.linkedin.common.util.None;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class MultiCallback
implements Callback<None> {
    private final Callback<None> _callback;
    private final AtomicInteger _count;
    private final Collection<Throwable> _exceptions;

    public MultiCallback(Callback<None> orig, int count) {
        if (count < 1) {
            throw new IllegalArgumentException();
        }
        this._count = new AtomicInteger(count);
        this._exceptions = new ConcurrentLinkedQueue<Throwable>();
        this._callback = orig;
    }

    @Override
    public void onSuccess(None t2) {
        this.checkDone();
    }

    @Override
    public void onError(Throwable e) {
        this._exceptions.add(e);
        this.checkDone();
    }

    private void checkDone() {
        if (this._count.decrementAndGet() == 0) {
            if (this._exceptions.isEmpty()) {
                this._callback.onSuccess(None.none());
            } else {
                this._callback.onError(new MultiException(this._exceptions));
            }
        }
    }
}

