/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.FormAssociationArray;
import com.linkedin.common.FormVerificationAssociationArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Forms
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Forms that are assigned to this entity to be filled out*/@Aspect.name=\"forms\"record Forms{/**All incomplete forms assigned to the entity.*/@Searchable={\"/*/completedPrompts/*/id\":{\"fieldName\":\"incompleteFormsCompletedPromptIds\",\"fieldType\":\"KEYWORD\",\"queryByDefault\":false},\"/*/completedPrompts/*/lastModified/time\":{\"fieldName\":\"incompleteFormsCompletedPromptResponseTimes\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false},\"/*/incompletePrompts/*/id\":{\"fieldName\":\"incompleteFormsIncompletePromptIds\",\"fieldType\":\"KEYWORD\",\"queryByDefault\":false},\"/*/urn\":{\"fieldName\":\"incompleteForms\",\"fieldType\":\"URN\",\"queryByDefault\":false}}incompleteForms:array[/**Properties of an applied form.*/record FormAssociation{/**Urn of the applied form*/urn:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**A list of prompts that are not yet complete for this form.*/incompletePrompts:array[/**Information about the status of a particular prompt.\nNote that this is where we can add additional information about individual responses:\nactor, timestamp, and the response itself.*/record FormPromptAssociation{/**The id for the prompt. This must be GLOBALLY UNIQUE.*/id:string/**The last time this prompt was touched for the entity (set, unset)*/lastModified:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}/**Optional information about the field-level prompt associations.*/fieldAssociations:optional/**Information about the field-level prompt associations on a top-level prompt association.*/record FormPromptFieldAssociations{/**A list of field-level prompt associations that are not yet complete for this form.*/completedFieldPrompts:optional array[/**Information about the status of a particular prompt for a specific schema field\non an entity.*/record FieldFormPromptAssociation{/**The field path on a schema field.*/fieldPath:string/**The last time this prompt was touched for the field on the entity (set, unset)*/lastModified:AuditStamp}]/**A list of field-level prompt associations that are complete for this form.*/incompleteFieldPrompts:optional array[FieldFormPromptAssociation]}}]=[]/**A list of prompts that have been completed for this form.*/completedPrompts:array[FormPromptAssociation]=[]}]/**All complete forms assigned to the entity.*/@Searchable={\"/*/completedPrompts/*/id\":{\"fieldName\":\"completedFormsCompletedPromptIds\",\"fieldType\":\"KEYWORD\",\"queryByDefault\":false},\"/*/completedPrompts/*/lastModified/time\":{\"fieldName\":\"completedFormsCompletedPromptResponseTimes\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false},\"/*/incompletePrompts/*/id\":{\"fieldName\":\"completedFormsIncompletePromptIds\",\"fieldType\":\"KEYWORD\",\"queryByDefault\":false},\"/*/urn\":{\"fieldName\":\"completedForms\",\"fieldType\":\"URN\",\"queryByDefault\":false}}completedForms:array[FormAssociation]/**Verifications that have been applied to the entity via completed forms.*/@Searchable.`/*/form`={\"fieldName\":\"verifiedForms\",\"fieldType\":\"URN\",\"queryByDefault\":false}verifications:array[/**An association between a verification and an entity that has been granted\nvia completion of one or more forms of type 'VERIFICATION'.*/record FormVerificationAssociation{/**The urn of the form that granted this verification.*/form:Urn/**An audit stamp capturing who and when verification was applied for this form.*/lastModified:optional AuditStamp}]=[]}", SchemaFormatType.PDL);
    private FormAssociationArray _incompleteFormsField = null;
    private FormAssociationArray _completedFormsField = null;
    private FormVerificationAssociationArray _verificationsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_IncompleteForms = SCHEMA.getField("incompleteForms");
    private static final RecordDataSchema.Field FIELD_CompletedForms = SCHEMA.getField("completedForms");
    private static final RecordDataSchema.Field FIELD_Verifications = SCHEMA.getField("verifications");
    private static final FormVerificationAssociationArray DEFAULT_Verifications = FIELD_Verifications.getDefault() == null ? null : new FormVerificationAssociationArray(DataTemplateUtil.castOrThrow(FIELD_Verifications.getDefault(), DataList.class));

    public Forms() {
        super(new DataMap(4, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public Forms(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasIncompleteForms() {
        if (this._incompleteFormsField != null) {
            return true;
        }
        return this._map.containsKey("incompleteForms");
    }

    public void removeIncompleteForms() {
        this._map.remove("incompleteForms");
    }

    @Nullable
    public FormAssociationArray getIncompleteForms(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getIncompleteForms();
            }
            case DEFAULT: 
            case NULL: {
                if (this._incompleteFormsField != null) {
                    return this._incompleteFormsField;
                }
                Object __rawValue = this._map.get("incompleteForms");
                this._incompleteFormsField = __rawValue == null ? null : new FormAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._incompleteFormsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FormAssociationArray getIncompleteForms() {
        if (this._incompleteFormsField != null) {
            return this._incompleteFormsField;
        }
        Object __rawValue = this._map.get("incompleteForms");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("incompleteForms");
        }
        this._incompleteFormsField = __rawValue == null ? null : new FormAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._incompleteFormsField;
    }

    public Forms setIncompleteForms(@Nullable FormAssociationArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIncompleteForms(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field incompleteForms of com.linkedin.common.Forms");
                }
                CheckedUtil.putWithoutChecking(this._map, "incompleteForms", value.data());
                this._incompleteFormsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIncompleteForms();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "incompleteForms", value.data());
                this._incompleteFormsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "incompleteForms", value.data());
                this._incompleteFormsField = value;
            }
        }
        return this;
    }

    public Forms setIncompleteForms(@Nonnull FormAssociationArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field incompleteForms of com.linkedin.common.Forms to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "incompleteForms", value.data());
        this._incompleteFormsField = value;
        return this;
    }

    public boolean hasCompletedForms() {
        if (this._completedFormsField != null) {
            return true;
        }
        return this._map.containsKey("completedForms");
    }

    public void removeCompletedForms() {
        this._map.remove("completedForms");
    }

    @Nullable
    public FormAssociationArray getCompletedForms(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCompletedForms();
            }
            case DEFAULT: 
            case NULL: {
                if (this._completedFormsField != null) {
                    return this._completedFormsField;
                }
                Object __rawValue = this._map.get("completedForms");
                this._completedFormsField = __rawValue == null ? null : new FormAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._completedFormsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FormAssociationArray getCompletedForms() {
        if (this._completedFormsField != null) {
            return this._completedFormsField;
        }
        Object __rawValue = this._map.get("completedForms");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("completedForms");
        }
        this._completedFormsField = __rawValue == null ? null : new FormAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._completedFormsField;
    }

    public Forms setCompletedForms(@Nullable FormAssociationArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCompletedForms(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field completedForms of com.linkedin.common.Forms");
                }
                CheckedUtil.putWithoutChecking(this._map, "completedForms", value.data());
                this._completedFormsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCompletedForms();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "completedForms", value.data());
                this._completedFormsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "completedForms", value.data());
                this._completedFormsField = value;
            }
        }
        return this;
    }

    public Forms setCompletedForms(@Nonnull FormAssociationArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field completedForms of com.linkedin.common.Forms to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "completedForms", value.data());
        this._completedFormsField = value;
        return this;
    }

    public boolean hasVerifications() {
        if (this._verificationsField != null) {
            return true;
        }
        return this._map.containsKey("verifications");
    }

    public void removeVerifications() {
        this._map.remove("verifications");
    }

    @Nullable
    public FormVerificationAssociationArray getVerifications(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getVerifications();
            }
            case NULL: {
                if (this._verificationsField != null) {
                    return this._verificationsField;
                }
                Object __rawValue = this._map.get("verifications");
                this._verificationsField = __rawValue == null ? null : new FormVerificationAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._verificationsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FormVerificationAssociationArray getVerifications() {
        if (this._verificationsField != null) {
            return this._verificationsField;
        }
        Object __rawValue = this._map.get("verifications");
        if (__rawValue == null) {
            return DEFAULT_Verifications;
        }
        this._verificationsField = __rawValue == null ? null : new FormVerificationAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._verificationsField;
    }

    public Forms setVerifications(@Nullable FormVerificationAssociationArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVerifications(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field verifications of com.linkedin.common.Forms");
                }
                CheckedUtil.putWithoutChecking(this._map, "verifications", value.data());
                this._verificationsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVerifications();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "verifications", value.data());
                this._verificationsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "verifications", value.data());
                this._verificationsField = value;
            }
        }
        return this;
    }

    public Forms setVerifications(@Nonnull FormVerificationAssociationArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field verifications of com.linkedin.common.Forms to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "verifications", value.data());
        this._verificationsField = value;
        return this;
    }

    @Override
    public Forms clone() throws CloneNotSupportedException {
        Forms __clone = (Forms)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Forms copy() throws CloneNotSupportedException {
        Forms __copy = (Forms)super.copy();
        __copy._completedFormsField = null;
        __copy._verificationsField = null;
        __copy._incompleteFormsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Forms __objectRef;

        private ChangeListener(Forms reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "completedForms": {
                    this.__objectRef._completedFormsField = null;
                    break;
                }
                case "verifications": {
                    this.__objectRef._verificationsField = null;
                    break;
                }
                case "incompleteForms": {
                    this.__objectRef._incompleteFormsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public FormAssociationArray.Fields incompleteForms() {
            return new FormAssociationArray.Fields(this.getPathComponents(), "incompleteForms");
        }

        public PathSpec incompleteForms(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "incompleteForms");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public FormAssociationArray.Fields completedForms() {
            return new FormAssociationArray.Fields(this.getPathComponents(), "completedForms");
        }

        public PathSpec completedForms(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "completedForms");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public FormVerificationAssociationArray.Fields verifications() {
            return new FormVerificationAssociationArray.Fields(this.getPathComponents(), "verifications");
        }

        public PathSpec verifications(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "verifications");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private FormAssociationArray.ProjectionMask _incompleteFormsMask;
        private FormAssociationArray.ProjectionMask _completedFormsMask;
        private FormVerificationAssociationArray.ProjectionMask _verificationsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withIncompleteForms(Function<FormAssociationArray.ProjectionMask, FormAssociationArray.ProjectionMask> nestedMask) {
            this._incompleteFormsMask = nestedMask.apply(this._incompleteFormsMask == null ? FormAssociationArray.createMask() : this._incompleteFormsMask);
            this.getDataMap().put("incompleteForms", this._incompleteFormsMask.getDataMap());
            return this;
        }

        public ProjectionMask withIncompleteForms() {
            this._incompleteFormsMask = null;
            this.getDataMap().put("incompleteForms", 1);
            return this;
        }

        public ProjectionMask withIncompleteForms(Function<FormAssociationArray.ProjectionMask, FormAssociationArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._incompleteFormsMask = nestedMask.apply(this._incompleteFormsMask == null ? FormAssociationArray.createMask() : this._incompleteFormsMask);
            this.getDataMap().put("incompleteForms", this._incompleteFormsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("incompleteForms").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("incompleteForms").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withIncompleteForms(Integer start, Integer count) {
            this._incompleteFormsMask = null;
            this.getDataMap().put("incompleteForms", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("incompleteForms").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("incompleteForms").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withCompletedForms(Function<FormAssociationArray.ProjectionMask, FormAssociationArray.ProjectionMask> nestedMask) {
            this._completedFormsMask = nestedMask.apply(this._completedFormsMask == null ? FormAssociationArray.createMask() : this._completedFormsMask);
            this.getDataMap().put("completedForms", this._completedFormsMask.getDataMap());
            return this;
        }

        public ProjectionMask withCompletedForms() {
            this._completedFormsMask = null;
            this.getDataMap().put("completedForms", 1);
            return this;
        }

        public ProjectionMask withCompletedForms(Function<FormAssociationArray.ProjectionMask, FormAssociationArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._completedFormsMask = nestedMask.apply(this._completedFormsMask == null ? FormAssociationArray.createMask() : this._completedFormsMask);
            this.getDataMap().put("completedForms", this._completedFormsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("completedForms").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("completedForms").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withCompletedForms(Integer start, Integer count) {
            this._completedFormsMask = null;
            this.getDataMap().put("completedForms", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("completedForms").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("completedForms").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withVerifications(Function<FormVerificationAssociationArray.ProjectionMask, FormVerificationAssociationArray.ProjectionMask> nestedMask) {
            this._verificationsMask = nestedMask.apply(this._verificationsMask == null ? FormVerificationAssociationArray.createMask() : this._verificationsMask);
            this.getDataMap().put("verifications", this._verificationsMask.getDataMap());
            return this;
        }

        public ProjectionMask withVerifications() {
            this._verificationsMask = null;
            this.getDataMap().put("verifications", 1);
            return this;
        }

        public ProjectionMask withVerifications(Function<FormVerificationAssociationArray.ProjectionMask, FormVerificationAssociationArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._verificationsMask = nestedMask.apply(this._verificationsMask == null ? FormVerificationAssociationArray.createMask() : this._verificationsMask);
            this.getDataMap().put("verifications", this._verificationsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("verifications").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("verifications").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withVerifications(Integer start, Integer count) {
            this._verificationsMask = null;
            this.getDataMap().put("verifications", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("verifications").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("verifications").put("$count", count);
            }
            return this;
        }
    }
}

