/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.DataTransformArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataTransformLogic
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Information about a Query against one or more data assets (e.g. Tables or Views).*/@Aspect.name=\"dataTransformLogic\"record DataTransformLogic{/**List of transformations applied*/transforms:array[/**Information about a transformation. It may be a query,*/record DataTransform{/**The data transform may be defined by a query statement*/queryStatement:optional{namespace com.linkedin.query/**A query statement against one or more data assets.*/record QueryStatement{/**The query text*/value:string/**The language of the Query, e.g. SQL.*/language:enum QueryLanguage{/**A SQL Query*/SQL/**Unknown query language*/UNKNOWN}=\"SQL\"}}}]}", SchemaFormatType.PDL);
    private DataTransformArray _transformsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Transforms = SCHEMA.getField("transforms");

    public DataTransformLogic() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public DataTransformLogic(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTransforms() {
        if (this._transformsField != null) {
            return true;
        }
        return this._map.containsKey("transforms");
    }

    public void removeTransforms() {
        this._map.remove("transforms");
    }

    @Nullable
    public DataTransformArray getTransforms(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTransforms();
            }
            case DEFAULT: 
            case NULL: {
                if (this._transformsField != null) {
                    return this._transformsField;
                }
                Object __rawValue = this._map.get("transforms");
                this._transformsField = __rawValue == null ? null : new DataTransformArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._transformsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataTransformArray getTransforms() {
        if (this._transformsField != null) {
            return this._transformsField;
        }
        Object __rawValue = this._map.get("transforms");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("transforms");
        }
        this._transformsField = __rawValue == null ? null : new DataTransformArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._transformsField;
    }

    public DataTransformLogic setTransforms(@Nullable DataTransformArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTransforms(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field transforms of com.linkedin.common.DataTransformLogic");
                }
                CheckedUtil.putWithoutChecking(this._map, "transforms", value.data());
                this._transformsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTransforms();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "transforms", value.data());
                this._transformsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "transforms", value.data());
                this._transformsField = value;
            }
        }
        return this;
    }

    public DataTransformLogic setTransforms(@Nonnull DataTransformArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field transforms of com.linkedin.common.DataTransformLogic to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "transforms", value.data());
        this._transformsField = value;
        return this;
    }

    @Override
    public DataTransformLogic clone() throws CloneNotSupportedException {
        DataTransformLogic __clone = (DataTransformLogic)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataTransformLogic copy() throws CloneNotSupportedException {
        DataTransformLogic __copy = (DataTransformLogic)super.copy();
        __copy._transformsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataTransformLogic __objectRef;

        private ChangeListener(DataTransformLogic reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "transforms": {
                    this.__objectRef._transformsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public DataTransformArray.Fields transforms() {
            return new DataTransformArray.Fields(this.getPathComponents(), "transforms");
        }

        public PathSpec transforms(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "transforms");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private DataTransformArray.ProjectionMask _transformsMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withTransforms(Function<DataTransformArray.ProjectionMask, DataTransformArray.ProjectionMask> nestedMask) {
            this._transformsMask = nestedMask.apply(this._transformsMask == null ? DataTransformArray.createMask() : this._transformsMask);
            this.getDataMap().put("transforms", this._transformsMask.getDataMap());
            return this;
        }

        public ProjectionMask withTransforms() {
            this._transformsMask = null;
            this.getDataMap().put("transforms", 1);
            return this;
        }

        public ProjectionMask withTransforms(Function<DataTransformArray.ProjectionMask, DataTransformArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._transformsMask = nestedMask.apply(this._transformsMask == null ? DataTransformArray.createMask() : this._transformsMask);
            this.getDataMap().put("transforms", this._transformsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("transforms").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("transforms").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withTransforms(Integer start, Integer count) {
            this._transformsMask = null;
            this.getDataMap().put("transforms", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("transforms").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("transforms").put("$count", count);
            }
            return this;
        }
    }
}

