/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import java.util.List;

public class CostValue
extends UnionTemplate
implements HasTyperefInfo {
    private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[costId:double,costCode:string]", SchemaFormatType.PDL);
    private Double _costIdMember = null;
    private String _costCodeMember = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final DataSchema MEMBER_CostId = SCHEMA.getTypeByMemberKey("costId");
    public static final String MEMBERKEY_CostId = "costId";
    private static final DataSchema MEMBER_CostCode = SCHEMA.getTypeByMemberKey("costCode");
    public static final String MEMBERKEY_CostCode = "costCode";
    private static final TyperefInfo TYPEREFINFO = new UnionTyperefInfo();

    public CostValue() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public CostValue(Object data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static UnionDataSchema dataSchema() {
        return SCHEMA;
    }

    public static CostValue createWithCostId(Double value) {
        CostValue newUnion = new CostValue();
        newUnion.setCostId(value);
        return newUnion;
    }

    public boolean isCostId() {
        return this.memberIs(MEMBERKEY_CostId);
    }

    public Double getCostId() {
        this.checkNotNull();
        if (this._costIdMember != null) {
            return this._costIdMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_CostId);
        this._costIdMember = DataTemplateUtil.coerceDoubleOutput(__rawValue);
        return this._costIdMember;
    }

    public void setCostId(Double value) {
        this.checkNotNull();
        this._map.clear();
        this._costIdMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_CostId, DataTemplateUtil.coerceDoubleInput(value));
    }

    public static CostValue createWithCostCode(String value) {
        CostValue newUnion = new CostValue();
        newUnion.setCostCode(value);
        return newUnion;
    }

    public boolean isCostCode() {
        return this.memberIs(MEMBERKEY_CostCode);
    }

    public String getCostCode() {
        this.checkNotNull();
        if (this._costCodeMember != null) {
            return this._costCodeMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_CostCode);
        this._costCodeMember = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._costCodeMember;
    }

    public void setCostCode(String value) {
        this.checkNotNull();
        this._map.clear();
        this._costCodeMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_CostCode, value);
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public CostValue clone() throws CloneNotSupportedException {
        CostValue __clone = (CostValue)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CostValue copy() throws CloneNotSupportedException {
        CostValue __copy = (CostValue)super.copy();
        __copy._costCodeMember = null;
        __copy._costIdMember = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    @Override
    public TyperefInfo typerefInfo() {
        return TYPEREFINFO;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CostValue __objectRef;

        private ChangeListener(CostValue reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "costCode": {
                    this.__objectRef._costCodeMember = null;
                    break;
                }
                case "costId": {
                    this.__objectRef._costIdMember = null;
                }
            }
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withCostId() {
            this.getDataMap().put(CostValue.MEMBERKEY_CostId, 1);
            return this;
        }

        public ProjectionMask withCostCode() {
            this.getDataMap().put(CostValue.MEMBERKEY_CostCode, 1);
            return this;
        }
    }

    private static final class UnionTyperefInfo
    extends TyperefInfo {
        private static final TyperefDataSchema SCHEMA = (TyperefDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**A union of all supported Cost Value types*/typeref CostValue=union[costId:double,costCode:string]", SchemaFormatType.PDL);

        public UnionTyperefInfo() {
            super(SCHEMA);
        }

        public static TyperefDataSchema dataSchema() {
            return SCHEMA;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec CostId() {
            return new PathSpec(this.getPathComponents(), CostValue.MEMBERKEY_CostId);
        }

        public PathSpec CostCode() {
            return new PathSpec(this.getPathComponents(), CostValue.MEMBERKEY_CostCode);
        }
    }
}

