/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuditStamp
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}", SchemaFormatType.PDL);
    private Long _timeField = null;
    private Urn _actorField = null;
    private Urn _impersonatorField = null;
    private String _messageField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Time = SCHEMA.getField("time");
    private static final RecordDataSchema.Field FIELD_Actor = SCHEMA.getField("actor");
    private static final RecordDataSchema.Field FIELD_Impersonator = SCHEMA.getField("impersonator");
    private static final RecordDataSchema.Field FIELD_Message = SCHEMA.getField("message");

    public AuditStamp() {
        super(new DataMap(6, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public AuditStamp(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTime() {
        if (this._timeField != null) {
            return true;
        }
        return this._map.containsKey("time");
    }

    public void removeTime() {
        this._map.remove("time");
    }

    @Nullable
    public Long getTime(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTime();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timeField != null) {
                    return this._timeField;
                }
                Object __rawValue = this._map.get("time");
                this._timeField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._timeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getTime() {
        if (this._timeField != null) {
            return this._timeField;
        }
        Object __rawValue = this._map.get("time");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("time");
        }
        this._timeField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timeField;
    }

    public AuditStamp setTime(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTime(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field time of com.linkedin.common.AuditStamp");
                }
                CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
                this._timeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTime();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
                this._timeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
                this._timeField = value;
            }
        }
        return this;
    }

    public AuditStamp setTime(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field time of com.linkedin.common.AuditStamp to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
        this._timeField = value;
        return this;
    }

    public AuditStamp setTime(long value) {
        CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
        this._timeField = value;
        return this;
    }

    public boolean hasActor() {
        if (this._actorField != null) {
            return true;
        }
        return this._map.containsKey("actor");
    }

    public void removeActor() {
        this._map.remove("actor");
    }

    @Nullable
    public Urn getActor(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getActor();
            }
            case DEFAULT: 
            case NULL: {
                if (this._actorField != null) {
                    return this._actorField;
                }
                Object __rawValue = this._map.get("actor");
                this._actorField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._actorField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getActor() {
        if (this._actorField != null) {
            return this._actorField;
        }
        Object __rawValue = this._map.get("actor");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("actor");
        }
        this._actorField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._actorField;
    }

    public AuditStamp setActor(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setActor(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field actor of com.linkedin.common.AuditStamp");
                }
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeActor();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
            }
        }
        return this;
    }

    public AuditStamp setActor(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field actor of com.linkedin.common.AuditStamp to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._actorField = value;
        return this;
    }

    public boolean hasImpersonator() {
        if (this._impersonatorField != null) {
            return true;
        }
        return this._map.containsKey("impersonator");
    }

    public void removeImpersonator() {
        this._map.remove("impersonator");
    }

    @Nullable
    public Urn getImpersonator(GetMode mode) {
        return this.getImpersonator();
    }

    @Nullable
    public Urn getImpersonator() {
        if (this._impersonatorField != null) {
            return this._impersonatorField;
        }
        Object __rawValue = this._map.get("impersonator");
        this._impersonatorField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._impersonatorField;
    }

    public AuditStamp setImpersonator(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setImpersonator(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeImpersonator();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "impersonator", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._impersonatorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "impersonator", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._impersonatorField = value;
            }
        }
        return this;
    }

    public AuditStamp setImpersonator(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field impersonator of com.linkedin.common.AuditStamp to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "impersonator", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._impersonatorField = value;
        return this;
    }

    public boolean hasMessage() {
        if (this._messageField != null) {
            return true;
        }
        return this._map.containsKey("message");
    }

    public void removeMessage() {
        this._map.remove("message");
    }

    @Nullable
    public String getMessage(GetMode mode) {
        return this.getMessage();
    }

    @Nullable
    public String getMessage() {
        if (this._messageField != null) {
            return this._messageField;
        }
        Object __rawValue = this._map.get("message");
        this._messageField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._messageField;
    }

    public AuditStamp setMessage(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMessage(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMessage();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "message", value);
                this._messageField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "message", value);
                this._messageField = value;
            }
        }
        return this;
    }

    public AuditStamp setMessage(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field message of com.linkedin.common.AuditStamp to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "message", value);
        this._messageField = value;
        return this;
    }

    @Override
    public AuditStamp clone() throws CloneNotSupportedException {
        AuditStamp __clone = (AuditStamp)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public AuditStamp copy() throws CloneNotSupportedException {
        AuditStamp __copy = (AuditStamp)super.copy();
        __copy._actorField = null;
        __copy._impersonatorField = null;
        __copy._timeField = null;
        __copy._messageField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final AuditStamp __objectRef;

        private ChangeListener(AuditStamp reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "actor": {
                    this.__objectRef._actorField = null;
                    break;
                }
                case "impersonator": {
                    this.__objectRef._impersonatorField = null;
                    break;
                }
                case "time": {
                    this.__objectRef._timeField = null;
                    break;
                }
                case "message": {
                    this.__objectRef._messageField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec time() {
            return new PathSpec(this.getPathComponents(), "time");
        }

        public PathSpec actor() {
            return new PathSpec(this.getPathComponents(), "actor");
        }

        public PathSpec impersonator() {
            return new PathSpec(this.getPathComponents(), "impersonator");
        }

        public PathSpec message() {
            return new PathSpec(this.getPathComponents(), "message");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withTime() {
            this.getDataMap().put("time", 1);
            return this;
        }

        public ProjectionMask withActor() {
            this.getDataMap().put("actor", 1);
            return this;
        }

        public ProjectionMask withImpersonator() {
            this.getDataMap().put("impersonator", 1);
            return this;
        }

        public ProjectionMask withMessage() {
            this.getDataMap().put("message", 1);
            return this;
        }
    }
}

