/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.chart;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChartUserUsageCounts
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.chart/**Records a single user's usage counts for a given resource*/record ChartUserUsageCounts{/**The unique id of the user.*/user:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The number of times the user has viewed the chart*/@TimeseriesField={}viewsCount:optional int}", SchemaFormatType.PDL);
    private Urn _userField = null;
    private Integer _viewsCountField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_User = SCHEMA.getField("user");
    private static final RecordDataSchema.Field FIELD_ViewsCount = SCHEMA.getField("viewsCount");

    public ChartUserUsageCounts() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public ChartUserUsageCounts(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUser() {
        if (this._userField != null) {
            return true;
        }
        return this._map.containsKey("user");
    }

    public void removeUser() {
        this._map.remove("user");
    }

    @Nullable
    public Urn getUser(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUser();
            }
            case DEFAULT: 
            case NULL: {
                if (this._userField != null) {
                    return this._userField;
                }
                Object __rawValue = this._map.get("user");
                this._userField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._userField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getUser() {
        if (this._userField != null) {
            return this._userField;
        }
        Object __rawValue = this._map.get("user");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("user");
        }
        this._userField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._userField;
    }

    public ChartUserUsageCounts setUser(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUser(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field user of com.linkedin.chart.ChartUserUsageCounts");
                }
                CheckedUtil.putWithoutChecking(this._map, "user", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._userField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUser();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "user", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._userField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "user", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._userField = value;
            }
        }
        return this;
    }

    public ChartUserUsageCounts setUser(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field user of com.linkedin.chart.ChartUserUsageCounts to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "user", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._userField = value;
        return this;
    }

    public boolean hasViewsCount() {
        if (this._viewsCountField != null) {
            return true;
        }
        return this._map.containsKey("viewsCount");
    }

    public void removeViewsCount() {
        this._map.remove("viewsCount");
    }

    @Nullable
    public Integer getViewsCount(GetMode mode) {
        return this.getViewsCount();
    }

    @Nullable
    public Integer getViewsCount() {
        if (this._viewsCountField != null) {
            return this._viewsCountField;
        }
        Object __rawValue = this._map.get("viewsCount");
        this._viewsCountField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._viewsCountField;
    }

    public ChartUserUsageCounts setViewsCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setViewsCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeViewsCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "viewsCount", DataTemplateUtil.coerceIntInput(value));
                this._viewsCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "viewsCount", DataTemplateUtil.coerceIntInput(value));
                this._viewsCountField = value;
            }
        }
        return this;
    }

    public ChartUserUsageCounts setViewsCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field viewsCount of com.linkedin.chart.ChartUserUsageCounts to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "viewsCount", DataTemplateUtil.coerceIntInput(value));
        this._viewsCountField = value;
        return this;
    }

    public ChartUserUsageCounts setViewsCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "viewsCount", DataTemplateUtil.coerceIntInput(value));
        this._viewsCountField = value;
        return this;
    }

    @Override
    public ChartUserUsageCounts clone() throws CloneNotSupportedException {
        ChartUserUsageCounts __clone = (ChartUserUsageCounts)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ChartUserUsageCounts copy() throws CloneNotSupportedException {
        ChartUserUsageCounts __copy = (ChartUserUsageCounts)super.copy();
        __copy._viewsCountField = null;
        __copy._userField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ChartUserUsageCounts __objectRef;

        private ChangeListener(ChartUserUsageCounts reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "viewsCount": {
                    this.__objectRef._viewsCountField = null;
                    break;
                }
                case "user": {
                    this.__objectRef._userField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec user() {
            return new PathSpec(this.getPathComponents(), "user");
        }

        public PathSpec viewsCount() {
            return new PathSpec(this.getPathComponents(), "viewsCount");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withUser() {
            this.getDataMap().put("user", 1);
            return this;
        }

        public ProjectionMask withViewsCount() {
            this.getDataMap().put("viewsCount", 1);
            return this;
        }
    }
}

