/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.FreshnessAssertionSchedule;
import com.linkedin.assertion.FreshnessAssertionType;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.dataset.DatasetFilter;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FreshnessAssertionInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Attributes defining a Freshness Assertion.\n*/record FreshnessAssertionInfo{/**The type of the freshness assertion being monitored.*/@Searchable={}type:enum FreshnessAssertionType{/**An Freshness based on Operations performed on a particular Dataset (insert, update, delete, etc) and sourced from an audit log, as\nopposed to based on the highest watermark in a timestamp column (e.g. a query). Only valid when entity is of type \"dataset\".*/DATASET_CHANGE/**An Freshness based on a successful execution of a Data Job.*/DATA_JOB_RUN}/**The entity targeted by this Freshness check.*/@Relationship={\"entityTypes\":[\"dataset\",\"dataJob\"],\"name\":\"Asserts\"}@Searchable.fieldType=\"URN\"entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Produce FAILURE Assertion Result if the asset is not updated on the cadence and within the time range described by the schedule.*/@Searchable.`/type`.fieldName=\"scheduleType\"schedule:/**Attributes defining a single Freshness schedule.*/record FreshnessAssertionSchedule{/**The type of a Freshness Assertion Schedule.\n\nOnce we support data-time-relative schedules (e.g. schedules relative to time partitions),\nwe will add those schedule types here.*/type:enum FreshnessAssertionScheduleType{/**A highly configurable recurring schedule which describes the times of events described\nby a CRON schedule, with the evaluation schedule assuming to be matching the cron schedule.\n\nIn a CRON schedule type, we compute the look-back window to be the time between the last scheduled event\nand the current event (evaluation time). This means that the evaluation schedule must match exactly\nthe schedule defined inside the cron schedule.\n\nFor example, a CRON schedule defined as \"0 8 * * *\" would represent a schedule of \"every day by 8am\". Assuming\nthat the assertion evaluation schedule is defined to match this, the freshness assertion would be evaluated in the following way:\n\n    1. Compute the \"last scheduled occurrence\" of the event using the CRON schedule. For example, yesterday at 8am.\n    2. Compute the bounds of a time window between the \"last scheduled occurrence\" (yesterday at 8am) until the \"current occurrence\" (today at 8am)\n    3. Verify that the target event has occurred within the CRON-interval window.\n    4. If the target event has occurred within the time window, then assertion passes.\n    5. If the target event has not occurred within the time window, then the assertion fails.\n*/CRON/**A fixed interval which is used to compute a look-back window for use when evaluating the assertion relative\nto the Evaluation Time of the Assertion.\n\nTo compute the valid look-back window, we subtract the fixed interval from the evaluation time. Then, we verify\nthat the target event has occurred within that window.\n\nFor example, a fixed interval of \"24h\" would represent a schedule of \"in the last 24 hours\".\nThe 24 hour interval is relative to the evaluation time of the assertion. For example if we schedule the assertion\nto be evaluated each hour, we'd compute the result as follows:\n\n    1. Subtract the fixed interval from the current time (Evaluation time) to compute the bounds of a fixed look-back window.\n    2. Verify that the target event has occurred within the look-back window.\n    3. If the target event has occurred within the time window, then assertion passes.\n    4. If the target event has not occurred within the time window, then the assertion fails.\n*/FIXED_INTERVAL/**A stateful check that takes the last time this check ran to determine the look-back window.\n\nTo compute the valid look-back- window, we start at the time the monitor last evaluated this assertion,\nand we end at the point in time the check is currently running.\n\nFor example, let's say a Freshness assertion is of type SINCE_THE_LAST_CHECK, and the monitor is configured to\nrun every day at 12:00am. Let's assume this assertion was last evaluated yesterday at 12:04am. We'd compute\nthe result as follows:\n\n    1. Get the timestamp for the last run of the monitor on this assertion.\n    2. look_back_window_start_time = latest_monitor_run.timestampMillis [ie. 12:04a yesterday]\n    3. look_back_window_end_time = nowMillis [ie. 12:02a today]\n    4. If the target event has occurred within the window [ie. 12:04a yday to 12:02a today],\n       then the assertion passes.\n    5. If the target event has not occurred within the window, then the assertion fails.\n*/SINCE_THE_LAST_CHECK}/**A cron schedule. This field is required when type is CRON.*/cron:optional/**Attributes defining a CRON-formatted schedule used for defining a freshness assertion.*/record FreshnessCronSchedule{/**A cron-formatted execution interval, as a cron string, e.g. 1 * * * **/cron:string/**Timezone in which the cron interval applies, e.g. America/Los Angeles*/timezone:string/**An optional offset in milliseconds to SUBTRACT from the timestamp generated by the cron schedule\nto generate the lower bounds of the \"freshness window\", or the window of time in which an event must have occurred in order for the Freshness check\nto be considering passing.\n\nIf left empty, the start of the SLA window will be the _end_ of the previously evaluated Freshness window.*/windowStartOffsetMs:optional long}/**A fixed interval schedule. This field is required when type is FIXED_INTERVAL.*/fixedInterval:optional/**Attributes defining a relative fixed interval SLA schedule.*/record FixedIntervalSchedule includes{namespace com.linkedin.timeseries/**Defines the size of a time window.*/record TimeWindowSize{/**Interval unit such as minute/hour/day etc.*/unit:enum CalendarInterval{SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR}/**How many units. Defaults to 1.*/multiple:int=1}}{}}/**A definition of the specific filters that should be applied, when performing monitoring.\nIf not provided, there is no filter, and the full table is under consideration.*/filter:optional{namespace com.linkedin.dataset/**A definition of filters that should be used when\nquerying an external Dataset or Table.\n\nNote that this models should NOT be used for working with\nsearch / filter on DataHub Platform itself.*/record DatasetFilter{/**How the partition will be represented in this model.\n\nIn the future, we'll likely add support for more structured\npredicates.*/type:enum DatasetFilterType{/**The partition is represented as a an opaque, raw SQL\nclause.*/SQL}/**The raw where clause string which will be used for monitoring.\nRequired if the type is SQL.*/sql:optional string}}}", SchemaFormatType.PDL);
    private FreshnessAssertionType _typeField = null;
    private Urn _entityField = null;
    private FreshnessAssertionSchedule _scheduleField = null;
    private DatasetFilter _filterField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Entity = SCHEMA.getField("entity");
    private static final RecordDataSchema.Field FIELD_Schedule = SCHEMA.getField("schedule");
    private static final RecordDataSchema.Field FIELD_Filter = SCHEMA.getField("filter");

    public FreshnessAssertionInfo() {
        super(new DataMap(6, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public FreshnessAssertionInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public FreshnessAssertionType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FreshnessAssertionType.class, FreshnessAssertionType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FreshnessAssertionType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FreshnessAssertionType.class, FreshnessAssertionType.$UNKNOWN);
        return this._typeField;
    }

    public FreshnessAssertionInfo setType(@Nullable FreshnessAssertionType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.assertion.FreshnessAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public FreshnessAssertionInfo setType(@Nonnull FreshnessAssertionType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.assertion.FreshnessAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasEntity() {
        if (this._entityField != null) {
            return true;
        }
        return this._map.containsKey("entity");
    }

    public void removeEntity() {
        this._map.remove("entity");
    }

    @Nullable
    public Urn getEntity(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntity();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityField != null) {
                    return this._entityField;
                }
                Object __rawValue = this._map.get("entity");
                this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._entityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getEntity() {
        if (this._entityField != null) {
            return this._entityField;
        }
        Object __rawValue = this._map.get("entity");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entity");
        }
        this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityField;
    }

    public FreshnessAssertionInfo setEntity(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entity of com.linkedin.assertion.FreshnessAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
            }
        }
        return this;
    }

    public FreshnessAssertionInfo setEntity(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entity of com.linkedin.assertion.FreshnessAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityField = value;
        return this;
    }

    public boolean hasSchedule() {
        if (this._scheduleField != null) {
            return true;
        }
        return this._map.containsKey("schedule");
    }

    public void removeSchedule() {
        this._map.remove("schedule");
    }

    @Nullable
    public FreshnessAssertionSchedule getSchedule(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSchedule();
            }
            case DEFAULT: 
            case NULL: {
                if (this._scheduleField != null) {
                    return this._scheduleField;
                }
                Object __rawValue = this._map.get("schedule");
                this._scheduleField = __rawValue == null ? null : new FreshnessAssertionSchedule(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._scheduleField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FreshnessAssertionSchedule getSchedule() {
        if (this._scheduleField != null) {
            return this._scheduleField;
        }
        Object __rawValue = this._map.get("schedule");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("schedule");
        }
        this._scheduleField = __rawValue == null ? null : new FreshnessAssertionSchedule(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._scheduleField;
    }

    public FreshnessAssertionInfo setSchedule(@Nullable FreshnessAssertionSchedule value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSchedule(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field schedule of com.linkedin.assertion.FreshnessAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "schedule", value.data());
                this._scheduleField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSchedule();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "schedule", value.data());
                this._scheduleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "schedule", value.data());
                this._scheduleField = value;
            }
        }
        return this;
    }

    public FreshnessAssertionInfo setSchedule(@Nonnull FreshnessAssertionSchedule value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field schedule of com.linkedin.assertion.FreshnessAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "schedule", value.data());
        this._scheduleField = value;
        return this;
    }

    public boolean hasFilter() {
        if (this._filterField != null) {
            return true;
        }
        return this._map.containsKey("filter");
    }

    public void removeFilter() {
        this._map.remove("filter");
    }

    @Nullable
    public DatasetFilter getFilter(GetMode mode) {
        return this.getFilter();
    }

    @Nullable
    public DatasetFilter getFilter() {
        if (this._filterField != null) {
            return this._filterField;
        }
        Object __rawValue = this._map.get("filter");
        this._filterField = __rawValue == null ? null : new DatasetFilter(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._filterField;
    }

    public FreshnessAssertionInfo setFilter(@Nullable DatasetFilter value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFilter(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFilter();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "filter", value.data());
                this._filterField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "filter", value.data());
                this._filterField = value;
            }
        }
        return this;
    }

    public FreshnessAssertionInfo setFilter(@Nonnull DatasetFilter value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field filter of com.linkedin.assertion.FreshnessAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "filter", value.data());
        this._filterField = value;
        return this;
    }

    @Override
    public FreshnessAssertionInfo clone() throws CloneNotSupportedException {
        FreshnessAssertionInfo __clone = (FreshnessAssertionInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FreshnessAssertionInfo copy() throws CloneNotSupportedException {
        FreshnessAssertionInfo __copy = (FreshnessAssertionInfo)super.copy();
        __copy._filterField = null;
        __copy._scheduleField = null;
        __copy._typeField = null;
        __copy._entityField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FreshnessAssertionInfo __objectRef;

        private ChangeListener(FreshnessAssertionInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "filter": {
                    this.__objectRef._filterField = null;
                    break;
                }
                case "schedule": {
                    this.__objectRef._scheduleField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "entity": {
                    this.__objectRef._entityField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec entity() {
            return new PathSpec(this.getPathComponents(), "entity");
        }

        public FreshnessAssertionSchedule.Fields schedule() {
            return new FreshnessAssertionSchedule.Fields(this.getPathComponents(), "schedule");
        }

        public DatasetFilter.Fields filter() {
            return new DatasetFilter.Fields(this.getPathComponents(), "filter");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private FreshnessAssertionSchedule.ProjectionMask _scheduleMask;
        private DatasetFilter.ProjectionMask _filterMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withEntity() {
            this.getDataMap().put("entity", 1);
            return this;
        }

        public ProjectionMask withSchedule(Function<FreshnessAssertionSchedule.ProjectionMask, FreshnessAssertionSchedule.ProjectionMask> nestedMask) {
            this._scheduleMask = nestedMask.apply(this._scheduleMask == null ? FreshnessAssertionSchedule.createMask() : this._scheduleMask);
            this.getDataMap().put("schedule", this._scheduleMask.getDataMap());
            return this;
        }

        public ProjectionMask withSchedule() {
            this._scheduleMask = null;
            this.getDataMap().put("schedule", 1);
            return this;
        }

        public ProjectionMask withFilter(Function<DatasetFilter.ProjectionMask, DatasetFilter.ProjectionMask> nestedMask) {
            this._filterMask = nestedMask.apply(this._filterMask == null ? DatasetFilter.createMask() : this._filterMask);
            this.getDataMap().put("filter", this._filterMask.getDataMap());
            return this;
        }

        public ProjectionMask withFilter() {
            this._filterMask = null;
            this.getDataMap().put("filter", 1);
            return this;
        }
    }
}

