/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BatchSpec
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**A batch on which certain operations, e.g. data quality evaluation, is done.*/record BatchSpec includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{/**The native identifier as specified by the system operating on the batch.*/nativeBatchId:optional string/**A query that identifies a batch of data*/query:optional string/**Any limit to the number of rows in the batch, if applied*/limit:optional int}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private String _nativeBatchIdField = null;
    private String _queryField = null;
    private Integer _limitField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_NativeBatchId;
    private static final RecordDataSchema.Field FIELD_Query;
    private static final RecordDataSchema.Field FIELD_Limit;

    public BatchSpec() {
        super(new DataMap(6, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public BatchSpec(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public BatchSpec setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.assertion.BatchSpec");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public BatchSpec setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.assertion.BatchSpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasNativeBatchId() {
        if (this._nativeBatchIdField != null) {
            return true;
        }
        return this._map.containsKey("nativeBatchId");
    }

    public void removeNativeBatchId() {
        this._map.remove("nativeBatchId");
    }

    @Nullable
    public String getNativeBatchId(GetMode mode) {
        return this.getNativeBatchId();
    }

    @Nullable
    public String getNativeBatchId() {
        if (this._nativeBatchIdField != null) {
            return this._nativeBatchIdField;
        }
        Object __rawValue = this._map.get("nativeBatchId");
        this._nativeBatchIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nativeBatchIdField;
    }

    public BatchSpec setNativeBatchId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNativeBatchId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNativeBatchId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "nativeBatchId", value);
                this._nativeBatchIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "nativeBatchId", value);
                this._nativeBatchIdField = value;
            }
        }
        return this;
    }

    public BatchSpec setNativeBatchId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field nativeBatchId of com.linkedin.assertion.BatchSpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "nativeBatchId", value);
        this._nativeBatchIdField = value;
        return this;
    }

    public boolean hasQuery() {
        if (this._queryField != null) {
            return true;
        }
        return this._map.containsKey("query");
    }

    public void removeQuery() {
        this._map.remove("query");
    }

    @Nullable
    public String getQuery(GetMode mode) {
        return this.getQuery();
    }

    @Nullable
    public String getQuery() {
        if (this._queryField != null) {
            return this._queryField;
        }
        Object __rawValue = this._map.get("query");
        this._queryField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._queryField;
    }

    public BatchSpec setQuery(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setQuery(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeQuery();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "query", value);
                this._queryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "query", value);
                this._queryField = value;
            }
        }
        return this;
    }

    public BatchSpec setQuery(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field query of com.linkedin.assertion.BatchSpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "query", value);
        this._queryField = value;
        return this;
    }

    public boolean hasLimit() {
        if (this._limitField != null) {
            return true;
        }
        return this._map.containsKey("limit");
    }

    public void removeLimit() {
        this._map.remove("limit");
    }

    @Nullable
    public Integer getLimit(GetMode mode) {
        return this.getLimit();
    }

    @Nullable
    public Integer getLimit() {
        if (this._limitField != null) {
            return this._limitField;
        }
        Object __rawValue = this._map.get("limit");
        this._limitField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._limitField;
    }

    public BatchSpec setLimit(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLimit(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLimit();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "limit", DataTemplateUtil.coerceIntInput(value));
                this._limitField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "limit", DataTemplateUtil.coerceIntInput(value));
                this._limitField = value;
            }
        }
        return this;
    }

    public BatchSpec setLimit(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field limit of com.linkedin.assertion.BatchSpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "limit", DataTemplateUtil.coerceIntInput(value));
        this._limitField = value;
        return this;
    }

    public BatchSpec setLimit(int value) {
        CheckedUtil.putWithoutChecking(this._map, "limit", DataTemplateUtil.coerceIntInput(value));
        this._limitField = value;
        return this;
    }

    @Override
    public BatchSpec clone() throws CloneNotSupportedException {
        BatchSpec __clone = (BatchSpec)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public BatchSpec copy() throws CloneNotSupportedException {
        BatchSpec __copy = (BatchSpec)super.copy();
        __copy._customPropertiesField = null;
        __copy._queryField = null;
        __copy._limitField = null;
        __copy._nativeBatchIdField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_NativeBatchId = SCHEMA.getField("nativeBatchId");
        FIELD_Query = SCHEMA.getField("query");
        FIELD_Limit = SCHEMA.getField("limit");
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final BatchSpec __objectRef;

        private ChangeListener(BatchSpec reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "query": {
                    this.__objectRef._queryField = null;
                    break;
                }
                case "limit": {
                    this.__objectRef._limitField = null;
                    break;
                }
                case "nativeBatchId": {
                    this.__objectRef._nativeBatchIdField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec nativeBatchId() {
            return new PathSpec(this.getPathComponents(), "nativeBatchId");
        }

        public PathSpec query() {
            return new PathSpec(this.getPathComponents(), "query");
        }

        public PathSpec limit() {
            return new PathSpec(this.getPathComponents(), "limit");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withNativeBatchId() {
            this.getDataMap().put("nativeBatchId", 1);
            return this;
        }

        public ProjectionMask withQuery() {
            this.getDataMap().put("query", 1);
            return this;
        }

        public ProjectionMask withLimit() {
            this.getDataMap().put("limit", 1);
            return this;
        }
    }
}

