/*
 * Decompiled with CFR 0.152.
 */
package datahub.shaded.jackson.databind.ser.std;

import datahub.shaded.jackson.core.JsonGenerator;
import datahub.shaded.jackson.databind.JavaType;
import datahub.shaded.jackson.databind.JsonMappingException;
import datahub.shaded.jackson.databind.JsonNode;
import datahub.shaded.jackson.databind.SerializerProvider;
import datahub.shaded.jackson.databind.annotation.JacksonStdImpl;
import datahub.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import datahub.shaded.jackson.databind.jsontype.TypeSerializer;
import datahub.shaded.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class NullSerializer
extends StdSerializer<Object> {
    public static final NullSerializer instance = new NullSerializer();

    private NullSerializer() {
        super(Object.class);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeNull();
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        gen.writeNull();
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("null");
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectNullFormat(typeHint);
    }
}

