/*
 * Decompiled with CFR 0.152.
 */
package datahub.shaded.jackson.databind.deser.std;

import datahub.shaded.jackson.core.JsonParser;
import datahub.shaded.jackson.databind.DeserializationConfig;
import datahub.shaded.jackson.databind.DeserializationContext;
import datahub.shaded.jackson.databind.JavaType;
import datahub.shaded.jackson.databind.deser.std.StdDeserializer;
import datahub.shaded.jackson.databind.jsontype.TypeDeserializer;
import datahub.shaded.jackson.databind.type.LogicalType;
import datahub.shaded.jackson.databind.util.AccessPattern;
import java.io.IOException;

public abstract class StdScalarDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 1L;

    protected StdScalarDeserializer(Class<?> vc) {
        super(vc);
    }

    protected StdScalarDeserializer(JavaType valueType) {
        super(valueType);
    }

    protected StdScalarDeserializer(StdScalarDeserializer<?> src) {
        super(src);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.OtherScalar;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return Boolean.FALSE;
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.ALWAYS_NULL;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromScalar(p, ctxt);
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt, T intoValue) throws IOException {
        ctxt.handleBadMerge(this);
        return this.deserialize(p, ctxt);
    }
}

