/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.structured;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.structured.PropertyValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class PropertyValueArray
extends WrappingArrayTemplate<PropertyValue> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.structured,record PropertyValue{value:/**Represents a stored primitive property value\n*/typeref PrimitivePropertyValue=union[string,double]/**Optional description of the property value*/description:optional string}}]", SchemaFormatType.PDL);

    public PropertyValueArray() {
        this(new DataList());
    }

    public PropertyValueArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public PropertyValueArray(Collection<PropertyValue> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public PropertyValueArray(DataList data) {
        super(data, SCHEMA, PropertyValue.class);
    }

    public PropertyValueArray(PropertyValue first, PropertyValue ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public PropertyValueArray clone() throws CloneNotSupportedException {
        PropertyValueArray __clone = (PropertyValueArray)super.clone();
        return __clone;
    }

    @Override
    public PropertyValueArray copy() throws CloneNotSupportedException {
        PropertyValueArray __copy = (PropertyValueArray)super.copy();
        return __copy;
    }

    @Override
    protected PropertyValue coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new PropertyValue(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private PropertyValue.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<PropertyValue.ProjectionMask, PropertyValue.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? PropertyValue.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PropertyValue.Fields items() {
            return new PropertyValue.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

