/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.schema;

import com.linkedin.common.urn.DataPlatformUrn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SchemaMetadataKey
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.schema/**Key to retrieve schema metadata.*/record SchemaMetadataKey{/**Schema name e.g. PageViewEvent, identity.Profile, ams.account_management_tracking*/@validate.strlen={\"max\":500,\"min\":1}schemaName:string/**Standardized platform urn where schema is defined. The data platform Urn (urn:li:platform:{platform_name})*/platform:{namespace com.linkedin.common/**Standardized data platforms available*/@java.class=\"com.linkedin.common.urn.DataPlatformUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized data platforms available\",\"entityType\":\"dataPlatform\",\"fields\":[{\"doc\":\"data platform name i.e. hdfs, oracle, espresso\",\"maxLength\":25,\"name\":\"platformName\",\"type\":\"string\"}],\"maxLength\":45,\"name\":\"DataPlatform\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:wherehows\"}typeref DataPlatformUrn=string}/**Every change to SchemaMetadata in the resource results in a new version. Version is server assigned. This version is differ from platform native schema version.*/version:long}", SchemaFormatType.PDL);
    private String _schemaNameField = null;
    private DataPlatformUrn _platformField = null;
    private Long _versionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_SchemaName = SCHEMA.getField("schemaName");
    private static final RecordDataSchema.Field FIELD_Platform = SCHEMA.getField("platform");
    private static final RecordDataSchema.Field FIELD_Version = SCHEMA.getField("version");

    public SchemaMetadataKey() {
        super(new DataMap(4, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public SchemaMetadataKey(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSchemaName() {
        if (this._schemaNameField != null) {
            return true;
        }
        return this._map.containsKey("schemaName");
    }

    public void removeSchemaName() {
        this._map.remove("schemaName");
    }

    @Nullable
    public String getSchemaName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSchemaName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._schemaNameField != null) {
                    return this._schemaNameField;
                }
                Object __rawValue = this._map.get("schemaName");
                this._schemaNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._schemaNameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getSchemaName() {
        if (this._schemaNameField != null) {
            return this._schemaNameField;
        }
        Object __rawValue = this._map.get("schemaName");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("schemaName");
        }
        this._schemaNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._schemaNameField;
    }

    public SchemaMetadataKey setSchemaName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSchemaName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field schemaName of com.linkedin.schema.SchemaMetadataKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "schemaName", value);
                this._schemaNameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSchemaName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "schemaName", value);
                this._schemaNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "schemaName", value);
                this._schemaNameField = value;
            }
        }
        return this;
    }

    public SchemaMetadataKey setSchemaName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field schemaName of com.linkedin.schema.SchemaMetadataKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "schemaName", value);
        this._schemaNameField = value;
        return this;
    }

    public boolean hasPlatform() {
        if (this._platformField != null) {
            return true;
        }
        return this._map.containsKey("platform");
    }

    public void removePlatform() {
        this._map.remove("platform");
    }

    @Nullable
    public DataPlatformUrn getPlatform(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPlatform();
            }
            case DEFAULT: 
            case NULL: {
                if (this._platformField != null) {
                    return this._platformField;
                }
                Object __rawValue = this._map.get("platform");
                this._platformField = DataTemplateUtil.coerceCustomOutput(__rawValue, DataPlatformUrn.class);
                return this._platformField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataPlatformUrn getPlatform() {
        if (this._platformField != null) {
            return this._platformField;
        }
        Object __rawValue = this._map.get("platform");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("platform");
        }
        this._platformField = DataTemplateUtil.coerceCustomOutput(__rawValue, DataPlatformUrn.class);
        return this._platformField;
    }

    public SchemaMetadataKey setPlatform(@Nullable DataPlatformUrn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPlatform(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field platform of com.linkedin.schema.SchemaMetadataKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, DataPlatformUrn.class));
                this._platformField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePlatform();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, DataPlatformUrn.class));
                this._platformField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, DataPlatformUrn.class));
                this._platformField = value;
            }
        }
        return this;
    }

    public SchemaMetadataKey setPlatform(@Nonnull DataPlatformUrn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field platform of com.linkedin.schema.SchemaMetadataKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, DataPlatformUrn.class));
        this._platformField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public Long getVersion(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getVersion();
            }
            case DEFAULT: 
            case NULL: {
                if (this._versionField != null) {
                    return this._versionField;
                }
                Object __rawValue = this._map.get("version");
                this._versionField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._versionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("version");
        }
        this._versionField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._versionField;
    }

    public SchemaMetadataKey setVersion(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field version of com.linkedin.schema.SchemaMetadataKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
                this._versionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
                this._versionField = value;
            }
        }
        return this;
    }

    public SchemaMetadataKey setVersion(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.schema.SchemaMetadataKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
        this._versionField = value;
        return this;
    }

    public SchemaMetadataKey setVersion(long value) {
        CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
        this._versionField = value;
        return this;
    }

    @Override
    public SchemaMetadataKey clone() throws CloneNotSupportedException {
        SchemaMetadataKey __clone = (SchemaMetadataKey)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SchemaMetadataKey copy() throws CloneNotSupportedException {
        SchemaMetadataKey __copy = (SchemaMetadataKey)super.copy();
        __copy._schemaNameField = null;
        __copy._versionField = null;
        __copy._platformField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(DataPlatformUrn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SchemaMetadataKey __objectRef;

        private ChangeListener(SchemaMetadataKey reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "schemaName": {
                    this.__objectRef._schemaNameField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                    break;
                }
                case "platform": {
                    this.__objectRef._platformField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec schemaName() {
            return new PathSpec(this.getPathComponents(), "schemaName");
        }

        public PathSpec platform() {
            return new PathSpec(this.getPathComponents(), "platform");
        }

        public PathSpec version() {
            return new PathSpec(this.getPathComponents(), "version");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withSchemaName() {
            this.getDataMap().put("schemaName", 1);
            return this;
        }

        public ProjectionMask withPlatform() {
            this.getDataMap().put("platform", 1);
            return this;
        }

        public ProjectionMask withVersion() {
            this.getDataMap().put("version", 1);
            return this;
        }
    }
}

