/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.ml.metadata.CaveatDetails;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CaveatsAndRecommendations
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset? Are there additional recommendations for model use?*/@Aspect.name=\"mlModelCaveatsAndRecommendations\"record CaveatsAndRecommendations{/**This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset?*/caveats:optional/**This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset? Are there additional recommendations for model use?*/record CaveatDetails{/**Did the results suggest any further testing?*/needsFurtherTesting:optional boolean/**Caveat Description\nFor ex: Given gender classes are binary (male/not male), which we include as male/female. Further work needed to evaluate across a spectrum of genders.*/caveatDescription:optional string/**Relevant groups that were not represented in the evaluation dataset?*/groupsNotRepresented:optional array[string]}/**Recommendations on where this MLModel should be used.*/recommendations:optional string/**Ideal characteristics of an evaluation dataset for this MLModel*/idealDatasetCharacteristics:optional array[string]}", SchemaFormatType.PDL);
    private CaveatDetails _caveatsField = null;
    private String _recommendationsField = null;
    private StringArray _idealDatasetCharacteristicsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Caveats = SCHEMA.getField("caveats");
    private static final RecordDataSchema.Field FIELD_Recommendations = SCHEMA.getField("recommendations");
    private static final RecordDataSchema.Field FIELD_IdealDatasetCharacteristics = SCHEMA.getField("idealDatasetCharacteristics");

    public CaveatsAndRecommendations() {
        super(new DataMap(4, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public CaveatsAndRecommendations(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCaveats() {
        if (this._caveatsField != null) {
            return true;
        }
        return this._map.containsKey("caveats");
    }

    public void removeCaveats() {
        this._map.remove("caveats");
    }

    @Nullable
    public CaveatDetails getCaveats(GetMode mode) {
        return this.getCaveats();
    }

    @Nullable
    public CaveatDetails getCaveats() {
        if (this._caveatsField != null) {
            return this._caveatsField;
        }
        Object __rawValue = this._map.get("caveats");
        this._caveatsField = __rawValue == null ? null : new CaveatDetails(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._caveatsField;
    }

    public CaveatsAndRecommendations setCaveats(@Nullable CaveatDetails value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCaveats(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCaveats();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "caveats", value.data());
                this._caveatsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "caveats", value.data());
                this._caveatsField = value;
            }
        }
        return this;
    }

    public CaveatsAndRecommendations setCaveats(@Nonnull CaveatDetails value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field caveats of com.linkedin.ml.metadata.CaveatsAndRecommendations to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "caveats", value.data());
        this._caveatsField = value;
        return this;
    }

    public boolean hasRecommendations() {
        if (this._recommendationsField != null) {
            return true;
        }
        return this._map.containsKey("recommendations");
    }

    public void removeRecommendations() {
        this._map.remove("recommendations");
    }

    @Nullable
    public String getRecommendations(GetMode mode) {
        return this.getRecommendations();
    }

    @Nullable
    public String getRecommendations() {
        if (this._recommendationsField != null) {
            return this._recommendationsField;
        }
        Object __rawValue = this._map.get("recommendations");
        this._recommendationsField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._recommendationsField;
    }

    public CaveatsAndRecommendations setRecommendations(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRecommendations(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRecommendations();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "recommendations", value);
                this._recommendationsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "recommendations", value);
                this._recommendationsField = value;
            }
        }
        return this;
    }

    public CaveatsAndRecommendations setRecommendations(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field recommendations of com.linkedin.ml.metadata.CaveatsAndRecommendations to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "recommendations", value);
        this._recommendationsField = value;
        return this;
    }

    public boolean hasIdealDatasetCharacteristics() {
        if (this._idealDatasetCharacteristicsField != null) {
            return true;
        }
        return this._map.containsKey("idealDatasetCharacteristics");
    }

    public void removeIdealDatasetCharacteristics() {
        this._map.remove("idealDatasetCharacteristics");
    }

    @Nullable
    public StringArray getIdealDatasetCharacteristics(GetMode mode) {
        return this.getIdealDatasetCharacteristics();
    }

    @Nullable
    public StringArray getIdealDatasetCharacteristics() {
        if (this._idealDatasetCharacteristicsField != null) {
            return this._idealDatasetCharacteristicsField;
        }
        Object __rawValue = this._map.get("idealDatasetCharacteristics");
        this._idealDatasetCharacteristicsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._idealDatasetCharacteristicsField;
    }

    public CaveatsAndRecommendations setIdealDatasetCharacteristics(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIdealDatasetCharacteristics(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIdealDatasetCharacteristics();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "idealDatasetCharacteristics", value.data());
                this._idealDatasetCharacteristicsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "idealDatasetCharacteristics", value.data());
                this._idealDatasetCharacteristicsField = value;
            }
        }
        return this;
    }

    public CaveatsAndRecommendations setIdealDatasetCharacteristics(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field idealDatasetCharacteristics of com.linkedin.ml.metadata.CaveatsAndRecommendations to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "idealDatasetCharacteristics", value.data());
        this._idealDatasetCharacteristicsField = value;
        return this;
    }

    @Override
    public CaveatsAndRecommendations clone() throws CloneNotSupportedException {
        CaveatsAndRecommendations __clone = (CaveatsAndRecommendations)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CaveatsAndRecommendations copy() throws CloneNotSupportedException {
        CaveatsAndRecommendations __copy = (CaveatsAndRecommendations)super.copy();
        __copy._recommendationsField = null;
        __copy._idealDatasetCharacteristicsField = null;
        __copy._caveatsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CaveatsAndRecommendations __objectRef;

        private ChangeListener(CaveatsAndRecommendations reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "recommendations": {
                    this.__objectRef._recommendationsField = null;
                    break;
                }
                case "idealDatasetCharacteristics": {
                    this.__objectRef._idealDatasetCharacteristicsField = null;
                    break;
                }
                case "caveats": {
                    this.__objectRef._caveatsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public CaveatDetails.Fields caveats() {
            return new CaveatDetails.Fields(this.getPathComponents(), "caveats");
        }

        public PathSpec recommendations() {
            return new PathSpec(this.getPathComponents(), "recommendations");
        }

        public PathSpec idealDatasetCharacteristics() {
            return new PathSpec(this.getPathComponents(), "idealDatasetCharacteristics");
        }

        public PathSpec idealDatasetCharacteristics(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "idealDatasetCharacteristics");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private CaveatDetails.ProjectionMask _caveatsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withCaveats(Function<CaveatDetails.ProjectionMask, CaveatDetails.ProjectionMask> nestedMask) {
            this._caveatsMask = nestedMask.apply(this._caveatsMask == null ? CaveatDetails.createMask() : this._caveatsMask);
            this.getDataMap().put("caveats", this._caveatsMask.getDataMap());
            return this;
        }

        public ProjectionMask withCaveats() {
            this._caveatsMask = null;
            this.getDataMap().put("caveats", 1);
            return this;
        }

        public ProjectionMask withRecommendations() {
            this.getDataMap().put("recommendations", 1);
            return this;
        }

        public ProjectionMask withIdealDatasetCharacteristics() {
            this.getDataMap().put("idealDatasetCharacteristics", 1);
            return this;
        }

        public ProjectionMask withIdealDatasetCharacteristics(Integer start, Integer count) {
            this.getDataMap().put("idealDatasetCharacteristics", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("idealDatasetCharacteristics").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("idealDatasetCharacteristics").put("$count", count);
            }
            return this;
        }
    }
}

