/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CaveatDetails
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**This section should list additional concerns that were not covered in the previous sections. For example, did the results suggest any further testing? Were there any relevant groups that were not represented in the evaluation dataset? Are there additional recommendations for model use?*/record CaveatDetails{/**Did the results suggest any further testing?*/needsFurtherTesting:optional boolean/**Caveat Description\nFor ex: Given gender classes are binary (male/not male), which we include as male/female. Further work needed to evaluate across a spectrum of genders.*/caveatDescription:optional string/**Relevant groups that were not represented in the evaluation dataset?*/groupsNotRepresented:optional array[string]}", SchemaFormatType.PDL);
    private Boolean _needsFurtherTestingField = null;
    private String _caveatDescriptionField = null;
    private StringArray _groupsNotRepresentedField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_NeedsFurtherTesting = SCHEMA.getField("needsFurtherTesting");
    private static final RecordDataSchema.Field FIELD_CaveatDescription = SCHEMA.getField("caveatDescription");
    private static final RecordDataSchema.Field FIELD_GroupsNotRepresented = SCHEMA.getField("groupsNotRepresented");

    public CaveatDetails() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public CaveatDetails(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasNeedsFurtherTesting() {
        if (this._needsFurtherTestingField != null) {
            return true;
        }
        return this._map.containsKey("needsFurtherTesting");
    }

    public void removeNeedsFurtherTesting() {
        this._map.remove("needsFurtherTesting");
    }

    @Nullable
    public Boolean isNeedsFurtherTesting(GetMode mode) {
        return this.isNeedsFurtherTesting();
    }

    @Nullable
    public Boolean isNeedsFurtherTesting() {
        if (this._needsFurtherTestingField != null) {
            return this._needsFurtherTestingField;
        }
        Object __rawValue = this._map.get("needsFurtherTesting");
        this._needsFurtherTestingField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._needsFurtherTestingField;
    }

    public CaveatDetails setNeedsFurtherTesting(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNeedsFurtherTesting(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNeedsFurtherTesting();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "needsFurtherTesting", value);
                this._needsFurtherTestingField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "needsFurtherTesting", value);
                this._needsFurtherTestingField = value;
            }
        }
        return this;
    }

    public CaveatDetails setNeedsFurtherTesting(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field needsFurtherTesting of com.linkedin.ml.metadata.CaveatDetails to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "needsFurtherTesting", value);
        this._needsFurtherTestingField = value;
        return this;
    }

    public CaveatDetails setNeedsFurtherTesting(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "needsFurtherTesting", value);
        this._needsFurtherTestingField = value;
        return this;
    }

    public boolean hasCaveatDescription() {
        if (this._caveatDescriptionField != null) {
            return true;
        }
        return this._map.containsKey("caveatDescription");
    }

    public void removeCaveatDescription() {
        this._map.remove("caveatDescription");
    }

    @Nullable
    public String getCaveatDescription(GetMode mode) {
        return this.getCaveatDescription();
    }

    @Nullable
    public String getCaveatDescription() {
        if (this._caveatDescriptionField != null) {
            return this._caveatDescriptionField;
        }
        Object __rawValue = this._map.get("caveatDescription");
        this._caveatDescriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._caveatDescriptionField;
    }

    public CaveatDetails setCaveatDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCaveatDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCaveatDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "caveatDescription", value);
                this._caveatDescriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "caveatDescription", value);
                this._caveatDescriptionField = value;
            }
        }
        return this;
    }

    public CaveatDetails setCaveatDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field caveatDescription of com.linkedin.ml.metadata.CaveatDetails to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "caveatDescription", value);
        this._caveatDescriptionField = value;
        return this;
    }

    public boolean hasGroupsNotRepresented() {
        if (this._groupsNotRepresentedField != null) {
            return true;
        }
        return this._map.containsKey("groupsNotRepresented");
    }

    public void removeGroupsNotRepresented() {
        this._map.remove("groupsNotRepresented");
    }

    @Nullable
    public StringArray getGroupsNotRepresented(GetMode mode) {
        return this.getGroupsNotRepresented();
    }

    @Nullable
    public StringArray getGroupsNotRepresented() {
        if (this._groupsNotRepresentedField != null) {
            return this._groupsNotRepresentedField;
        }
        Object __rawValue = this._map.get("groupsNotRepresented");
        this._groupsNotRepresentedField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._groupsNotRepresentedField;
    }

    public CaveatDetails setGroupsNotRepresented(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGroupsNotRepresented(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGroupsNotRepresented();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "groupsNotRepresented", value.data());
                this._groupsNotRepresentedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "groupsNotRepresented", value.data());
                this._groupsNotRepresentedField = value;
            }
        }
        return this;
    }

    public CaveatDetails setGroupsNotRepresented(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field groupsNotRepresented of com.linkedin.ml.metadata.CaveatDetails to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "groupsNotRepresented", value.data());
        this._groupsNotRepresentedField = value;
        return this;
    }

    @Override
    public CaveatDetails clone() throws CloneNotSupportedException {
        CaveatDetails __clone = (CaveatDetails)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CaveatDetails copy() throws CloneNotSupportedException {
        CaveatDetails __copy = (CaveatDetails)super.copy();
        __copy._caveatDescriptionField = null;
        __copy._groupsNotRepresentedField = null;
        __copy._needsFurtherTestingField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CaveatDetails __objectRef;

        private ChangeListener(CaveatDetails reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "caveatDescription": {
                    this.__objectRef._caveatDescriptionField = null;
                    break;
                }
                case "groupsNotRepresented": {
                    this.__objectRef._groupsNotRepresentedField = null;
                    break;
                }
                case "needsFurtherTesting": {
                    this.__objectRef._needsFurtherTestingField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec needsFurtherTesting() {
            return new PathSpec(this.getPathComponents(), "needsFurtherTesting");
        }

        public PathSpec caveatDescription() {
            return new PathSpec(this.getPathComponents(), "caveatDescription");
        }

        public PathSpec groupsNotRepresented() {
            return new PathSpec(this.getPathComponents(), "groupsNotRepresented");
        }

        public PathSpec groupsNotRepresented(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "groupsNotRepresented");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withNeedsFurtherTesting() {
            this.getDataMap().put("needsFurtherTesting", 1);
            return this;
        }

        public ProjectionMask withCaveatDescription() {
            this.getDataMap().put("caveatDescription", 1);
            return this;
        }

        public ProjectionMask withGroupsNotRepresented() {
            this.getDataMap().put("groupsNotRepresented", 1);
            return this;
        }

        public ProjectionMask withGroupsNotRepresented(Integer start, Integer count) {
            this.getDataMap().put("groupsNotRepresented", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("groupsNotRepresented").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("groupsNotRepresented").put("$count", count);
            }
            return this;
        }
    }
}

