/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.search;

import com.linkedin.common.UrnArray;
import com.linkedin.common.UrnArrayArray;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DoubleMap;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.IntegerArray;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.data.template.StringMap;
import com.linkedin.metadata.search.MatchedFieldArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LineageSearchEntity
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.search/**The model for each entity returned by the lineage search query*/record LineageSearchEntity includes/**The model for each entity returned by the search query*/record SearchEntity{/**Urn of the entity being returned*/entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Matched field name and values*/matchedFields:array[record MatchedField{/**Matched field name*/name:string/**Matched field value*/value:string}]=[]features:optional map[string,double]score:optional double/**A list of the the restricted aspects on the entity.\nIf the key aspect is present, assume ALL aspects should be restricted including the entity's Urn.*/restrictedAspects:optional array[string]/**Extra fields from the search document based on what is requested in the search request*/extraFields:optional map[string,string]}{/**Optional list of entities between the source and destination node.\nThere can be multiple paths from the source to the destination.*/paths:array[array[com.linkedin.common.Urn]]=[]/**Optional list of entities between the source and destination node*/@deprecated,path:array[com.linkedin.common.Urn]=[]/**Degree of relationship (number of hops to get to entity)*/@deprecated,degree:int=1/**The degrees of separation (number of hops) between the source and this entity */degrees:array[int]=[]/**Marks an entity as having been explored for as a part of the graph walk*/explored:optional boolean/**Indicates this destination node has additional unexplored child relationships*/truncatedChildren:optional boolean/**Whether this relationship was ignored as a hop while performing the graph walk*/ignoredAsHop:optional boolean}", SchemaFormatType.PDL);
    private Urn _entityField = null;
    private MatchedFieldArray _matchedFieldsField = null;
    private DoubleMap _featuresField = null;
    private Double _scoreField = null;
    private StringArray _restrictedAspectsField = null;
    private StringMap _extraFieldsField = null;
    private UrnArrayArray _pathsField = null;
    private UrnArray _pathField = null;
    private Integer _degreeField = null;
    private IntegerArray _degreesField = null;
    private Boolean _exploredField = null;
    private Boolean _truncatedChildrenField = null;
    private Boolean _ignoredAsHopField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Entity = SCHEMA.getField("entity");
    private static final RecordDataSchema.Field FIELD_MatchedFields = SCHEMA.getField("matchedFields");
    private static final MatchedFieldArray DEFAULT_MatchedFields;
    private static final RecordDataSchema.Field FIELD_Features;
    private static final RecordDataSchema.Field FIELD_Score;
    private static final RecordDataSchema.Field FIELD_RestrictedAspects;
    private static final RecordDataSchema.Field FIELD_ExtraFields;
    private static final RecordDataSchema.Field FIELD_Paths;
    private static final UrnArrayArray DEFAULT_Paths;
    private static final RecordDataSchema.Field FIELD_Path;
    private static final UrnArray DEFAULT_Path;
    private static final RecordDataSchema.Field FIELD_Degree;
    private static final Integer DEFAULT_Degree;
    private static final RecordDataSchema.Field FIELD_Degrees;
    private static final IntegerArray DEFAULT_Degrees;
    private static final RecordDataSchema.Field FIELD_Explored;
    private static final RecordDataSchema.Field FIELD_TruncatedChildren;
    private static final RecordDataSchema.Field FIELD_IgnoredAsHop;

    public LineageSearchEntity() {
        super(new DataMap(), SCHEMA, 10);
        this.addChangeListener(this.__changeListener);
    }

    public LineageSearchEntity(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEntity() {
        if (this._entityField != null) {
            return true;
        }
        return this._map.containsKey("entity");
    }

    public void removeEntity() {
        this._map.remove("entity");
    }

    @Nullable
    public Urn getEntity(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntity();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityField != null) {
                    return this._entityField;
                }
                Object __rawValue = this._map.get("entity");
                this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._entityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getEntity() {
        if (this._entityField != null) {
            return this._entityField;
        }
        Object __rawValue = this._map.get("entity");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entity");
        }
        this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityField;
    }

    public LineageSearchEntity setEntity(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entity of com.linkedin.metadata.search.LineageSearchEntity");
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
            }
        }
        return this;
    }

    public LineageSearchEntity setEntity(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entity of com.linkedin.metadata.search.LineageSearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityField = value;
        return this;
    }

    public boolean hasMatchedFields() {
        if (this._matchedFieldsField != null) {
            return true;
        }
        return this._map.containsKey("matchedFields");
    }

    public void removeMatchedFields() {
        this._map.remove("matchedFields");
    }

    @Nullable
    public MatchedFieldArray getMatchedFields(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getMatchedFields();
            }
            case NULL: {
                if (this._matchedFieldsField != null) {
                    return this._matchedFieldsField;
                }
                Object __rawValue = this._map.get("matchedFields");
                this._matchedFieldsField = __rawValue == null ? null : new MatchedFieldArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._matchedFieldsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public MatchedFieldArray getMatchedFields() {
        if (this._matchedFieldsField != null) {
            return this._matchedFieldsField;
        }
        Object __rawValue = this._map.get("matchedFields");
        if (__rawValue == null) {
            return DEFAULT_MatchedFields;
        }
        this._matchedFieldsField = __rawValue == null ? null : new MatchedFieldArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._matchedFieldsField;
    }

    public LineageSearchEntity setMatchedFields(@Nullable MatchedFieldArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMatchedFields(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field matchedFields of com.linkedin.metadata.search.LineageSearchEntity");
                }
                CheckedUtil.putWithoutChecking(this._map, "matchedFields", value.data());
                this._matchedFieldsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMatchedFields();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "matchedFields", value.data());
                this._matchedFieldsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "matchedFields", value.data());
                this._matchedFieldsField = value;
            }
        }
        return this;
    }

    public LineageSearchEntity setMatchedFields(@Nonnull MatchedFieldArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field matchedFields of com.linkedin.metadata.search.LineageSearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "matchedFields", value.data());
        this._matchedFieldsField = value;
        return this;
    }

    public boolean hasFeatures() {
        if (this._featuresField != null) {
            return true;
        }
        return this._map.containsKey("features");
    }

    public void removeFeatures() {
        this._map.remove("features");
    }

    @Nullable
    public DoubleMap getFeatures(GetMode mode) {
        return this.getFeatures();
    }

    @Nullable
    public DoubleMap getFeatures() {
        if (this._featuresField != null) {
            return this._featuresField;
        }
        Object __rawValue = this._map.get("features");
        this._featuresField = __rawValue == null ? null : new DoubleMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._featuresField;
    }

    public LineageSearchEntity setFeatures(@Nullable DoubleMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFeatures(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFeatures();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "features", value.data());
                this._featuresField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "features", value.data());
                this._featuresField = value;
            }
        }
        return this;
    }

    public LineageSearchEntity setFeatures(@Nonnull DoubleMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field features of com.linkedin.metadata.search.LineageSearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "features", value.data());
        this._featuresField = value;
        return this;
    }

    public boolean hasScore() {
        if (this._scoreField != null) {
            return true;
        }
        return this._map.containsKey("score");
    }

    public void removeScore() {
        this._map.remove("score");
    }

    @Nullable
    public Double getScore(GetMode mode) {
        return this.getScore();
    }

    @Nullable
    public Double getScore() {
        if (this._scoreField != null) {
            return this._scoreField;
        }
        Object __rawValue = this._map.get("score");
        this._scoreField = DataTemplateUtil.coerceDoubleOutput(__rawValue);
        return this._scoreField;
    }

    public LineageSearchEntity setScore(@Nullable Double value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setScore(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeScore();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "score", DataTemplateUtil.coerceDoubleInput(value));
                this._scoreField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "score", DataTemplateUtil.coerceDoubleInput(value));
                this._scoreField = value;
            }
        }
        return this;
    }

    public LineageSearchEntity setScore(@Nonnull Double value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field score of com.linkedin.metadata.search.LineageSearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "score", DataTemplateUtil.coerceDoubleInput(value));
        this._scoreField = value;
        return this;
    }

    public LineageSearchEntity setScore(double value) {
        CheckedUtil.putWithoutChecking(this._map, "score", DataTemplateUtil.coerceDoubleInput(value));
        this._scoreField = value;
        return this;
    }

    public boolean hasRestrictedAspects() {
        if (this._restrictedAspectsField != null) {
            return true;
        }
        return this._map.containsKey("restrictedAspects");
    }

    public void removeRestrictedAspects() {
        this._map.remove("restrictedAspects");
    }

    @Nullable
    public StringArray getRestrictedAspects(GetMode mode) {
        return this.getRestrictedAspects();
    }

    @Nullable
    public StringArray getRestrictedAspects() {
        if (this._restrictedAspectsField != null) {
            return this._restrictedAspectsField;
        }
        Object __rawValue = this._map.get("restrictedAspects");
        this._restrictedAspectsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._restrictedAspectsField;
    }

    public LineageSearchEntity setRestrictedAspects(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRestrictedAspects(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRestrictedAspects();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "restrictedAspects", value.data());
                this._restrictedAspectsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "restrictedAspects", value.data());
                this._restrictedAspectsField = value;
            }
        }
        return this;
    }

    public LineageSearchEntity setRestrictedAspects(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field restrictedAspects of com.linkedin.metadata.search.LineageSearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "restrictedAspects", value.data());
        this._restrictedAspectsField = value;
        return this;
    }

    public boolean hasExtraFields() {
        if (this._extraFieldsField != null) {
            return true;
        }
        return this._map.containsKey("extraFields");
    }

    public void removeExtraFields() {
        this._map.remove("extraFields");
    }

    @Nullable
    public StringMap getExtraFields(GetMode mode) {
        return this.getExtraFields();
    }

    @Nullable
    public StringMap getExtraFields() {
        if (this._extraFieldsField != null) {
            return this._extraFieldsField;
        }
        Object __rawValue = this._map.get("extraFields");
        this._extraFieldsField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._extraFieldsField;
    }

    public LineageSearchEntity setExtraFields(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExtraFields(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExtraFields();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "extraFields", value.data());
                this._extraFieldsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "extraFields", value.data());
                this._extraFieldsField = value;
            }
        }
        return this;
    }

    public LineageSearchEntity setExtraFields(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field extraFields of com.linkedin.metadata.search.LineageSearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "extraFields", value.data());
        this._extraFieldsField = value;
        return this;
    }

    public boolean hasPaths() {
        if (this._pathsField != null) {
            return true;
        }
        return this._map.containsKey("paths");
    }

    public void removePaths() {
        this._map.remove("paths");
    }

    @Nullable
    public UrnArrayArray getPaths(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPaths();
            }
            case NULL: {
                if (this._pathsField != null) {
                    return this._pathsField;
                }
                Object __rawValue = this._map.get("paths");
                this._pathsField = __rawValue == null ? null : new UrnArrayArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._pathsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArrayArray getPaths() {
        if (this._pathsField != null) {
            return this._pathsField;
        }
        Object __rawValue = this._map.get("paths");
        if (__rawValue == null) {
            return DEFAULT_Paths;
        }
        this._pathsField = __rawValue == null ? null : new UrnArrayArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._pathsField;
    }

    public LineageSearchEntity setPaths(@Nullable UrnArrayArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPaths(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field paths of com.linkedin.metadata.search.LineageSearchEntity");
                }
                CheckedUtil.putWithoutChecking(this._map, "paths", value.data());
                this._pathsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePaths();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "paths", value.data());
                this._pathsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "paths", value.data());
                this._pathsField = value;
            }
        }
        return this;
    }

    public LineageSearchEntity setPaths(@Nonnull UrnArrayArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field paths of com.linkedin.metadata.search.LineageSearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "paths", value.data());
        this._pathsField = value;
        return this;
    }

    @Deprecated
    public boolean hasPath() {
        if (this._pathField != null) {
            return true;
        }
        return this._map.containsKey("path");
    }

    @Deprecated
    public void removePath() {
        this._map.remove("path");
    }

    @Deprecated
    @Nullable
    public UrnArray getPath(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPath();
            }
            case NULL: {
                if (this._pathField != null) {
                    return this._pathField;
                }
                Object __rawValue = this._map.get("path");
                this._pathField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._pathField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public UrnArray getPath() {
        if (this._pathField != null) {
            return this._pathField;
        }
        Object __rawValue = this._map.get("path");
        if (__rawValue == null) {
            return DEFAULT_Path;
        }
        this._pathField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._pathField;
    }

    @Deprecated
    public LineageSearchEntity setPath(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPath(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field path of com.linkedin.metadata.search.LineageSearchEntity");
                }
                CheckedUtil.putWithoutChecking(this._map, "path", value.data());
                this._pathField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePath();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "path", value.data());
                this._pathField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "path", value.data());
                this._pathField = value;
            }
        }
        return this;
    }

    @Deprecated
    public LineageSearchEntity setPath(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field path of com.linkedin.metadata.search.LineageSearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "path", value.data());
        this._pathField = value;
        return this;
    }

    @Deprecated
    public boolean hasDegree() {
        if (this._degreeField != null) {
            return true;
        }
        return this._map.containsKey("degree");
    }

    @Deprecated
    public void removeDegree() {
        this._map.remove("degree");
    }

    @Deprecated
    @Nullable
    public Integer getDegree(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getDegree();
            }
            case NULL: {
                if (this._degreeField != null) {
                    return this._degreeField;
                }
                Object __rawValue = this._map.get("degree");
                this._degreeField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._degreeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public Integer getDegree() {
        if (this._degreeField != null) {
            return this._degreeField;
        }
        Object __rawValue = this._map.get("degree");
        if (__rawValue == null) {
            return DEFAULT_Degree;
        }
        this._degreeField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._degreeField;
    }

    @Deprecated
    public LineageSearchEntity setDegree(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDegree(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field degree of com.linkedin.metadata.search.LineageSearchEntity");
                }
                CheckedUtil.putWithoutChecking(this._map, "degree", DataTemplateUtil.coerceIntInput(value));
                this._degreeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDegree();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "degree", DataTemplateUtil.coerceIntInput(value));
                this._degreeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "degree", DataTemplateUtil.coerceIntInput(value));
                this._degreeField = value;
            }
        }
        return this;
    }

    @Deprecated
    public LineageSearchEntity setDegree(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field degree of com.linkedin.metadata.search.LineageSearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "degree", DataTemplateUtil.coerceIntInput(value));
        this._degreeField = value;
        return this;
    }

    @Deprecated
    public LineageSearchEntity setDegree(int value) {
        CheckedUtil.putWithoutChecking(this._map, "degree", DataTemplateUtil.coerceIntInput(value));
        this._degreeField = value;
        return this;
    }

    public boolean hasDegrees() {
        if (this._degreesField != null) {
            return true;
        }
        return this._map.containsKey("degrees");
    }

    public void removeDegrees() {
        this._map.remove("degrees");
    }

    @Nullable
    public IntegerArray getDegrees(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getDegrees();
            }
            case NULL: {
                if (this._degreesField != null) {
                    return this._degreesField;
                }
                Object __rawValue = this._map.get("degrees");
                this._degreesField = __rawValue == null ? null : new IntegerArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._degreesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public IntegerArray getDegrees() {
        if (this._degreesField != null) {
            return this._degreesField;
        }
        Object __rawValue = this._map.get("degrees");
        if (__rawValue == null) {
            return DEFAULT_Degrees;
        }
        this._degreesField = __rawValue == null ? null : new IntegerArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._degreesField;
    }

    public LineageSearchEntity setDegrees(@Nullable IntegerArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDegrees(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field degrees of com.linkedin.metadata.search.LineageSearchEntity");
                }
                CheckedUtil.putWithoutChecking(this._map, "degrees", value.data());
                this._degreesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDegrees();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "degrees", value.data());
                this._degreesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "degrees", value.data());
                this._degreesField = value;
            }
        }
        return this;
    }

    public LineageSearchEntity setDegrees(@Nonnull IntegerArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field degrees of com.linkedin.metadata.search.LineageSearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "degrees", value.data());
        this._degreesField = value;
        return this;
    }

    public boolean hasExplored() {
        if (this._exploredField != null) {
            return true;
        }
        return this._map.containsKey("explored");
    }

    public void removeExplored() {
        this._map.remove("explored");
    }

    @Nullable
    public Boolean isExplored(GetMode mode) {
        return this.isExplored();
    }

    @Nullable
    public Boolean isExplored() {
        if (this._exploredField != null) {
            return this._exploredField;
        }
        Object __rawValue = this._map.get("explored");
        this._exploredField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._exploredField;
    }

    public LineageSearchEntity setExplored(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExplored(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExplored();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "explored", value);
                this._exploredField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "explored", value);
                this._exploredField = value;
            }
        }
        return this;
    }

    public LineageSearchEntity setExplored(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field explored of com.linkedin.metadata.search.LineageSearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "explored", value);
        this._exploredField = value;
        return this;
    }

    public LineageSearchEntity setExplored(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "explored", value);
        this._exploredField = value;
        return this;
    }

    public boolean hasTruncatedChildren() {
        if (this._truncatedChildrenField != null) {
            return true;
        }
        return this._map.containsKey("truncatedChildren");
    }

    public void removeTruncatedChildren() {
        this._map.remove("truncatedChildren");
    }

    @Nullable
    public Boolean isTruncatedChildren(GetMode mode) {
        return this.isTruncatedChildren();
    }

    @Nullable
    public Boolean isTruncatedChildren() {
        if (this._truncatedChildrenField != null) {
            return this._truncatedChildrenField;
        }
        Object __rawValue = this._map.get("truncatedChildren");
        this._truncatedChildrenField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._truncatedChildrenField;
    }

    public LineageSearchEntity setTruncatedChildren(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTruncatedChildren(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTruncatedChildren();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "truncatedChildren", value);
                this._truncatedChildrenField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "truncatedChildren", value);
                this._truncatedChildrenField = value;
            }
        }
        return this;
    }

    public LineageSearchEntity setTruncatedChildren(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field truncatedChildren of com.linkedin.metadata.search.LineageSearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "truncatedChildren", value);
        this._truncatedChildrenField = value;
        return this;
    }

    public LineageSearchEntity setTruncatedChildren(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "truncatedChildren", value);
        this._truncatedChildrenField = value;
        return this;
    }

    public boolean hasIgnoredAsHop() {
        if (this._ignoredAsHopField != null) {
            return true;
        }
        return this._map.containsKey("ignoredAsHop");
    }

    public void removeIgnoredAsHop() {
        this._map.remove("ignoredAsHop");
    }

    @Nullable
    public Boolean isIgnoredAsHop(GetMode mode) {
        return this.isIgnoredAsHop();
    }

    @Nullable
    public Boolean isIgnoredAsHop() {
        if (this._ignoredAsHopField != null) {
            return this._ignoredAsHopField;
        }
        Object __rawValue = this._map.get("ignoredAsHop");
        this._ignoredAsHopField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._ignoredAsHopField;
    }

    public LineageSearchEntity setIgnoredAsHop(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIgnoredAsHop(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIgnoredAsHop();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "ignoredAsHop", value);
                this._ignoredAsHopField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "ignoredAsHop", value);
                this._ignoredAsHopField = value;
            }
        }
        return this;
    }

    public LineageSearchEntity setIgnoredAsHop(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field ignoredAsHop of com.linkedin.metadata.search.LineageSearchEntity to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "ignoredAsHop", value);
        this._ignoredAsHopField = value;
        return this;
    }

    public LineageSearchEntity setIgnoredAsHop(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "ignoredAsHop", value);
        this._ignoredAsHopField = value;
        return this;
    }

    @Override
    public LineageSearchEntity clone() throws CloneNotSupportedException {
        LineageSearchEntity __clone = (LineageSearchEntity)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public LineageSearchEntity copy() throws CloneNotSupportedException {
        LineageSearchEntity __copy = (LineageSearchEntity)super.copy();
        __copy._ignoredAsHopField = null;
        __copy._matchedFieldsField = null;
        __copy._degreeField = null;
        __copy._truncatedChildrenField = null;
        __copy._degreesField = null;
        __copy._restrictedAspectsField = null;
        __copy._featuresField = null;
        __copy._scoreField = null;
        __copy._pathField = null;
        __copy._pathsField = null;
        __copy._exploredField = null;
        __copy._entityField = null;
        __copy._extraFieldsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Features = SCHEMA.getField("features");
        FIELD_Score = SCHEMA.getField("score");
        FIELD_RestrictedAspects = SCHEMA.getField("restrictedAspects");
        FIELD_ExtraFields = SCHEMA.getField("extraFields");
        FIELD_Paths = SCHEMA.getField("paths");
        FIELD_Path = SCHEMA.getField("path");
        FIELD_Degree = SCHEMA.getField("degree");
        FIELD_Degrees = SCHEMA.getField("degrees");
        FIELD_Explored = SCHEMA.getField("explored");
        FIELD_TruncatedChildren = SCHEMA.getField("truncatedChildren");
        FIELD_IgnoredAsHop = SCHEMA.getField("ignoredAsHop");
        Custom.initializeCustomClass(Urn.class);
        DEFAULT_MatchedFields = FIELD_MatchedFields.getDefault() == null ? null : new MatchedFieldArray(DataTemplateUtil.castOrThrow(FIELD_MatchedFields.getDefault(), DataList.class));
        DEFAULT_Paths = FIELD_Paths.getDefault() == null ? null : new UrnArrayArray(DataTemplateUtil.castOrThrow(FIELD_Paths.getDefault(), DataList.class));
        DEFAULT_Path = FIELD_Path.getDefault() == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(FIELD_Path.getDefault(), DataList.class));
        DEFAULT_Degree = DataTemplateUtil.coerceIntOutput(FIELD_Degree.getDefault());
        DEFAULT_Degrees = FIELD_Degrees.getDefault() == null ? null : new IntegerArray(DataTemplateUtil.castOrThrow(FIELD_Degrees.getDefault(), DataList.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final LineageSearchEntity __objectRef;

        private ChangeListener(LineageSearchEntity reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "ignoredAsHop": {
                    this.__objectRef._ignoredAsHopField = null;
                    break;
                }
                case "matchedFields": {
                    this.__objectRef._matchedFieldsField = null;
                    break;
                }
                case "degree": {
                    this.__objectRef._degreeField = null;
                    break;
                }
                case "truncatedChildren": {
                    this.__objectRef._truncatedChildrenField = null;
                    break;
                }
                case "degrees": {
                    this.__objectRef._degreesField = null;
                    break;
                }
                case "restrictedAspects": {
                    this.__objectRef._restrictedAspectsField = null;
                    break;
                }
                case "features": {
                    this.__objectRef._featuresField = null;
                    break;
                }
                case "score": {
                    this.__objectRef._scoreField = null;
                    break;
                }
                case "path": {
                    this.__objectRef._pathField = null;
                    break;
                }
                case "paths": {
                    this.__objectRef._pathsField = null;
                    break;
                }
                case "explored": {
                    this.__objectRef._exploredField = null;
                    break;
                }
                case "entity": {
                    this.__objectRef._entityField = null;
                    break;
                }
                case "extraFields": {
                    this.__objectRef._extraFieldsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec entity() {
            return new PathSpec(this.getPathComponents(), "entity");
        }

        public MatchedFieldArray.Fields matchedFields() {
            return new MatchedFieldArray.Fields(this.getPathComponents(), "matchedFields");
        }

        public PathSpec matchedFields(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "matchedFields");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec features() {
            return new PathSpec(this.getPathComponents(), "features");
        }

        public PathSpec score() {
            return new PathSpec(this.getPathComponents(), "score");
        }

        public PathSpec restrictedAspects() {
            return new PathSpec(this.getPathComponents(), "restrictedAspects");
        }

        public PathSpec restrictedAspects(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "restrictedAspects");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec extraFields() {
            return new PathSpec(this.getPathComponents(), "extraFields");
        }

        public PathSpec paths() {
            return new PathSpec(this.getPathComponents(), "paths");
        }

        public PathSpec paths(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "paths");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        @Deprecated
        public PathSpec path() {
            return new PathSpec(this.getPathComponents(), "path");
        }

        @Deprecated
        public PathSpec path(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "path");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        @Deprecated
        public PathSpec degree() {
            return new PathSpec(this.getPathComponents(), "degree");
        }

        public PathSpec degrees() {
            return new PathSpec(this.getPathComponents(), "degrees");
        }

        public PathSpec degrees(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "degrees");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec explored() {
            return new PathSpec(this.getPathComponents(), "explored");
        }

        public PathSpec truncatedChildren() {
            return new PathSpec(this.getPathComponents(), "truncatedChildren");
        }

        public PathSpec ignoredAsHop() {
            return new PathSpec(this.getPathComponents(), "ignoredAsHop");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private MatchedFieldArray.ProjectionMask _matchedFieldsMask;

        ProjectionMask() {
        }

        public ProjectionMask withEntity() {
            this.getDataMap().put("entity", 1);
            return this;
        }

        public ProjectionMask withMatchedFields(Function<MatchedFieldArray.ProjectionMask, MatchedFieldArray.ProjectionMask> nestedMask) {
            this._matchedFieldsMask = nestedMask.apply(this._matchedFieldsMask == null ? MatchedFieldArray.createMask() : this._matchedFieldsMask);
            this.getDataMap().put("matchedFields", this._matchedFieldsMask.getDataMap());
            return this;
        }

        public ProjectionMask withMatchedFields() {
            this._matchedFieldsMask = null;
            this.getDataMap().put("matchedFields", 1);
            return this;
        }

        public ProjectionMask withMatchedFields(Function<MatchedFieldArray.ProjectionMask, MatchedFieldArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._matchedFieldsMask = nestedMask.apply(this._matchedFieldsMask == null ? MatchedFieldArray.createMask() : this._matchedFieldsMask);
            this.getDataMap().put("matchedFields", this._matchedFieldsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("matchedFields").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("matchedFields").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withMatchedFields(Integer start, Integer count) {
            this._matchedFieldsMask = null;
            this.getDataMap().put("matchedFields", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("matchedFields").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("matchedFields").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFeatures() {
            this.getDataMap().put("features", 1);
            return this;
        }

        public ProjectionMask withScore() {
            this.getDataMap().put("score", 1);
            return this;
        }

        public ProjectionMask withRestrictedAspects() {
            this.getDataMap().put("restrictedAspects", 1);
            return this;
        }

        public ProjectionMask withRestrictedAspects(Integer start, Integer count) {
            this.getDataMap().put("restrictedAspects", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("restrictedAspects").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("restrictedAspects").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withExtraFields() {
            this.getDataMap().put("extraFields", 1);
            return this;
        }

        public ProjectionMask withPaths() {
            this.getDataMap().put("paths", 1);
            return this;
        }

        public ProjectionMask withPaths(Integer start, Integer count) {
            this.getDataMap().put("paths", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("paths").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("paths").put("$count", count);
            }
            return this;
        }

        @Deprecated
        public ProjectionMask withPath() {
            this.getDataMap().put("path", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withPath(Integer start, Integer count) {
            this.getDataMap().put("path", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("path").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("path").put("$count", count);
            }
            return this;
        }

        @Deprecated
        public ProjectionMask withDegree() {
            this.getDataMap().put("degree", 1);
            return this;
        }

        public ProjectionMask withDegrees() {
            this.getDataMap().put("degrees", 1);
            return this;
        }

        public ProjectionMask withDegrees(Integer start, Integer count) {
            this.getDataMap().put("degrees", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("degrees").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("degrees").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withExplored() {
            this.getDataMap().put("explored", 1);
            return this;
        }

        public ProjectionMask withTruncatedChildren() {
            this.getDataMap().put("truncatedChildren", 1);
            return this;
        }

        public ProjectionMask withIgnoredAsHop() {
            this.getDataMap().put("ignoredAsHop", 1);
            return this;
        }
    }
}

