/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.annotation;

import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.annotation.AnnotationUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class UrnValidationAnnotation {
    public static final String ANNOTATION_NAME = "UrnValidation";
    private final boolean exist;
    private final boolean strict;
    private final List<String> entityTypes;

    @Nonnull
    public static UrnValidationAnnotation fromPegasusAnnotationObject(@Nonnull Object annotationObj, @Nonnull String schemaFieldName, @Nonnull String context) {
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid value type provided (Expected Map)", ANNOTATION_NAME, context));
        }
        Map map = (Map)annotationObj;
        Optional<Boolean> exist = AnnotationUtils.getField(map, "exist", Boolean.class);
        Optional<Boolean> strict = AnnotationUtils.getField(map, "strict", Boolean.class);
        List<String> entityTypes = AnnotationUtils.getFieldList(map, "entityTypes", String.class);
        return new UrnValidationAnnotation(exist.orElse(true), strict.orElse(true), entityTypes);
    }

    @Generated
    public UrnValidationAnnotation(boolean exist, boolean strict, List<String> entityTypes) {
        this.exist = exist;
        this.strict = strict;
        this.entityTypes = entityTypes;
    }

    @Generated
    public boolean isExist() {
        return this.exist;
    }

    @Generated
    public boolean isStrict() {
        return this.strict;
    }

    @Generated
    public List<String> getEntityTypes() {
        return this.entityTypes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UrnValidationAnnotation)) {
            return false;
        }
        UrnValidationAnnotation other = (UrnValidationAnnotation)o;
        if (this.isExist() != other.isExist()) {
            return false;
        }
        if (this.isStrict() != other.isStrict()) {
            return false;
        }
        List<String> this$entityTypes = this.getEntityTypes();
        List<String> other$entityTypes = other.getEntityTypes();
        return !(this$entityTypes == null ? other$entityTypes != null : !((Object)this$entityTypes).equals(other$entityTypes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExist() ? 79 : 97);
        result = result * 59 + (this.isStrict() ? 79 : 97);
        List<String> $entityTypes = this.getEntityTypes();
        result = result * 59 + ($entityTypes == null ? 43 : ((Object)$entityTypes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UrnValidationAnnotation(exist=" + this.isExist() + ", strict=" + this.isStrict() + ", entityTypes=" + String.valueOf(this.getEntityTypes()) + ")";
    }
}

