/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.entity.ebean.batch;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.aspect.AspectRetriever;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.batch.MCPItem;
import com.linkedin.metadata.aspect.batch.PatchMCP;
import com.linkedin.metadata.aspect.patch.GenericJsonPatch;
import com.linkedin.metadata.aspect.patch.template.AspectTemplateEngine;
import com.linkedin.metadata.aspect.patch.template.common.GenericPatchTemplate;
import com.linkedin.metadata.entity.ebean.batch.ChangeItemImpl;
import com.linkedin.metadata.entity.validation.ValidationApiUtils;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.metadata.utils.EntityKeyUtils;
import com.linkedin.metadata.utils.GenericRecordUtils;
import com.linkedin.metadata.utils.SystemMetadataUtils;
import com.linkedin.mxe.MetadataChangeProposal;
import com.linkedin.mxe.SystemMetadata;
import com.linkedin.util.Pair;
import datahub.shaded.jackson.core.JsonProcessingException;
import datahub.shaded.jackson.core.StreamReadConstraints;
import datahub.shaded.jackson.databind.ObjectMapper;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonPatch;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchItemImpl
implements PatchMCP {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PatchItemImpl.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Urn urn;
    private final String aspectName;
    private SystemMetadata systemMetadata;
    private final AuditStamp auditStamp;
    @Nonnull
    private final JsonPatch patch;
    @Nullable
    private final GenericJsonPatch genericJsonPatch;
    private final MetadataChangeProposal metadataChangeProposal;
    private final EntitySpec entitySpec;
    private final AspectSpec aspectSpec;

    @Override
    @Nonnull
    public ChangeType getChangeType() {
        return ChangeType.PATCH;
    }

    @Override
    @Nullable
    public RecordTemplate getRecordTemplate() {
        return null;
    }

    @Override
    @Nonnull
    public MetadataChangeProposal getMetadataChangeProposal() {
        if (this.metadataChangeProposal != null) {
            return this.metadataChangeProposal;
        }
        MetadataChangeProposal mcp = new MetadataChangeProposal();
        mcp.setEntityUrn(this.getUrn());
        mcp.setChangeType(this.getChangeType());
        mcp.setEntityType(this.getEntitySpec().getName());
        mcp.setAspectName(this.getAspectName());
        mcp.setAspect(GenericRecordUtils.serializePatch(this.getPatch()));
        mcp.setSystemMetadata(this.getSystemMetadata());
        mcp.setEntityKeyAspect(GenericRecordUtils.serializeAspect(EntityKeyUtils.convertUrnToEntityKey(this.getUrn(), this.entitySpec.getKeyAspectSpec())));
        return mcp;
    }

    @Override
    public void setSystemMetadata(@Nonnull SystemMetadata systemMetadata) {
        this.systemMetadata = systemMetadata;
        if (this.metadataChangeProposal != null) {
            this.metadataChangeProposal.setSystemMetadata(systemMetadata);
        }
    }

    @Override
    public ChangeItemImpl applyPatch(RecordTemplate recordTemplate, AspectRetriever aspectRetriever) {
        if (this.genericJsonPatch != null && (!this.genericJsonPatch.getArrayPrimaryKeys().isEmpty() || this.genericJsonPatch.isForceGenericPatch())) {
            return this.applyGenericPatch(recordTemplate, aspectRetriever);
        }
        return this.applyTemplatePatch(recordTemplate, aspectRetriever);
    }

    private ChangeItemImpl applyGenericPatch(RecordTemplate recordTemplate, AspectRetriever aspectRetriever) {
        try {
            GenericPatchTemplate<RecordTemplate> genericPatchTemplate = GenericPatchTemplate.builder().genericJsonPatch(this.genericJsonPatch).templateType(this.aspectSpec.getDataTemplateClass()).templateDefault(this.aspectSpec.getDataTemplateClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).build();
            return ChangeItemImpl.fromPatch(this.urn, this.aspectSpec, recordTemplate, genericPatchTemplate, this.auditStamp, aspectRetriever);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ChangeItemImpl applyTemplatePatch(RecordTemplate recordTemplate, AspectRetriever aspectRetriever) {
        RecordTemplate currentValue;
        ChangeItemImpl.ChangeItemImplBuilder builder = ChangeItemImpl.builder().urn(this.getUrn()).aspectName(this.getAspectName()).metadataChangeProposal(this.getMetadataChangeProposal()).auditStamp(this.auditStamp).systemMetadata(this.getSystemMetadata());
        AspectTemplateEngine aspectTemplateEngine = aspectRetriever.getEntityRegistry().getAspectTemplateEngine();
        RecordTemplate recordTemplate2 = currentValue = recordTemplate != null ? recordTemplate : aspectTemplateEngine.getDefaultTemplate(this.getAspectName());
        if (currentValue == null) {
            throw new UnsupportedOperationException(String.format("Patch not supported for aspect with name %s. Default aspect is required because no aspect currently exists for urn %s.", this.getAspectName(), this.getUrn()));
        }
        try {
            builder.recordTemplate(aspectTemplateEngine.applyPatch(currentValue, this.getPatch(), this.getAspectSpec()));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return builder.build(aspectRetriever);
    }

    @Override
    public boolean isDatabaseDuplicateOf(BatchItem other) {
        return this.equals(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchItemImpl that = (PatchItemImpl)o;
        return this.urn.equals(that.urn) && this.aspectName.equals(that.aspectName) && Objects.equals(this.systemMetadata, that.systemMetadata) && this.auditStamp.equals(that.auditStamp) && this.patch.equals(that.patch) && Objects.equals(this.genericJsonPatch, that.genericJsonPatch);
    }

    public int hashCode() {
        return Objects.hash(this.urn, this.aspectName, this.systemMetadata, this.auditStamp, this.patch, this.genericJsonPatch);
    }

    public String toString() {
        return "PatchBatchItem{urn=" + String.valueOf(this.urn) + ", aspectName='" + this.aspectName + "', systemMetadata=" + String.valueOf(this.systemMetadata) + ", patch=" + String.valueOf(this.patch) + "}";
    }

    @Generated
    PatchItemImpl(Urn urn, String aspectName, SystemMetadata systemMetadata, AuditStamp auditStamp, @Nonnull JsonPatch patch, @Nullable GenericJsonPatch genericJsonPatch, MetadataChangeProposal metadataChangeProposal, EntitySpec entitySpec, AspectSpec aspectSpec) {
        if (patch == null) {
            throw new NullPointerException("patch is marked non-null but is null");
        }
        this.urn = urn;
        this.aspectName = aspectName;
        this.systemMetadata = systemMetadata;
        this.auditStamp = auditStamp;
        this.patch = patch;
        this.genericJsonPatch = genericJsonPatch;
        this.metadataChangeProposal = metadataChangeProposal;
        this.entitySpec = entitySpec;
        this.aspectSpec = aspectSpec;
    }

    @Generated
    public static PatchItemImplBuilder builder() {
        return new PatchItemImplBuilder();
    }

    @Generated
    public PatchItemImplBuilder toBuilder() {
        return new PatchItemImplBuilder().urn(this.urn).aspectName(this.aspectName).systemMetadata(this.systemMetadata).auditStamp(this.auditStamp).patch(this.patch).genericJsonPatch(this.genericJsonPatch).metadataChangeProposal(this.metadataChangeProposal).entitySpec(this.entitySpec).aspectSpec(this.aspectSpec);
    }

    @Override
    @Generated
    public Urn getUrn() {
        return this.urn;
    }

    @Override
    @Generated
    public String getAspectName() {
        return this.aspectName;
    }

    @Override
    @Generated
    public SystemMetadata getSystemMetadata() {
        return this.systemMetadata;
    }

    @Override
    @Generated
    public AuditStamp getAuditStamp() {
        return this.auditStamp;
    }

    @Override
    @Nonnull
    @Generated
    public JsonPatch getPatch() {
        return this.patch;
    }

    @Nullable
    @Generated
    public GenericJsonPatch getGenericJsonPatch() {
        return this.genericJsonPatch;
    }

    @Override
    @Generated
    public EntitySpec getEntitySpec() {
        return this.entitySpec;
    }

    @Override
    @Generated
    public AspectSpec getAspectSpec() {
        return this.aspectSpec;
    }

    static {
        int maxSize = Integer.parseInt(System.getenv().getOrDefault("INGESTION_MAX_SERIALIZED_STRING_LENGTH", "16000000"));
        OBJECT_MAPPER.getFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(maxSize).build());
    }

    public static class PatchItemImplBuilder {
        @Generated
        private Urn urn;
        @Generated
        private String aspectName;
        @Generated
        private SystemMetadata systemMetadata;
        @Generated
        private AuditStamp auditStamp;
        @Generated
        private JsonPatch patch;
        @Generated
        private GenericJsonPatch genericJsonPatch;
        @Generated
        private MetadataChangeProposal metadataChangeProposal;
        @Generated
        private EntitySpec entitySpec;
        @Generated
        private AspectSpec aspectSpec;

        private PatchItemImpl build() {
            return null;
        }

        public PatchItemImplBuilder systemMetadata(SystemMetadata systemMetadata) {
            this.systemMetadata = SystemMetadataUtils.generateSystemMetadataIfEmpty(systemMetadata);
            return this;
        }

        public PatchItemImplBuilder aspectSpec(AspectSpec aspectSpec) {
            if (!MCPItem.isValidChangeType(ChangeType.PATCH, aspectSpec)) {
                throw new UnsupportedOperationException("ChangeType not supported: " + String.valueOf((Object)ChangeType.PATCH) + " for aspect " + this.aspectName);
            }
            this.aspectSpec = aspectSpec;
            return this;
        }

        public PatchItemImplBuilder patch(JsonPatch patch) {
            if (patch == null) {
                throw new IllegalArgumentException(String.format("Missing patch to apply. Item: %s", this));
            }
            this.patch = patch;
            return this;
        }

        public PatchItemImpl build(EntityRegistry entityRegistry) {
            this.urn(ValidationApiUtils.validateUrn(entityRegistry, this.urn));
            log.debug("entity type = {}", (Object)this.urn.getEntityType());
            this.entitySpec(ValidationApiUtils.validateEntity(entityRegistry, this.urn.getEntityType()));
            log.debug("entity spec = {}", (Object)this.entitySpec);
            this.aspectSpec(ValidationApiUtils.validateAspect(this.entitySpec, this.aspectName));
            log.debug("aspect spec = {}", (Object)this.aspectSpec);
            if (this.systemMetadata == null) {
                this.systemMetadata(null);
            }
            this.systemMetadata = SystemMetadataUtils.setAspectModified(this.systemMetadata, this.auditStamp);
            return new PatchItemImpl(this.urn, this.aspectName, this.systemMetadata, this.auditStamp, Objects.requireNonNull(this.patch), this.genericJsonPatch, this.metadataChangeProposal, this.entitySpec, this.aspectSpec);
        }

        public PatchItemImpl build(MetadataChangeProposal mcp, AuditStamp auditStamp, EntityRegistry entityRegistry) {
            this.metadataChangeProposal = ValidationApiUtils.validateMCP(entityRegistry, mcp);
            this.urn = this.metadataChangeProposal.getEntityUrn();
            this.auditStamp = auditStamp;
            this.aspectName = mcp.getAspectName();
            this.systemMetadata(mcp.getSystemMetadata());
            Pair<JsonPatch, Optional<GenericJsonPatch>> parsedJson = PatchItemImplBuilder.convertToJsonPatch(mcp);
            this.patch(parsedJson.getFirst());
            parsedJson.getSecond().ifPresent(generic -> {
                this.genericJsonPatch = generic;
            });
            this.entitySpec(entityRegistry.getEntitySpec(this.urn.getEntityType()));
            this.aspectSpec(this.entitySpec.getAspectSpec(this.aspectName));
            return new PatchItemImpl(this.urn, this.aspectName, this.systemMetadata, this.auditStamp, this.patch, this.genericJsonPatch, this.metadataChangeProposal, this.entitySpec, this.aspectSpec);
        }

        private static Pair<JsonPatch, Optional<GenericJsonPatch>> convertToJsonPatch(MetadataChangeProposal mcp) {
            try {
                JsonObject jsonObject;
                String jsonString = mcp.getAspect().getValue().asString(StandardCharsets.UTF_8);
                JsonReader reader = Json.createReader(new StringReader(jsonString));
                JsonStructure jsonStructure = reader.read();
                Optional<Object> genericJsonPatch = Optional.empty();
                if (jsonStructure.getValueType() == JsonValue.ValueType.OBJECT && (jsonObject = (JsonObject)jsonStructure).containsKey("patch")) {
                    JsonPatch jsonPatch = Json.createPatch(jsonObject.getJsonArray("patch"));
                    genericJsonPatch = Optional.of(OBJECT_MAPPER.readValue(jsonString, GenericJsonPatch.class));
                    return Pair.of(jsonPatch, genericJsonPatch);
                }
                JsonPatch jsonPatch = Json.createPatch(Json.createReader(new StringReader(jsonString)).readArray());
                return Pair.of(jsonPatch, genericJsonPatch);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Invalid JSON Patch: " + mcp.getAspect().getValue().asString(StandardCharsets.UTF_8), e);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        @Generated
        PatchItemImplBuilder() {
        }

        @Generated
        public PatchItemImplBuilder urn(Urn urn) {
            this.urn = urn;
            return this;
        }

        @Generated
        public PatchItemImplBuilder aspectName(String aspectName) {
            this.aspectName = aspectName;
            return this;
        }

        @Generated
        public PatchItemImplBuilder auditStamp(AuditStamp auditStamp) {
            this.auditStamp = auditStamp;
            return this;
        }

        @Generated
        public PatchItemImplBuilder genericJsonPatch(@Nullable GenericJsonPatch genericJsonPatch) {
            this.genericJsonPatch = genericJsonPatch;
            return this;
        }

        @Generated
        public PatchItemImplBuilder metadataChangeProposal(MetadataChangeProposal metadataChangeProposal) {
            this.metadataChangeProposal = metadataChangeProposal;
            return this;
        }

        @Generated
        public PatchItemImplBuilder entitySpec(EntitySpec entitySpec) {
            this.entitySpec = entitySpec;
            return this;
        }

        @Generated
        public String toString() {
            return "PatchItemImpl.PatchItemImplBuilder(urn=" + String.valueOf(this.urn) + ", aspectName=" + this.aspectName + ", systemMetadata=" + String.valueOf(this.systemMetadata) + ", auditStamp=" + String.valueOf(this.auditStamp) + ", patch=" + String.valueOf(this.patch) + ", genericJsonPatch=" + String.valueOf(this.genericJsonPatch) + ", metadataChangeProposal=" + String.valueOf(this.metadataChangeProposal) + ", entitySpec=" + String.valueOf(this.entitySpec) + ", aspectSpec=" + String.valueOf(this.aspectSpec) + ")";
        }
    }
}

