/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.validation;

import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.aspect.ReadItem;
import com.linkedin.metadata.aspect.RetrieverContext;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.batch.ChangeMCP;
import com.linkedin.metadata.aspect.plugins.config.AspectPluginConfig;
import com.linkedin.metadata.aspect.plugins.validation.AspectPayloadValidator;
import com.linkedin.metadata.aspect.plugins.validation.AspectValidationException;
import com.linkedin.metadata.aspect.plugins.validation.ValidationExceptionCollection;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;

public class CreateIfNotExistsValidator
extends AspectPayloadValidator {
    public static final String FILTER_EXCEPTION_HEADER = "If-None-Match";
    public static final String FILTER_EXCEPTION_VALUE = "*";
    @Nonnull
    private AspectPluginConfig config;

    @Override
    protected Stream<AspectValidationException> validatePreCommitAspects(@Nonnull Collection<ChangeMCP> changeMCPs, @Nonnull RetrieverContext retrieverContext) {
        ValidationExceptionCollection exceptions = ValidationExceptionCollection.newCollection();
        Map entityKeyMap = changeMCPs.stream().filter(item -> item.getEntitySpec().getKeyAspectName().equals(item.getAspectName())).collect(Collectors.groupingBy(ReadItem::getUrn, Collectors.toSet()));
        for (ChangeMCP createEntityItem : changeMCPs.stream().filter(item -> ChangeType.CREATE_ENTITY.equals((Object)item.getChangeType())).collect(Collectors.toSet())) {
            if (entityKeyMap.containsKey(createEntityItem.getUrn())) continue;
            if (CreateIfNotExistsValidator.isPrecondition(createEntityItem)) {
                exceptions.addException(AspectValidationException.forFilter(createEntityItem, "Dropping write per precondition header If-None-Match: *"));
                continue;
            }
            exceptions.addException(createEntityItem, "Cannot perform CREATE_ENTITY if not exists since the entity key already exists.");
        }
        for (ChangeMCP createItem : changeMCPs.stream().filter(item -> ChangeType.CREATE.equals((Object)item.getChangeType())).collect(Collectors.toSet())) {
            if (createItem.getPreviousRecordTemplate() == null) continue;
            if (CreateIfNotExistsValidator.isPrecondition(createItem)) {
                exceptions.addException(AspectValidationException.forFilter(createItem, "Dropping write per precondition header If-None-Match: *"));
                continue;
            }
            exceptions.addException(createItem, "Cannot perform CREATE since the aspect already exists.");
        }
        return exceptions.streamAllExceptions();
    }

    @Override
    protected Stream<AspectValidationException> validateProposedAspects(@Nonnull Collection<? extends BatchItem> mcpItems, @Nonnull RetrieverContext retrieverContext) {
        return Stream.empty();
    }

    private static boolean isPrecondition(ChangeMCP item) {
        return item.getHeader(FILTER_EXCEPTION_HEADER).map(FILTER_EXCEPTION_VALUE::equals).orElse(false);
    }

    @Override
    @Generated
    public CreateIfNotExistsValidator setConfig(@Nonnull AspectPluginConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        return this;
    }

    @Override
    @Nonnull
    @Generated
    public AspectPluginConfig getConfig() {
        return this.config;
    }
}

