/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.datahub.util.RecordUtils;
import com.linkedin.form.FormPrompt;
import com.linkedin.form.FormType;
import com.linkedin.metadata.aspect.patch.PatchOperationType;
import com.linkedin.metadata.aspect.patch.builder.AbstractMultiFieldPatchBuilder;
import datahub.shaded.jackson.core.JsonProcessingException;
import datahub.shaded.jackson.databind.ObjectMapper;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class FormInfoPatchBuilder
extends AbstractMultiFieldPatchBuilder<FormInfoPatchBuilder> {
    public static final String PATH_DELIM = "/";
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String TYPE_FIELD = "type";
    public static final String PROMPTS_FIELD = "prompts";
    public static final String ACTORS_FIELD = "actors";
    public static final String OWNERS_FIELD = "owners";
    public static final String USERS_FIELD = "users";
    public static final String GROUPS_FIELD = "groups";

    public FormInfoPatchBuilder setName(@Nonnull String name) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/name", JsonNodeFactory.instance.textNode(name)));
        return this;
    }

    public FormInfoPatchBuilder setDescription(@Nullable String description) {
        if (description == null) {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/description", null));
        } else {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/description", JsonNodeFactory.instance.textNode(description)));
        }
        return this;
    }

    public FormInfoPatchBuilder setType(@Nonnull FormType formType) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/type", JsonNodeFactory.instance.textNode(formType.toString())));
        return this;
    }

    public FormInfoPatchBuilder addPrompt(@Nonnull FormPrompt prompt) {
        try {
            ObjectNode promptNode = (ObjectNode)new ObjectMapper().readTree(RecordUtils.toJsonString(prompt));
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/prompts/" + prompt.getId(), promptNode));
            return this;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to add prompt, failed to parse provided aspect json.", e);
        }
    }

    public FormInfoPatchBuilder addPrompts(@Nonnull List<FormPrompt> prompts) {
        try {
            prompts.forEach(this::addPrompt);
            return this;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to add prompts.", e);
        }
    }

    public FormInfoPatchBuilder removePrompt(@Nonnull String promptId) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/prompts/" + promptId, null));
        return this;
    }

    public FormInfoPatchBuilder removePrompts(@Nonnull List<String> promptIds) {
        promptIds.forEach(this::removePrompt);
        return this;
    }

    public FormInfoPatchBuilder setOwnershipForm(boolean isOwnershipForm) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/actors/owners", JsonNodeFactory.instance.booleanNode(isOwnershipForm)));
        return this;
    }

    public FormInfoPatchBuilder addAssignedUser(@Nonnull String userUrn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/actors/users/" + userUrn, JsonNodeFactory.instance.textNode(userUrn)));
        return this;
    }

    public FormInfoPatchBuilder removeAssignedUser(@Nonnull String userUrn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/actors/users/" + userUrn, JsonNodeFactory.instance.textNode(userUrn)));
        return this;
    }

    public FormInfoPatchBuilder addAssignedGroup(@Nonnull String groupUrn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/actors/groups/" + groupUrn, JsonNodeFactory.instance.textNode(groupUrn)));
        return this;
    }

    public FormInfoPatchBuilder removeAssignedGroup(@Nonnull String groupUrn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/actors/groups/" + groupUrn, JsonNodeFactory.instance.textNode(groupUrn)));
        return this;
    }

    @Override
    protected String getAspectName() {
        return "formInfo";
    }

    @Override
    protected String getEntityType() {
        return "form";
    }
}

