/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.linkedin.metadata.aspect.models.graph.RelatedEntitiesScrollResult;
import com.linkedin.metadata.query.filter.Filter;
import com.linkedin.metadata.query.filter.RelationshipFilter;
import com.linkedin.metadata.query.filter.SortCriterion;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface GraphRetriever {
    public static final int DEFAULT_EDGE_FETCH_LIMIT = 1000;
    public static final GraphRetriever EMPTY = new EmptyGraphRetriever();

    @Nonnull
    public RelatedEntitiesScrollResult scrollRelatedEntities(@Nullable Set<String> var1, @Nonnull Filter var2, @Nullable Set<String> var3, @Nonnull Filter var4, @Nonnull Set<String> var5, @Nonnull RelationshipFilter var6, @Nonnull List<SortCriterion> var7, @Nullable String var8, @Nullable Integer var9, @Nullable Long var10, @Nullable Long var11);

    default public void consumeRelatedEntities(@Nonnull Function<RelatedEntitiesScrollResult, Boolean> consumer, @Nullable Set<String> sourceTypes, @Nonnull Filter sourceEntityFilter, @Nullable Set<String> destinationTypes, @Nonnull Filter destinationEntityFilter, @Nonnull Set<String> relationshipTypes, @Nonnull RelationshipFilter relationshipFilter, @Nonnull List<SortCriterion> sortCriteria, @Nullable Integer count, @Nullable Long startTimeMillis, @Nullable Long endTimeMillis) {
        String scrollId = null;
        boolean exitCriteria = false;
        while (!exitCriteria) {
            RelatedEntitiesScrollResult result = this.scrollRelatedEntities(sourceTypes, sourceEntityFilter, destinationTypes, destinationEntityFilter, relationshipTypes, relationshipFilter, sortCriteria, scrollId, count, startTimeMillis, endTimeMillis);
            exitCriteria = consumer.apply(result);
            if (result == null || result.getEntities().isEmpty() || result.getScrollId() == null) {
                exitCriteria = true;
                continue;
            }
            scrollId = result.getScrollId();
        }
    }

    public static class EmptyGraphRetriever
    implements GraphRetriever {
        @Override
        @Nonnull
        public RelatedEntitiesScrollResult scrollRelatedEntities(@Nullable Set<String> sourceTypes, @Nonnull Filter sourceEntityFilter, @Nullable Set<String> destinationTypes, @Nonnull Filter destinationEntityFilter, @Nonnull Set<String> relationshipTypes, @Nonnull RelationshipFilter relationshipFilter, @Nonnull List<SortCriterion> sortCriterion, @Nullable String scrollId, @Nullable Integer count, @Nullable Long startTimeMillis, @Nullable Long endTimeMillis) {
            return new RelatedEntitiesScrollResult(0, 0, null, Collections.emptyList());
        }
    }
}

