/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.datahub.util.RecordUtils;
import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.common.urn.UrnUtils;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.entity.Aspect;
import com.linkedin.entity.AspectType;
import com.linkedin.entity.EnvelopedAspect;
import com.linkedin.metadata.aspect.SystemAspect;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.metadata.utils.SystemMetadataUtils;
import com.linkedin.mxe.GenericAspect;
import com.linkedin.mxe.SystemMetadata;
import java.sql.Timestamp;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityAspect.class);
    @Nonnull
    private String urn;
    @Nonnull
    private String aspect;
    private long version;
    private String metadata;
    private String systemMetadata;
    private Timestamp createdOn;
    private String createdBy;
    private String createdFor;

    public String toString() {
        return "EntityAspect{urn='" + this.urn + "', aspect='" + this.aspect + "', version=" + this.version + ", metadata='" + this.metadata + "', systemMetadata='" + this.systemMetadata + "'}";
    }

    @Generated
    public static EntityAspectBuilder builder() {
        return new EntityAspectBuilder();
    }

    @Generated
    public EntityAspectBuilder toBuilder() {
        return new EntityAspectBuilder().urn(this.urn).aspect(this.aspect).version(this.version).metadata(this.metadata).systemMetadata(this.systemMetadata).createdOn(this.createdOn).createdBy(this.createdBy).createdFor(this.createdFor);
    }

    @Nonnull
    @Generated
    public String getUrn() {
        return this.urn;
    }

    @Nonnull
    @Generated
    public String getAspect() {
        return this.aspect;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public String getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getSystemMetadata() {
        return this.systemMetadata;
    }

    @Generated
    public Timestamp getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public String getCreatedFor() {
        return this.createdFor;
    }

    @Generated
    public void setUrn(@Nonnull String urn) {
        if (urn == null) {
            throw new NullPointerException("urn is marked non-null but is null");
        }
        this.urn = urn;
    }

    @Generated
    public void setAspect(@Nonnull String aspect) {
        if (aspect == null) {
            throw new NullPointerException("aspect is marked non-null but is null");
        }
        this.aspect = aspect;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setSystemMetadata(String systemMetadata) {
        this.systemMetadata = systemMetadata;
    }

    @Generated
    public void setCreatedOn(Timestamp createdOn) {
        this.createdOn = createdOn;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setCreatedFor(String createdFor) {
        this.createdFor = createdFor;
    }

    @Generated
    public EntityAspect() {
    }

    @Generated
    public EntityAspect(@Nonnull String urn, @Nonnull String aspect, long version, String metadata, String systemMetadata, Timestamp createdOn, String createdBy, String createdFor) {
        if (urn == null) {
            throw new NullPointerException("urn is marked non-null but is null");
        }
        if (aspect == null) {
            throw new NullPointerException("aspect is marked non-null but is null");
        }
        this.urn = urn;
        this.aspect = aspect;
        this.version = version;
        this.metadata = metadata;
        this.systemMetadata = systemMetadata;
        this.createdOn = createdOn;
        this.createdBy = createdBy;
        this.createdFor = createdFor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityAspect)) {
            return false;
        }
        EntityAspect other = (EntityAspect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$urn = this.getUrn();
        String other$urn = other.getUrn();
        if (this$urn == null ? other$urn != null : !this$urn.equals(other$urn)) {
            return false;
        }
        String this$aspect = this.getAspect();
        String other$aspect = other.getAspect();
        if (this$aspect == null ? other$aspect != null : !this$aspect.equals(other$aspect)) {
            return false;
        }
        String this$metadata = this.getMetadata();
        String other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        String this$systemMetadata = this.getSystemMetadata();
        String other$systemMetadata = other.getSystemMetadata();
        if (this$systemMetadata == null ? other$systemMetadata != null : !this$systemMetadata.equals(other$systemMetadata)) {
            return false;
        }
        Timestamp this$createdOn = this.getCreatedOn();
        Timestamp other$createdOn = other.getCreatedOn();
        if (this$createdOn == null ? other$createdOn != null : !((Object)this$createdOn).equals(other$createdOn)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$createdFor = this.getCreatedFor();
        String other$createdFor = other.getCreatedFor();
        return !(this$createdFor == null ? other$createdFor != null : !this$createdFor.equals(other$createdFor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityAspect;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $urn = this.getUrn();
        result = result * 59 + ($urn == null ? 43 : $urn.hashCode());
        String $aspect = this.getAspect();
        result = result * 59 + ($aspect == null ? 43 : $aspect.hashCode());
        String $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        String $systemMetadata = this.getSystemMetadata();
        result = result * 59 + ($systemMetadata == null ? 43 : $systemMetadata.hashCode());
        Timestamp $createdOn = this.getCreatedOn();
        result = result * 59 + ($createdOn == null ? 43 : ((Object)$createdOn).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $createdFor = this.getCreatedFor();
        result = result * 59 + ($createdFor == null ? 43 : $createdFor.hashCode());
        return result;
    }

    @Generated
    public static class EntityAspectBuilder {
        @Generated
        private String urn;
        @Generated
        private String aspect;
        @Generated
        private long version;
        @Generated
        private String metadata;
        @Generated
        private String systemMetadata;
        @Generated
        private Timestamp createdOn;
        @Generated
        private String createdBy;
        @Generated
        private String createdFor;

        @Generated
        EntityAspectBuilder() {
        }

        @Generated
        public EntityAspectBuilder urn(@Nonnull String urn) {
            if (urn == null) {
                throw new NullPointerException("urn is marked non-null but is null");
            }
            this.urn = urn;
            return this;
        }

        @Generated
        public EntityAspectBuilder aspect(@Nonnull String aspect) {
            if (aspect == null) {
                throw new NullPointerException("aspect is marked non-null but is null");
            }
            this.aspect = aspect;
            return this;
        }

        @Generated
        public EntityAspectBuilder version(long version) {
            this.version = version;
            return this;
        }

        @Generated
        public EntityAspectBuilder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public EntityAspectBuilder systemMetadata(String systemMetadata) {
            this.systemMetadata = systemMetadata;
            return this;
        }

        @Generated
        public EntityAspectBuilder createdOn(Timestamp createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        @Generated
        public EntityAspectBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @Generated
        public EntityAspectBuilder createdFor(String createdFor) {
            this.createdFor = createdFor;
            return this;
        }

        @Generated
        public EntityAspect build() {
            return new EntityAspect(this.urn, this.aspect, this.version, this.metadata, this.systemMetadata, this.createdOn, this.createdBy, this.createdFor);
        }

        @Generated
        public String toString() {
            return "EntityAspect.EntityAspectBuilder(urn=" + this.urn + ", aspect=" + this.aspect + ", version=" + this.version + ", metadata=" + this.metadata + ", systemMetadata=" + this.systemMetadata + ", createdOn=" + String.valueOf(this.createdOn) + ", createdBy=" + this.createdBy + ", createdFor=" + this.createdFor + ")";
        }
    }

    public static class EntitySystemAspect
    implements SystemAspect {
        @Nullable
        private EntityAspect entityAspect;
        @Nonnull
        private final Urn urn;
        @Nullable
        private RecordTemplate recordTemplate;
        @Nullable
        private SystemMetadata systemMetadata;
        @Nullable
        private AuditStamp auditStamp;
        @Nonnull
        private final EntitySpec entitySpec;
        @Nullable
        private final AspectSpec aspectSpec;

        @Nonnull
        public String getUrnRaw() {
            return this.urn.toString();
        }

        @Override
        public Timestamp getCreatedOn() {
            return this.auditStamp != null ? new Timestamp(this.auditStamp.getTime()) : null;
        }

        @Override
        public String getCreatedBy() {
            return this.auditStamp != null ? this.auditStamp.getActor().toString() : null;
        }

        @Override
        @Nonnull
        public String getAspectName() {
            return this.aspectSpec.getName();
        }

        @Override
        public long getVersion() {
            return this.entityAspect == null ? 0L : this.entityAspect.getVersion();
        }

        public EnvelopedAspect toEnvelopedAspects() {
            Aspect aspect = new Aspect(this.getRecordTemplate().data());
            EnvelopedAspect envelopedAspect = new EnvelopedAspect();
            envelopedAspect.setName(this.getAspectName());
            envelopedAspect.setVersion(this.getVersion());
            envelopedAspect.setType(AspectType.VERSIONED);
            envelopedAspect.setValue(aspect);
            try {
                if (this.getSystemMetadata() != null) {
                    envelopedAspect.setSystemMetadata(this.getSystemMetadata());
                }
            }
            catch (Exception e) {
                log.warn("Exception encountered when setting system metadata on enveloped aspect {}. Error: {}", (Object)envelopedAspect.getName(), (Object)e.toString());
            }
            envelopedAspect.setCreated(this.getAuditStamp(), SetMode.IGNORE_NULL);
            return envelopedAspect;
        }

        @Override
        @Nonnull
        public SystemMetadata getSystemMetadata() {
            if (this.systemMetadata == null) {
                this.systemMetadata = this.entityAspect != null && this.entityAspect.getSystemMetadata() != null ? RecordUtils.toRecordTemplate(SystemMetadata.class, this.entityAspect.getSystemMetadata()) : SystemMetadataUtils.createDefaultSystemMetadata();
            }
            return this.systemMetadata;
        }

        @Override
        @Nonnull
        public SystemAspect copy() {
            return this.toBuilder().entityAspect(null).build();
        }

        @Override
        @Nonnull
        public Optional<SystemAspect> getDatabaseAspect() {
            return Optional.ofNullable(this.entityAspect).map(a -> EntitySystemAspect.builder().forUpdate(this.entitySpec, this.aspectSpec, (EntityAspect)a));
        }

        @Override
        @Nonnull
        public SystemAspect setDatabaseAspect(@Nonnull SystemAspect databaseAspect) {
            this.entityAspect = databaseAspect.withVersion(databaseAspect.getVersion());
            return this;
        }

        @Override
        @Nonnull
        public EntityAspect withVersion(long version) {
            return new EntityAspect(this.urn.toString(), this.aspectSpec.getName(), version, Optional.ofNullable(this.recordTemplate).map(RecordUtils::toJsonString).orElse(null), Optional.ofNullable(this.systemMetadata).map(RecordUtils::toJsonString).orElse(null), Optional.ofNullable(this.auditStamp).map(a -> new Timestamp(a.getTime())).orElse(null), Optional.ofNullable(this.auditStamp).map(AuditStamp::getActor).map(Urn::toString).orElse(null), Optional.ofNullable(this.auditStamp).map(AuditStamp::getImpersonator).map(Urn::toString).orElse(null));
        }

        @Generated
        public static EntitySystemAspectBuilder builder() {
            return new EntitySystemAspectBuilder();
        }

        @Generated
        public EntitySystemAspectBuilder toBuilder() {
            return new EntitySystemAspectBuilder().entityAspect(this.entityAspect).urn(this.urn).recordTemplate(this.recordTemplate).systemMetadata(this.systemMetadata).auditStamp(this.auditStamp).entitySpec(this.entitySpec).aspectSpec(this.aspectSpec);
        }

        @Nullable
        @Generated
        public EntityAspect getEntityAspect() {
            return this.entityAspect;
        }

        @Override
        @Nonnull
        @Generated
        public Urn getUrn() {
            return this.urn;
        }

        @Override
        @Nullable
        @Generated
        public RecordTemplate getRecordTemplate() {
            return this.recordTemplate;
        }

        @Override
        @Nullable
        @Generated
        public AuditStamp getAuditStamp() {
            return this.auditStamp;
        }

        @Override
        @Nonnull
        @Generated
        public EntitySpec getEntitySpec() {
            return this.entitySpec;
        }

        @Override
        @Nullable
        @Generated
        public AspectSpec getAspectSpec() {
            return this.aspectSpec;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntitySystemAspect)) {
                return false;
            }
            EntitySystemAspect other = (EntitySystemAspect)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EntityAspect this$entityAspect = this.getEntityAspect();
            EntityAspect other$entityAspect = other.getEntityAspect();
            if (this$entityAspect == null ? other$entityAspect != null : !((Object)this$entityAspect).equals(other$entityAspect)) {
                return false;
            }
            Urn this$urn = this.getUrn();
            Urn other$urn = other.getUrn();
            if (this$urn == null ? other$urn != null : !((Object)this$urn).equals(other$urn)) {
                return false;
            }
            RecordTemplate this$recordTemplate = this.getRecordTemplate();
            RecordTemplate other$recordTemplate = other.getRecordTemplate();
            if (this$recordTemplate == null ? other$recordTemplate != null : !((Object)this$recordTemplate).equals(other$recordTemplate)) {
                return false;
            }
            SystemMetadata this$systemMetadata = this.getSystemMetadata();
            SystemMetadata other$systemMetadata = other.getSystemMetadata();
            if (this$systemMetadata == null ? other$systemMetadata != null : !((Object)this$systemMetadata).equals(other$systemMetadata)) {
                return false;
            }
            AuditStamp this$auditStamp = this.getAuditStamp();
            AuditStamp other$auditStamp = other.getAuditStamp();
            if (this$auditStamp == null ? other$auditStamp != null : !((Object)this$auditStamp).equals(other$auditStamp)) {
                return false;
            }
            EntitySpec this$entitySpec = this.getEntitySpec();
            EntitySpec other$entitySpec = other.getEntitySpec();
            if (this$entitySpec == null ? other$entitySpec != null : !this$entitySpec.equals(other$entitySpec)) {
                return false;
            }
            AspectSpec this$aspectSpec = this.getAspectSpec();
            AspectSpec other$aspectSpec = other.getAspectSpec();
            return !(this$aspectSpec == null ? other$aspectSpec != null : !((Object)this$aspectSpec).equals(other$aspectSpec));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EntitySystemAspect;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EntityAspect $entityAspect = this.getEntityAspect();
            result = result * 59 + ($entityAspect == null ? 43 : ((Object)$entityAspect).hashCode());
            Urn $urn = this.getUrn();
            result = result * 59 + ($urn == null ? 43 : ((Object)$urn).hashCode());
            RecordTemplate $recordTemplate = this.getRecordTemplate();
            result = result * 59 + ($recordTemplate == null ? 43 : ((Object)$recordTemplate).hashCode());
            SystemMetadata $systemMetadata = this.getSystemMetadata();
            result = result * 59 + ($systemMetadata == null ? 43 : ((Object)$systemMetadata).hashCode());
            AuditStamp $auditStamp = this.getAuditStamp();
            result = result * 59 + ($auditStamp == null ? 43 : ((Object)$auditStamp).hashCode());
            EntitySpec $entitySpec = this.getEntitySpec();
            result = result * 59 + ($entitySpec == null ? 43 : $entitySpec.hashCode());
            AspectSpec $aspectSpec = this.getAspectSpec();
            result = result * 59 + ($aspectSpec == null ? 43 : ((Object)$aspectSpec).hashCode());
            return result;
        }

        @Generated
        public EntitySystemAspect(@Nullable EntityAspect entityAspect, @Nonnull Urn urn, @Nullable RecordTemplate recordTemplate, @Nullable SystemMetadata systemMetadata, @Nullable AuditStamp auditStamp, @Nonnull EntitySpec entitySpec, @Nullable AspectSpec aspectSpec) {
            if (urn == null) {
                throw new NullPointerException("urn is marked non-null but is null");
            }
            if (entitySpec == null) {
                throw new NullPointerException("entitySpec is marked non-null but is null");
            }
            this.entityAspect = entityAspect;
            this.urn = urn;
            this.recordTemplate = recordTemplate;
            this.systemMetadata = systemMetadata;
            this.auditStamp = auditStamp;
            this.entitySpec = entitySpec;
            this.aspectSpec = aspectSpec;
        }

        @Override
        @Generated
        public EntitySystemAspect setRecordTemplate(@Nullable RecordTemplate recordTemplate) {
            this.recordTemplate = recordTemplate;
            return this;
        }

        @Override
        @Generated
        public EntitySystemAspect setSystemMetadata(@Nullable SystemMetadata systemMetadata) {
            this.systemMetadata = systemMetadata;
            return this;
        }

        @Override
        @Generated
        public EntitySystemAspect setAuditStamp(@Nullable AuditStamp auditStamp) {
            this.auditStamp = auditStamp;
            return this;
        }

        public static class EntitySystemAspectBuilder {
            @Generated
            private EntityAspect entityAspect;
            @Generated
            private Urn urn;
            @Generated
            private RecordTemplate recordTemplate;
            @Generated
            private SystemMetadata systemMetadata;
            @Generated
            private AuditStamp auditStamp;
            @Generated
            private EntitySpec entitySpec;
            @Generated
            private AspectSpec aspectSpec;

            private EntitySystemAspect build() {
                return new EntitySystemAspect(this.entityAspect, this.urn, this.recordTemplate, this.systemMetadata, this.auditStamp, this.entitySpec, this.aspectSpec);
            }

            public EntitySystemAspect forInsert(@Nonnull EntityAspect entityAspect, @Nonnull EntityRegistry entityRegistry) {
                this.urn = UrnUtils.getUrn(entityAspect.getUrn());
                this.entitySpec = entityRegistry.getEntitySpec(this.urn.getEntityType());
                this.aspectSpec = this.entitySpec.getAspectSpec(entityAspect.getAspect());
                this.fromEntityAspect(entityAspect);
                return this.build();
            }

            public EntitySystemAspect forUpdate(@Nonnull EntityAspect entityAspect, @Nonnull EntityRegistry entityRegistry) {
                this.entityAspect = entityAspect;
                this.urn = UrnUtils.getUrn(entityAspect.getUrn());
                this.entitySpec = entityRegistry.getEntitySpec(this.urn.getEntityType());
                this.aspectSpec = this.entitySpec.getAspectSpec(entityAspect.getAspect());
                this.fromEntityAspect(this.entityAspect);
                return this.build();
            }

            public EntitySystemAspect forUpdate(@Nonnull EntitySpec entitySpec, @Nullable AspectSpec aspectSpec, @Nonnull EntityAspect entityAspect) {
                this.entityAspect = entityAspect;
                this.entitySpec = entitySpec;
                this.aspectSpec = aspectSpec;
                this.fromEntityAspect(this.entityAspect);
                return this.build();
            }

            private void fromEntityAspect(@Nonnull EntityAspect entityAspect) {
                this.urn = UrnUtils.getUrn(entityAspect.getUrn());
                if (entityAspect.getMetadata() != null) {
                    this.recordTemplate = RecordUtils.toRecordTemplate(this.aspectSpec == null ? GenericAspect.class : this.aspectSpec.getDataTemplateClass(), entityAspect.getMetadata());
                }
                if (entityAspect.getSystemMetadata() != null) {
                    this.systemMetadata = SystemMetadataUtils.parseSystemMetadata(entityAspect.getSystemMetadata());
                }
                if (entityAspect.getCreatedBy() != null) {
                    this.auditStamp = new AuditStamp().setActor(UrnUtils.getUrn(entityAspect.getCreatedBy())).setTime(entityAspect.getCreatedOn().getTime()).setImpersonator(Optional.ofNullable(entityAspect.getCreatedFor()).map(UrnUtils::getUrn).orElse(null), SetMode.IGNORE_NULL);
                }
            }

            @Generated
            EntitySystemAspectBuilder() {
            }

            @Generated
            public EntitySystemAspectBuilder entityAspect(@Nullable EntityAspect entityAspect) {
                this.entityAspect = entityAspect;
                return this;
            }

            @Generated
            public EntitySystemAspectBuilder urn(@Nonnull Urn urn) {
                if (urn == null) {
                    throw new NullPointerException("urn is marked non-null but is null");
                }
                this.urn = urn;
                return this;
            }

            @Generated
            public EntitySystemAspectBuilder recordTemplate(@Nullable RecordTemplate recordTemplate) {
                this.recordTemplate = recordTemplate;
                return this;
            }

            @Generated
            public EntitySystemAspectBuilder systemMetadata(@Nullable SystemMetadata systemMetadata) {
                this.systemMetadata = systemMetadata;
                return this;
            }

            @Generated
            public EntitySystemAspectBuilder auditStamp(@Nullable AuditStamp auditStamp) {
                this.auditStamp = auditStamp;
                return this;
            }

            @Generated
            public EntitySystemAspectBuilder entitySpec(@Nonnull EntitySpec entitySpec) {
                if (entitySpec == null) {
                    throw new NullPointerException("entitySpec is marked non-null but is null");
                }
                this.entitySpec = entitySpec;
                return this;
            }

            @Generated
            public EntitySystemAspectBuilder aspectSpec(@Nullable AspectSpec aspectSpec) {
                this.aspectSpec = aspectSpec;
                return this;
            }

            @Generated
            public String toString() {
                return "EntityAspect.EntitySystemAspect.EntitySystemAspectBuilder(entityAspect=" + String.valueOf(this.entityAspect) + ", urn=" + String.valueOf(this.urn) + ", recordTemplate=" + String.valueOf(this.recordTemplate) + ", systemMetadata=" + String.valueOf(this.systemMetadata) + ", auditStamp=" + String.valueOf(this.auditStamp) + ", entitySpec=" + String.valueOf(this.entitySpec) + ", aspectSpec=" + String.valueOf(this.aspectSpec) + ")";
            }
        }
    }
}

