/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AspectVersion
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.aspect/**A tuple of a specific metadata aspect and its version.*/record AspectVersion{/**The FQCN of the metadata aspect, e.g. com.linkedin.common.Ownership*/aspect:string/**The version of the metadata aspect*/version:long}", SchemaFormatType.PDL);
    private String _aspectField = null;
    private Long _versionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Aspect = SCHEMA.getField("aspect");
    private static final RecordDataSchema.Field FIELD_Version = SCHEMA.getField("version");

    public AspectVersion() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public AspectVersion(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasAspect() {
        if (this._aspectField != null) {
            return true;
        }
        return this._map.containsKey("aspect");
    }

    public void removeAspect() {
        this._map.remove("aspect");
    }

    @Nullable
    public String getAspect(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAspect();
            }
            case DEFAULT: 
            case NULL: {
                if (this._aspectField != null) {
                    return this._aspectField;
                }
                Object __rawValue = this._map.get("aspect");
                this._aspectField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._aspectField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getAspect() {
        if (this._aspectField != null) {
            return this._aspectField;
        }
        Object __rawValue = this._map.get("aspect");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("aspect");
        }
        this._aspectField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._aspectField;
    }

    public AspectVersion setAspect(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAspect(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field aspect of com.linkedin.metadata.aspect.AspectVersion");
                }
                CheckedUtil.putWithoutChecking(this._map, "aspect", value);
                this._aspectField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAspect();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aspect", value);
                this._aspectField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aspect", value);
                this._aspectField = value;
            }
        }
        return this;
    }

    public AspectVersion setAspect(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aspect of com.linkedin.metadata.aspect.AspectVersion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aspect", value);
        this._aspectField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public Long getVersion(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getVersion();
            }
            case DEFAULT: 
            case NULL: {
                if (this._versionField != null) {
                    return this._versionField;
                }
                Object __rawValue = this._map.get("version");
                this._versionField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._versionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("version");
        }
        this._versionField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._versionField;
    }

    public AspectVersion setVersion(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field version of com.linkedin.metadata.aspect.AspectVersion");
                }
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
                this._versionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
                this._versionField = value;
            }
        }
        return this;
    }

    public AspectVersion setVersion(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.metadata.aspect.AspectVersion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
        this._versionField = value;
        return this;
    }

    public AspectVersion setVersion(long value) {
        CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
        this._versionField = value;
        return this;
    }

    @Override
    public AspectVersion clone() throws CloneNotSupportedException {
        AspectVersion __clone = (AspectVersion)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public AspectVersion copy() throws CloneNotSupportedException {
        AspectVersion __copy = (AspectVersion)super.copy();
        __copy._aspectField = null;
        __copy._versionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final AspectVersion __objectRef;

        private ChangeListener(AspectVersion reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "aspect": {
                    this.__objectRef._aspectField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec aspect() {
            return new PathSpec(this.getPathComponents(), "aspect");
        }

        public PathSpec version() {
            return new PathSpec(this.getPathComponents(), "version");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withAspect() {
            this.getDataMap().put("aspect", 1);
            return this;
        }

        public ProjectionMask withVersion() {
            this.getDataMap().put("version", 1);
            return this;
        }
    }
}

