/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ingestion;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.ingestion.DataHubIngestionSourceConfig;
import com.linkedin.ingestion.DataHubIngestionSourceSchedule;
import com.linkedin.ingestion.DataHubIngestionSourceSource;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubIngestionSourceInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ingestion/**Info about a DataHub ingestion source*/@Aspect.name=\"dataHubIngestionSourceInfo\"record DataHubIngestionSourceInfo{/**The display name of the ingestion source*/@Searchable.fieldType=\"TEXT_PARTIAL\"name:string/**The type of the source itself, e.g. mysql, bigquery, bigquery-usage. Should match the recipe.*/@Searchable={\"fieldType\":\"KEYWORD\",\"queryByDefault\":false}type:string/**Data Platform URN associated with the source*/platform:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The schedule on which the ingestion source is executed*/schedule:optional/**The schedule associated with an ingestion source.*/record DataHubIngestionSourceSchedule{/**A cron-formatted execution interval, as a cron string, e.g. * * * * **/interval:string/**Timezone in which the cron interval applies, e.g. America/Los Angeles*/timezone:string}/**Parameters associated with the Ingestion Source*/config:record DataHubIngestionSourceConfig{/**The JSON recipe to use for ingestion*/recipe:string/**The PyPI version of the datahub CLI to use when executing a recipe*/version:optional string/**The id of the executor to use to execute the ingestion run*/@Searchable={\"fieldName\":\"sourceExecutorId\",\"fieldType\":\"KEYWORD\",\"queryByDefault\":false}executorId:optional string/**Whether or not to run this ingestion source in debug mode*/debugMode:optional boolean/**Extra arguments for the ingestion run.*/extraArgs:optional map[string,string]}/**The source or origin of the Ingestion Source\n\nCurrently CLI and UI do not provide an explicit source.*/source:optional record DataHubIngestionSourceSource{/**The source type of the ingestion source*/@Searchable={\"fieldName\":\"sourceType\",\"fieldType\":\"KEYWORD\",\"queryByDefault\":false}type:enum DataHubIngestionSourceSourceType{/**A system internal source, e.g. for running search indexing operations, feature computation, etc.*/SYSTEM}}}", SchemaFormatType.PDL);
    private String _nameField = null;
    private String _typeField = null;
    private Urn _platformField = null;
    private DataHubIngestionSourceSchedule _scheduleField = null;
    private DataHubIngestionSourceConfig _configField = null;
    private DataHubIngestionSourceSource _sourceField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Platform = SCHEMA.getField("platform");
    private static final RecordDataSchema.Field FIELD_Schedule = SCHEMA.getField("schedule");
    private static final RecordDataSchema.Field FIELD_Config = SCHEMA.getField("config");
    private static final RecordDataSchema.Field FIELD_Source = SCHEMA.getField("source");

    public DataHubIngestionSourceInfo() {
        super(new DataMap(8, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubIngestionSourceInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public DataHubIngestionSourceInfo setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.ingestion.DataHubIngestionSourceInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public DataHubIngestionSourceInfo setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.ingestion.DataHubIngestionSourceInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public String getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._typeField;
    }

    public DataHubIngestionSourceInfo setType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.ingestion.DataHubIngestionSourceInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
            }
        }
        return this;
    }

    public DataHubIngestionSourceInfo setType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.ingestion.DataHubIngestionSourceInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value);
        this._typeField = value;
        return this;
    }

    public boolean hasPlatform() {
        if (this._platformField != null) {
            return true;
        }
        return this._map.containsKey("platform");
    }

    public void removePlatform() {
        this._map.remove("platform");
    }

    @Nullable
    public Urn getPlatform(GetMode mode) {
        return this.getPlatform();
    }

    @Nullable
    public Urn getPlatform() {
        if (this._platformField != null) {
            return this._platformField;
        }
        Object __rawValue = this._map.get("platform");
        this._platformField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._platformField;
    }

    public DataHubIngestionSourceInfo setPlatform(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPlatform(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePlatform();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._platformField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._platformField = value;
            }
        }
        return this;
    }

    public DataHubIngestionSourceInfo setPlatform(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field platform of com.linkedin.ingestion.DataHubIngestionSourceInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._platformField = value;
        return this;
    }

    public boolean hasSchedule() {
        if (this._scheduleField != null) {
            return true;
        }
        return this._map.containsKey("schedule");
    }

    public void removeSchedule() {
        this._map.remove("schedule");
    }

    @Nullable
    public DataHubIngestionSourceSchedule getSchedule(GetMode mode) {
        return this.getSchedule();
    }

    @Nullable
    public DataHubIngestionSourceSchedule getSchedule() {
        if (this._scheduleField != null) {
            return this._scheduleField;
        }
        Object __rawValue = this._map.get("schedule");
        this._scheduleField = __rawValue == null ? null : new DataHubIngestionSourceSchedule(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._scheduleField;
    }

    public DataHubIngestionSourceInfo setSchedule(@Nullable DataHubIngestionSourceSchedule value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSchedule(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSchedule();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "schedule", value.data());
                this._scheduleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "schedule", value.data());
                this._scheduleField = value;
            }
        }
        return this;
    }

    public DataHubIngestionSourceInfo setSchedule(@Nonnull DataHubIngestionSourceSchedule value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field schedule of com.linkedin.ingestion.DataHubIngestionSourceInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "schedule", value.data());
        this._scheduleField = value;
        return this;
    }

    public boolean hasConfig() {
        if (this._configField != null) {
            return true;
        }
        return this._map.containsKey("config");
    }

    public void removeConfig() {
        this._map.remove("config");
    }

    @Nullable
    public DataHubIngestionSourceConfig getConfig(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getConfig();
            }
            case DEFAULT: 
            case NULL: {
                if (this._configField != null) {
                    return this._configField;
                }
                Object __rawValue = this._map.get("config");
                this._configField = __rawValue == null ? null : new DataHubIngestionSourceConfig(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._configField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataHubIngestionSourceConfig getConfig() {
        if (this._configField != null) {
            return this._configField;
        }
        Object __rawValue = this._map.get("config");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("config");
        }
        this._configField = __rawValue == null ? null : new DataHubIngestionSourceConfig(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._configField;
    }

    public DataHubIngestionSourceInfo setConfig(@Nullable DataHubIngestionSourceConfig value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setConfig(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field config of com.linkedin.ingestion.DataHubIngestionSourceInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "config", value.data());
                this._configField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeConfig();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "config", value.data());
                this._configField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "config", value.data());
                this._configField = value;
            }
        }
        return this;
    }

    public DataHubIngestionSourceInfo setConfig(@Nonnull DataHubIngestionSourceConfig value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field config of com.linkedin.ingestion.DataHubIngestionSourceInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "config", value.data());
        this._configField = value;
        return this;
    }

    public boolean hasSource() {
        if (this._sourceField != null) {
            return true;
        }
        return this._map.containsKey("source");
    }

    public void removeSource() {
        this._map.remove("source");
    }

    @Nullable
    public DataHubIngestionSourceSource getSource(GetMode mode) {
        return this.getSource();
    }

    @Nullable
    public DataHubIngestionSourceSource getSource() {
        if (this._sourceField != null) {
            return this._sourceField;
        }
        Object __rawValue = this._map.get("source");
        this._sourceField = __rawValue == null ? null : new DataHubIngestionSourceSource(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._sourceField;
    }

    public DataHubIngestionSourceInfo setSource(@Nullable DataHubIngestionSourceSource value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSource(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSource();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "source", value.data());
                this._sourceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "source", value.data());
                this._sourceField = value;
            }
        }
        return this;
    }

    public DataHubIngestionSourceInfo setSource(@Nonnull DataHubIngestionSourceSource value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field source of com.linkedin.ingestion.DataHubIngestionSourceInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "source", value.data());
        this._sourceField = value;
        return this;
    }

    @Override
    public DataHubIngestionSourceInfo clone() throws CloneNotSupportedException {
        DataHubIngestionSourceInfo __clone = (DataHubIngestionSourceInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubIngestionSourceInfo copy() throws CloneNotSupportedException {
        DataHubIngestionSourceInfo __copy = (DataHubIngestionSourceInfo)super.copy();
        __copy._scheduleField = null;
        __copy._nameField = null;
        __copy._sourceField = null;
        __copy._typeField = null;
        __copy._configField = null;
        __copy._platformField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubIngestionSourceInfo __objectRef;

        private ChangeListener(DataHubIngestionSourceInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "schedule": {
                    this.__objectRef._scheduleField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "source": {
                    this.__objectRef._sourceField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "config": {
                    this.__objectRef._configField = null;
                    break;
                }
                case "platform": {
                    this.__objectRef._platformField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec platform() {
            return new PathSpec(this.getPathComponents(), "platform");
        }

        public DataHubIngestionSourceSchedule.Fields schedule() {
            return new DataHubIngestionSourceSchedule.Fields(this.getPathComponents(), "schedule");
        }

        public DataHubIngestionSourceConfig.Fields config() {
            return new DataHubIngestionSourceConfig.Fields(this.getPathComponents(), "config");
        }

        public DataHubIngestionSourceSource.Fields source() {
            return new DataHubIngestionSourceSource.Fields(this.getPathComponents(), "source");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private DataHubIngestionSourceSchedule.ProjectionMask _scheduleMask;
        private DataHubIngestionSourceConfig.ProjectionMask _configMask;
        private DataHubIngestionSourceSource.ProjectionMask _sourceMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withPlatform() {
            this.getDataMap().put("platform", 1);
            return this;
        }

        public ProjectionMask withSchedule(Function<DataHubIngestionSourceSchedule.ProjectionMask, DataHubIngestionSourceSchedule.ProjectionMask> nestedMask) {
            this._scheduleMask = nestedMask.apply(this._scheduleMask == null ? DataHubIngestionSourceSchedule.createMask() : this._scheduleMask);
            this.getDataMap().put("schedule", this._scheduleMask.getDataMap());
            return this;
        }

        public ProjectionMask withSchedule() {
            this._scheduleMask = null;
            this.getDataMap().put("schedule", 1);
            return this;
        }

        public ProjectionMask withConfig(Function<DataHubIngestionSourceConfig.ProjectionMask, DataHubIngestionSourceConfig.ProjectionMask> nestedMask) {
            this._configMask = nestedMask.apply(this._configMask == null ? DataHubIngestionSourceConfig.createMask() : this._configMask);
            this.getDataMap().put("config", this._configMask.getDataMap());
            return this;
        }

        public ProjectionMask withConfig() {
            this._configMask = null;
            this.getDataMap().put("config", 1);
            return this;
        }

        public ProjectionMask withSource(Function<DataHubIngestionSourceSource.ProjectionMask, DataHubIngestionSourceSource.ProjectionMask> nestedMask) {
            this._sourceMask = nestedMask.apply(this._sourceMask == null ? DataHubIngestionSourceSource.createMask() : this._sourceMask);
            this.getDataMap().put("source", this._sourceMask.getDataMap());
            return this;
        }

        public ProjectionMask withSource() {
            this._sourceMask = null;
            this.getDataMap().put("source", 1);
            return this;
        }
    }
}

