/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.incident;

import com.linkedin.common.AuditStamp;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.incident.IncidentStage;
import com.linkedin.incident.IncidentState;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IncidentStatus
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.incident/**Information about an incident raised on an asset*/record IncidentStatus{/**The top-level state of the incident, whether it's active or resolved.*/@Searchable={\"addToFilters\":true,\"filterNameOverride\":\"Status\"}state:enum IncidentState{/**The incident is ongoing, or active.*/ACTIVE/**The incident is resolved.*/RESOLVED}/**The lifecycle stage for the incident - Null means no stage was assigned yet.\nIn the future, we may add CUSTOM here with a customStage string field for user-defined stages.*/@Searchable={\"addToFilters\":true,\"filterNameOverride\":\"Stage\"}stage:optional enum IncidentStage{/**The impact and priority of the incident is being actively assessed.*/TRIAGE/**The incident root cause is being investigated.*/INVESTIGATION/**The incident is in the remediation stage.*/WORK_IN_PROGRESS/**The incident is in the resolved as completed stage.*/FIXED/**The incident is in the resolved with no action required state, e.g. the\nincident was a false positive, or was expected.*/NO_ACTION_REQUIRED}/**Optional message associated with the incident*/message:optional string/**The time at which the request was initially created*/@Searchable.`/time`={\"fieldName\":\"lastUpdated\",\"fieldType\":\"COUNT\"}lastUpdated:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}", SchemaFormatType.PDL);
    private IncidentState _stateField = null;
    private IncidentStage _stageField = null;
    private String _messageField = null;
    private AuditStamp _lastUpdatedField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_State = SCHEMA.getField("state");
    private static final RecordDataSchema.Field FIELD_Stage = SCHEMA.getField("stage");
    private static final RecordDataSchema.Field FIELD_Message = SCHEMA.getField("message");
    private static final RecordDataSchema.Field FIELD_LastUpdated = SCHEMA.getField("lastUpdated");

    public IncidentStatus() {
        super(new DataMap(6, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public IncidentStatus(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasState() {
        if (this._stateField != null) {
            return true;
        }
        return this._map.containsKey("state");
    }

    public void removeState() {
        this._map.remove("state");
    }

    @Nullable
    public IncidentState getState(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getState();
            }
            case DEFAULT: 
            case NULL: {
                if (this._stateField != null) {
                    return this._stateField;
                }
                Object __rawValue = this._map.get("state");
                this._stateField = DataTemplateUtil.coerceEnumOutput(__rawValue, IncidentState.class, IncidentState.$UNKNOWN);
                return this._stateField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public IncidentState getState() {
        if (this._stateField != null) {
            return this._stateField;
        }
        Object __rawValue = this._map.get("state");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("state");
        }
        this._stateField = DataTemplateUtil.coerceEnumOutput(__rawValue, IncidentState.class, IncidentState.$UNKNOWN);
        return this._stateField;
    }

    public IncidentStatus setState(@Nullable IncidentState value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setState(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field state of com.linkedin.incident.IncidentStatus");
                }
                CheckedUtil.putWithoutChecking(this._map, "state", value.name());
                this._stateField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeState();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "state", value.name());
                this._stateField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "state", value.name());
                this._stateField = value;
            }
        }
        return this;
    }

    public IncidentStatus setState(@Nonnull IncidentState value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field state of com.linkedin.incident.IncidentStatus to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "state", value.name());
        this._stateField = value;
        return this;
    }

    public boolean hasStage() {
        if (this._stageField != null) {
            return true;
        }
        return this._map.containsKey("stage");
    }

    public void removeStage() {
        this._map.remove("stage");
    }

    @Nullable
    public IncidentStage getStage(GetMode mode) {
        return this.getStage();
    }

    @Nullable
    public IncidentStage getStage() {
        if (this._stageField != null) {
            return this._stageField;
        }
        Object __rawValue = this._map.get("stage");
        this._stageField = DataTemplateUtil.coerceEnumOutput(__rawValue, IncidentStage.class, IncidentStage.$UNKNOWN);
        return this._stageField;
    }

    public IncidentStatus setStage(@Nullable IncidentStage value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStage(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStage();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "stage", value.name());
                this._stageField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "stage", value.name());
                this._stageField = value;
            }
        }
        return this;
    }

    public IncidentStatus setStage(@Nonnull IncidentStage value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field stage of com.linkedin.incident.IncidentStatus to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "stage", value.name());
        this._stageField = value;
        return this;
    }

    public boolean hasMessage() {
        if (this._messageField != null) {
            return true;
        }
        return this._map.containsKey("message");
    }

    public void removeMessage() {
        this._map.remove("message");
    }

    @Nullable
    public String getMessage(GetMode mode) {
        return this.getMessage();
    }

    @Nullable
    public String getMessage() {
        if (this._messageField != null) {
            return this._messageField;
        }
        Object __rawValue = this._map.get("message");
        this._messageField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._messageField;
    }

    public IncidentStatus setMessage(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMessage(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMessage();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "message", value);
                this._messageField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "message", value);
                this._messageField = value;
            }
        }
        return this;
    }

    public IncidentStatus setMessage(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field message of com.linkedin.incident.IncidentStatus to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "message", value);
        this._messageField = value;
        return this;
    }

    public boolean hasLastUpdated() {
        if (this._lastUpdatedField != null) {
            return true;
        }
        return this._map.containsKey("lastUpdated");
    }

    public void removeLastUpdated() {
        this._map.remove("lastUpdated");
    }

    @Nullable
    public AuditStamp getLastUpdated(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getLastUpdated();
            }
            case DEFAULT: 
            case NULL: {
                if (this._lastUpdatedField != null) {
                    return this._lastUpdatedField;
                }
                Object __rawValue = this._map.get("lastUpdated");
                this._lastUpdatedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._lastUpdatedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getLastUpdated() {
        if (this._lastUpdatedField != null) {
            return this._lastUpdatedField;
        }
        Object __rawValue = this._map.get("lastUpdated");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("lastUpdated");
        }
        this._lastUpdatedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastUpdatedField;
    }

    public IncidentStatus setLastUpdated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastUpdated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field lastUpdated of com.linkedin.incident.IncidentStatus");
                }
                CheckedUtil.putWithoutChecking(this._map, "lastUpdated", value.data());
                this._lastUpdatedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastUpdated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastUpdated", value.data());
                this._lastUpdatedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastUpdated", value.data());
                this._lastUpdatedField = value;
            }
        }
        return this;
    }

    public IncidentStatus setLastUpdated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastUpdated of com.linkedin.incident.IncidentStatus to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastUpdated", value.data());
        this._lastUpdatedField = value;
        return this;
    }

    @Override
    public IncidentStatus clone() throws CloneNotSupportedException {
        IncidentStatus __clone = (IncidentStatus)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public IncidentStatus copy() throws CloneNotSupportedException {
        IncidentStatus __copy = (IncidentStatus)super.copy();
        __copy._lastUpdatedField = null;
        __copy._stageField = null;
        __copy._stateField = null;
        __copy._messageField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final IncidentStatus __objectRef;

        private ChangeListener(IncidentStatus reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "lastUpdated": {
                    this.__objectRef._lastUpdatedField = null;
                    break;
                }
                case "stage": {
                    this.__objectRef._stageField = null;
                    break;
                }
                case "state": {
                    this.__objectRef._stateField = null;
                    break;
                }
                case "message": {
                    this.__objectRef._messageField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec state() {
            return new PathSpec(this.getPathComponents(), "state");
        }

        public PathSpec stage() {
            return new PathSpec(this.getPathComponents(), "stage");
        }

        public PathSpec message() {
            return new PathSpec(this.getPathComponents(), "message");
        }

        public AuditStamp.Fields lastUpdated() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastUpdated");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _lastUpdatedMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withState() {
            this.getDataMap().put("state", 1);
            return this;
        }

        public ProjectionMask withStage() {
            this.getDataMap().put("stage", 1);
            return this;
        }

        public ProjectionMask withMessage() {
            this.getDataMap().put("message", 1);
            return this;
        }

        public ProjectionMask withLastUpdated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastUpdatedMask = nestedMask.apply(this._lastUpdatedMask == null ? AuditStamp.createMask() : this._lastUpdatedMask);
            this.getDataMap().put("lastUpdated", this._lastUpdatedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastUpdated(MaskMap nestedMask) {
            this.getDataMap().put("lastUpdated", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastUpdated() {
            this._lastUpdatedMask = null;
            this.getDataMap().put("lastUpdated", 1);
            return this;
        }
    }
}

