/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.form;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.form.FormPrompt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class FormPromptArray
extends WrappingArrayTemplate<FormPrompt> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.form/**A prompt to present to the user to encourage filling out metadata*/record FormPrompt{/**The unique id for this prompt. This must be GLOBALLY unique.*/@Searchable={\"fieldName\":\"promptId\",\"fieldType\":\"KEYWORD\",\"queryByDefault\":false}id:string/**The title of this prompt*/title:string/**The description of this prompt*/description:optional string/**The type of prompt*/type:enum FormPromptType{/**This prompt is meant to apply a structured property to an entity*/STRUCTURED_PROPERTY/**This prompt is meant to apply a structured property to a schema fields entity*/FIELDS_STRUCTURED_PROPERTY}/**An optional set of information specific to structured properties prompts.\nThis should be filled out if the prompt is type STRUCTURED_PROPERTY or FIELDS_STRUCTURED_PROPERTY.*/structuredPropertyParams:optional record StructuredPropertyParams{/**The structured property that is required on this entity*/@Searchable={\"fieldName\":\"structuredPropertyPromptUrns\",\"fieldType\":\"URN\"}urn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}/**Whether the prompt is required to be completed, in order for the form to be marked as complete.*/required:boolean=false}}]", SchemaFormatType.PDL);

    public FormPromptArray() {
        this(new DataList());
    }

    public FormPromptArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public FormPromptArray(Collection<FormPrompt> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public FormPromptArray(DataList data) {
        super(data, SCHEMA, FormPrompt.class);
    }

    public FormPromptArray(FormPrompt first, FormPrompt ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public FormPromptArray clone() throws CloneNotSupportedException {
        FormPromptArray __clone = (FormPromptArray)super.clone();
        return __clone;
    }

    @Override
    public FormPromptArray copy() throws CloneNotSupportedException {
        FormPromptArray __copy = (FormPromptArray)super.copy();
        return __copy;
    }

    @Override
    protected FormPrompt coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new FormPrompt(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private FormPrompt.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<FormPrompt.ProjectionMask, FormPrompt.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? FormPrompt.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public FormPrompt.Fields items() {
            return new FormPrompt.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

