/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.execution;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.execution.StructuredExecutionReport;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExecutionRequestResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.execution/**The result of an execution request*/@Aspect.name=\"dataHubExecutionRequestResult\"record ExecutionRequestResult{/**The status of the execution request*/@Searchable={\"fieldName\":\"executionResultStatus\",\"fieldType\":\"KEYWORD\"}status:string/**The pretty-printed execution report.*/report:optional string/**A structured report if available.*/structuredReport:optional/**A flexible carrier for structured results of an execution request.\nThe goal is to allow for free flow of structured responses from execution tasks to the orchestrator or observer.\nThe full spectrum of different execution report types is not intended to be modeled by this object.*/record StructuredExecutionReport{/**The type of the structured report. (e.g. INGESTION_REPORT, TEST_CONNECTION_REPORT, etc.)*/type:string/**The serialized value of the structured report\n*/serializedValue:string/**The content-type of the serialized value (e.g. application/json, application/json;gzip etc.)\n*/contentType:string}/**Time at which the request was created*/@Searchable={\"fieldName\":\"startTimeMs\",\"fieldType\":\"COUNT\",\"queryByDefault\":false}startTimeMs:optional long/**Duration in milliseconds*/durationMs:optional long}", SchemaFormatType.PDL);
    private String _statusField = null;
    private String _reportField = null;
    private StructuredExecutionReport _structuredReportField = null;
    private Long _startTimeMsField = null;
    private Long _durationMsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Status = SCHEMA.getField("status");
    private static final RecordDataSchema.Field FIELD_Report = SCHEMA.getField("report");
    private static final RecordDataSchema.Field FIELD_StructuredReport = SCHEMA.getField("structuredReport");
    private static final RecordDataSchema.Field FIELD_StartTimeMs = SCHEMA.getField("startTimeMs");
    private static final RecordDataSchema.Field FIELD_DurationMs = SCHEMA.getField("durationMs");

    public ExecutionRequestResult() {
        super(new DataMap(7, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public ExecutionRequestResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasStatus() {
        if (this._statusField != null) {
            return true;
        }
        return this._map.containsKey("status");
    }

    public void removeStatus() {
        this._map.remove("status");
    }

    @Nullable
    public String getStatus(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getStatus();
            }
            case DEFAULT: 
            case NULL: {
                if (this._statusField != null) {
                    return this._statusField;
                }
                Object __rawValue = this._map.get("status");
                this._statusField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._statusField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getStatus() {
        if (this._statusField != null) {
            return this._statusField;
        }
        Object __rawValue = this._map.get("status");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("status");
        }
        this._statusField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._statusField;
    }

    public ExecutionRequestResult setStatus(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStatus(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field status of com.linkedin.execution.ExecutionRequestResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "status", value);
                this._statusField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStatus();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "status", value);
                this._statusField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "status", value);
                this._statusField = value;
            }
        }
        return this;
    }

    public ExecutionRequestResult setStatus(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field status of com.linkedin.execution.ExecutionRequestResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "status", value);
        this._statusField = value;
        return this;
    }

    public boolean hasReport() {
        if (this._reportField != null) {
            return true;
        }
        return this._map.containsKey("report");
    }

    public void removeReport() {
        this._map.remove("report");
    }

    @Nullable
    public String getReport(GetMode mode) {
        return this.getReport();
    }

    @Nullable
    public String getReport() {
        if (this._reportField != null) {
            return this._reportField;
        }
        Object __rawValue = this._map.get("report");
        this._reportField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._reportField;
    }

    public ExecutionRequestResult setReport(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setReport(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeReport();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "report", value);
                this._reportField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "report", value);
                this._reportField = value;
            }
        }
        return this;
    }

    public ExecutionRequestResult setReport(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field report of com.linkedin.execution.ExecutionRequestResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "report", value);
        this._reportField = value;
        return this;
    }

    public boolean hasStructuredReport() {
        if (this._structuredReportField != null) {
            return true;
        }
        return this._map.containsKey("structuredReport");
    }

    public void removeStructuredReport() {
        this._map.remove("structuredReport");
    }

    @Nullable
    public StructuredExecutionReport getStructuredReport(GetMode mode) {
        return this.getStructuredReport();
    }

    @Nullable
    public StructuredExecutionReport getStructuredReport() {
        if (this._structuredReportField != null) {
            return this._structuredReportField;
        }
        Object __rawValue = this._map.get("structuredReport");
        this._structuredReportField = __rawValue == null ? null : new StructuredExecutionReport(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._structuredReportField;
    }

    public ExecutionRequestResult setStructuredReport(@Nullable StructuredExecutionReport value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStructuredReport(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStructuredReport();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "structuredReport", value.data());
                this._structuredReportField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "structuredReport", value.data());
                this._structuredReportField = value;
            }
        }
        return this;
    }

    public ExecutionRequestResult setStructuredReport(@Nonnull StructuredExecutionReport value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field structuredReport of com.linkedin.execution.ExecutionRequestResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "structuredReport", value.data());
        this._structuredReportField = value;
        return this;
    }

    public boolean hasStartTimeMs() {
        if (this._startTimeMsField != null) {
            return true;
        }
        return this._map.containsKey("startTimeMs");
    }

    public void removeStartTimeMs() {
        this._map.remove("startTimeMs");
    }

    @Nullable
    public Long getStartTimeMs(GetMode mode) {
        return this.getStartTimeMs();
    }

    @Nullable
    public Long getStartTimeMs() {
        if (this._startTimeMsField != null) {
            return this._startTimeMsField;
        }
        Object __rawValue = this._map.get("startTimeMs");
        this._startTimeMsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._startTimeMsField;
    }

    public ExecutionRequestResult setStartTimeMs(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStartTimeMs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStartTimeMs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "startTimeMs", DataTemplateUtil.coerceLongInput(value));
                this._startTimeMsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "startTimeMs", DataTemplateUtil.coerceLongInput(value));
                this._startTimeMsField = value;
            }
        }
        return this;
    }

    public ExecutionRequestResult setStartTimeMs(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field startTimeMs of com.linkedin.execution.ExecutionRequestResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "startTimeMs", DataTemplateUtil.coerceLongInput(value));
        this._startTimeMsField = value;
        return this;
    }

    public ExecutionRequestResult setStartTimeMs(long value) {
        CheckedUtil.putWithoutChecking(this._map, "startTimeMs", DataTemplateUtil.coerceLongInput(value));
        this._startTimeMsField = value;
        return this;
    }

    public boolean hasDurationMs() {
        if (this._durationMsField != null) {
            return true;
        }
        return this._map.containsKey("durationMs");
    }

    public void removeDurationMs() {
        this._map.remove("durationMs");
    }

    @Nullable
    public Long getDurationMs(GetMode mode) {
        return this.getDurationMs();
    }

    @Nullable
    public Long getDurationMs() {
        if (this._durationMsField != null) {
            return this._durationMsField;
        }
        Object __rawValue = this._map.get("durationMs");
        this._durationMsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._durationMsField;
    }

    public ExecutionRequestResult setDurationMs(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDurationMs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDurationMs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "durationMs", DataTemplateUtil.coerceLongInput(value));
                this._durationMsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "durationMs", DataTemplateUtil.coerceLongInput(value));
                this._durationMsField = value;
            }
        }
        return this;
    }

    public ExecutionRequestResult setDurationMs(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field durationMs of com.linkedin.execution.ExecutionRequestResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "durationMs", DataTemplateUtil.coerceLongInput(value));
        this._durationMsField = value;
        return this;
    }

    public ExecutionRequestResult setDurationMs(long value) {
        CheckedUtil.putWithoutChecking(this._map, "durationMs", DataTemplateUtil.coerceLongInput(value));
        this._durationMsField = value;
        return this;
    }

    @Override
    public ExecutionRequestResult clone() throws CloneNotSupportedException {
        ExecutionRequestResult __clone = (ExecutionRequestResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ExecutionRequestResult copy() throws CloneNotSupportedException {
        ExecutionRequestResult __copy = (ExecutionRequestResult)super.copy();
        __copy._reportField = null;
        __copy._structuredReportField = null;
        __copy._startTimeMsField = null;
        __copy._durationMsField = null;
        __copy._statusField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ExecutionRequestResult __objectRef;

        private ChangeListener(ExecutionRequestResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "report": {
                    this.__objectRef._reportField = null;
                    break;
                }
                case "structuredReport": {
                    this.__objectRef._structuredReportField = null;
                    break;
                }
                case "startTimeMs": {
                    this.__objectRef._startTimeMsField = null;
                    break;
                }
                case "durationMs": {
                    this.__objectRef._durationMsField = null;
                    break;
                }
                case "status": {
                    this.__objectRef._statusField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec status() {
            return new PathSpec(this.getPathComponents(), "status");
        }

        public PathSpec report() {
            return new PathSpec(this.getPathComponents(), "report");
        }

        public StructuredExecutionReport.Fields structuredReport() {
            return new StructuredExecutionReport.Fields(this.getPathComponents(), "structuredReport");
        }

        public PathSpec startTimeMs() {
            return new PathSpec(this.getPathComponents(), "startTimeMs");
        }

        public PathSpec durationMs() {
            return new PathSpec(this.getPathComponents(), "durationMs");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private StructuredExecutionReport.ProjectionMask _structuredReportMask;

        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withStatus() {
            this.getDataMap().put("status", 1);
            return this;
        }

        public ProjectionMask withReport() {
            this.getDataMap().put("report", 1);
            return this;
        }

        public ProjectionMask withStructuredReport(Function<StructuredExecutionReport.ProjectionMask, StructuredExecutionReport.ProjectionMask> nestedMask) {
            this._structuredReportMask = nestedMask.apply(this._structuredReportMask == null ? StructuredExecutionReport.createMask() : this._structuredReportMask);
            this.getDataMap().put("structuredReport", this._structuredReportMask.getDataMap());
            return this;
        }

        public ProjectionMask withStructuredReport() {
            this._structuredReportMask = null;
            this.getDataMap().put("structuredReport", 1);
            return this;
        }

        public ProjectionMask withStartTimeMs() {
            this.getDataMap().put("startTimeMs", 1);
            return this;
        }

        public ProjectionMask withDurationMs() {
            this.getDataMap().put("durationMs", 1);
            return this;
        }
    }
}

