/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.common.TimeStamp;
import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.data.template.StringMap;
import java.net.URI;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatasetProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**Properties associated with a Dataset*/@Aspect.name=\"datasetProperties\"record DatasetProperties includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}{/**Display name of the Dataset*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:optional string/**Fully-qualified name of the Dataset*/@Searchable={\"addToFilters\":false,\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}qualifiedName:optional string/**Documentation of the dataset*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**The abstracted URI such as hdfs:///data/tracking/PageViewEvent, file:///dir/file_name. Uri should not include any environment specific properties. Some datasets might not have a standardized uri, which makes this field optional (i.e. kafka topic).*/@deprecated=\"Use ExternalReference.externalUrl field instead.\"uri:optional{namespace com.linkedin.common@java.class=\"java.net.URI\"typeref Uri=string}/**A timestamp documenting when the asset was created in the source Data Platform (not on DataHub)*/@Searchable.`/time`={\"fieldName\":\"createdAt\",\"fieldType\":\"DATETIME\"}created:optional{namespace com.linkedin.common/**A standard event timestamp*/record TimeStamp{/**When did the event occur*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**Optional: The actor urn involved in the event.*/actor:optional@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}/**A timestamp documenting when the asset was last modified in the source Data Platform (not on DataHub)*/@Searchable.`/time`={\"fieldName\":\"lastModifiedAt\",\"fieldType\":\"DATETIME\"}lastModified:optional com.linkedin.common.TimeStamp/**[Legacy] Unstructured tags for the dataset. Structured tags can be applied via the `GlobalTags` aspect.\nThis is now deprecated.*/@deprecated=\"Use GlobalTags aspect instead.\"tags:array[string]=[]}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private Url _externalUrlField = null;
    private String _nameField = null;
    private String _qualifiedNameField = null;
    private String _descriptionField = null;
    private URI _uriField = null;
    private TimeStamp _createdField = null;
    private TimeStamp _lastModifiedField = null;
    private StringArray _tagsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_ExternalUrl;
    private static final RecordDataSchema.Field FIELD_Name;
    private static final RecordDataSchema.Field FIELD_QualifiedName;
    private static final RecordDataSchema.Field FIELD_Description;
    private static final RecordDataSchema.Field FIELD_Uri;
    private static final RecordDataSchema.Field FIELD_Created;
    private static final RecordDataSchema.Field FIELD_LastModified;
    private static final RecordDataSchema.Field FIELD_Tags;
    private static final StringArray DEFAULT_Tags;

    public DatasetProperties() {
        super(new DataMap(12, 0.75f), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public DatasetProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public DatasetProperties setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.dataset.DatasetProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public DatasetProperties setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.dataset.DatasetProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasExternalUrl() {
        if (this._externalUrlField != null) {
            return true;
        }
        return this._map.containsKey("externalUrl");
    }

    public void removeExternalUrl() {
        this._map.remove("externalUrl");
    }

    @Nullable
    public Url getExternalUrl(GetMode mode) {
        return this.getExternalUrl();
    }

    @Nullable
    public Url getExternalUrl() {
        if (this._externalUrlField != null) {
            return this._externalUrlField;
        }
        Object __rawValue = this._map.get("externalUrl");
        this._externalUrlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._externalUrlField;
    }

    public DatasetProperties setExternalUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExternalUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExternalUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
            }
        }
        return this;
    }

    public DatasetProperties setExternalUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field externalUrl of com.linkedin.dataset.DatasetProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._externalUrlField = value;
        return this;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        return this.getName();
    }

    @Nullable
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public DatasetProperties setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public DatasetProperties setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.dataset.DatasetProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasQualifiedName() {
        if (this._qualifiedNameField != null) {
            return true;
        }
        return this._map.containsKey("qualifiedName");
    }

    public void removeQualifiedName() {
        this._map.remove("qualifiedName");
    }

    @Nullable
    public String getQualifiedName(GetMode mode) {
        return this.getQualifiedName();
    }

    @Nullable
    public String getQualifiedName() {
        if (this._qualifiedNameField != null) {
            return this._qualifiedNameField;
        }
        Object __rawValue = this._map.get("qualifiedName");
        this._qualifiedNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._qualifiedNameField;
    }

    public DatasetProperties setQualifiedName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setQualifiedName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeQualifiedName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "qualifiedName", value);
                this._qualifiedNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "qualifiedName", value);
                this._qualifiedNameField = value;
            }
        }
        return this;
    }

    public DatasetProperties setQualifiedName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field qualifiedName of com.linkedin.dataset.DatasetProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "qualifiedName", value);
        this._qualifiedNameField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public DatasetProperties setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public DatasetProperties setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.dataset.DatasetProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    @Deprecated
    public boolean hasUri() {
        if (this._uriField != null) {
            return true;
        }
        return this._map.containsKey("uri");
    }

    @Deprecated
    public void removeUri() {
        this._map.remove("uri");
    }

    @Deprecated
    @Nullable
    public URI getUri(GetMode mode) {
        return this.getUri();
    }

    @Deprecated
    @Nullable
    public URI getUri() {
        if (this._uriField != null) {
            return this._uriField;
        }
        Object __rawValue = this._map.get("uri");
        this._uriField = DataTemplateUtil.coerceCustomOutput(__rawValue, URI.class);
        return this._uriField;
    }

    @Deprecated
    public DatasetProperties setUri(@Nullable URI value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUri(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUri();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "uri", DataTemplateUtil.coerceCustomInput(value, URI.class));
                this._uriField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "uri", DataTemplateUtil.coerceCustomInput(value, URI.class));
                this._uriField = value;
            }
        }
        return this;
    }

    @Deprecated
    public DatasetProperties setUri(@Nonnull URI value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field uri of com.linkedin.dataset.DatasetProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "uri", DataTemplateUtil.coerceCustomInput(value, URI.class));
        this._uriField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public TimeStamp getCreated(GetMode mode) {
        return this.getCreated();
    }

    @Nullable
    public TimeStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        this._createdField = __rawValue == null ? null : new TimeStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public DatasetProperties setCreated(@Nullable TimeStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public DatasetProperties setCreated(@Nonnull TimeStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.dataset.DatasetProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public TimeStamp getLastModified(GetMode mode) {
        return this.getLastModified();
    }

    @Nullable
    public TimeStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        this._lastModifiedField = __rawValue == null ? null : new TimeStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public DatasetProperties setLastModified(@Nullable TimeStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public DatasetProperties setLastModified(@Nonnull TimeStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.dataset.DatasetProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    @Deprecated
    public boolean hasTags() {
        if (this._tagsField != null) {
            return true;
        }
        return this._map.containsKey("tags");
    }

    @Deprecated
    public void removeTags() {
        this._map.remove("tags");
    }

    @Deprecated
    @Nullable
    public StringArray getTags(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getTags();
            }
            case NULL: {
                if (this._tagsField != null) {
                    return this._tagsField;
                }
                Object __rawValue = this._map.get("tags");
                this._tagsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._tagsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public StringArray getTags() {
        if (this._tagsField != null) {
            return this._tagsField;
        }
        Object __rawValue = this._map.get("tags");
        if (__rawValue == null) {
            return DEFAULT_Tags;
        }
        this._tagsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._tagsField;
    }

    @Deprecated
    public DatasetProperties setTags(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTags(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field tags of com.linkedin.dataset.DatasetProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "tags", value.data());
                this._tagsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTags();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "tags", value.data());
                this._tagsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "tags", value.data());
                this._tagsField = value;
            }
        }
        return this;
    }

    @Deprecated
    public DatasetProperties setTags(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field tags of com.linkedin.dataset.DatasetProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "tags", value.data());
        this._tagsField = value;
        return this;
    }

    @Override
    public DatasetProperties clone() throws CloneNotSupportedException {
        DatasetProperties __clone = (DatasetProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DatasetProperties copy() throws CloneNotSupportedException {
        DatasetProperties __copy = (DatasetProperties)super.copy();
        __copy._externalUrlField = null;
        __copy._customPropertiesField = null;
        __copy._qualifiedNameField = null;
        __copy._createdField = null;
        __copy._nameField = null;
        __copy._descriptionField = null;
        __copy._lastModifiedField = null;
        __copy._uriField = null;
        __copy._tagsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_ExternalUrl = SCHEMA.getField("externalUrl");
        FIELD_Name = SCHEMA.getField("name");
        FIELD_QualifiedName = SCHEMA.getField("qualifiedName");
        FIELD_Description = SCHEMA.getField("description");
        FIELD_Uri = SCHEMA.getField("uri");
        FIELD_Created = SCHEMA.getField("created");
        FIELD_LastModified = SCHEMA.getField("lastModified");
        FIELD_Tags = SCHEMA.getField("tags");
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
        Custom.initializeCustomClass(URI.class);
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
        DEFAULT_Tags = FIELD_Tags.getDefault() == null ? null : new StringArray(DataTemplateUtil.castOrThrow(FIELD_Tags.getDefault(), DataList.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DatasetProperties __objectRef;

        private ChangeListener(DatasetProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "externalUrl": {
                    this.__objectRef._externalUrlField = null;
                    break;
                }
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "qualifiedName": {
                    this.__objectRef._qualifiedNameField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "uri": {
                    this.__objectRef._uriField = null;
                    break;
                }
                case "tags": {
                    this.__objectRef._tagsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec externalUrl() {
            return new PathSpec(this.getPathComponents(), "externalUrl");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec qualifiedName() {
            return new PathSpec(this.getPathComponents(), "qualifiedName");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        @Deprecated
        public PathSpec uri() {
            return new PathSpec(this.getPathComponents(), "uri");
        }

        public TimeStamp.Fields created() {
            return new TimeStamp.Fields(this.getPathComponents(), "created");
        }

        public TimeStamp.Fields lastModified() {
            return new TimeStamp.Fields(this.getPathComponents(), "lastModified");
        }

        @Deprecated
        public PathSpec tags() {
            return new PathSpec(this.getPathComponents(), "tags");
        }

        @Deprecated
        public PathSpec tags(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "tags");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeStamp.ProjectionMask _createdMask;
        private TimeStamp.ProjectionMask _lastModifiedMask;

        ProjectionMask() {
            super(12);
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withExternalUrl() {
            this.getDataMap().put("externalUrl", 1);
            return this;
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withQualifiedName() {
            this.getDataMap().put("qualifiedName", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withUri() {
            this.getDataMap().put("uri", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<TimeStamp.ProjectionMask, TimeStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? TimeStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<TimeStamp.ProjectionMask, TimeStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? TimeStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withTags() {
            this.getDataMap().put("tags", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withTags(Integer start, Integer count) {
            this.getDataMap().put("tags", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("tags").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("tags").put("$count", count);
            }
            return this;
        }
    }
}

