/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.datacontract;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.datacontract.DataQualityContractArray;
import com.linkedin.datacontract.FreshnessContractArray;
import com.linkedin.datacontract.SchemaContractArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataContractProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.datacontract/**Information about a data contract*/@Aspect.name=\"dataContractProperties\"record DataContractProperties{/**The entity that this contract is associated with. Currently, we only support Dataset contracts, but\nin the future we may also support Data Product level contracts.*/@Relationship={\"entityTypes\":[\"dataset\"],\"name\":\"ContractFor\"}entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**An optional set of schema contracts. If this is a dataset contract, there will only be one.*/@Relationship.`/*/assertion`={\"entityTypes\":[\"assertion\"],\"name\":\"IncludesSchemaAssertion\"}schema:optional array[/**Expectations for a logical schema*/record SchemaContract{/**The assertion representing the schema contract.*/@Relationship={\"entityTypes\":[\"assertion\"],\"name\":\"IncludesSchemaAssertion\"}assertion:com.linkedin.common.Urn}]/**An optional set of FRESHNESS contracts. If this is a dataset contract, there will only be one.*/@Relationship.`/*/assertion`={\"entityTypes\":[\"assertion\"],\"name\":\"IncludesFreshnessAssertion\"}freshness:optional array[/**A contract pertaining to the operational SLAs of a physical data asset*/record FreshnessContract{/**The assertion representing the SLA contract.*/assertion:com.linkedin.common.Urn}]/**An optional set of Data Quality contracts, e.g. table and column level contract constraints.*/@Relationship.`/*/assertion`={\"entityTypes\":[\"assertion\"],\"name\":\"IncludesDataQualityAssertion\"}dataQuality:optional array[/**A data quality contract pertaining to a physical data asset\nData Quality contracts are used to make assertions about data quality metrics for a physical data asset*/record DataQualityContract{/**The assertion representing the Data Quality contract.\nE.g. a table or column-level assertion.*/@Relationship={\"entityTypes\":[\"assertion\"],\"name\":\"IncludesDataQualityAssertion\"}assertion:com.linkedin.common.Urn}]/**YAML-formatted contract definition*/rawContract:optional string}", SchemaFormatType.PDL);
    private Urn _entityField = null;
    private SchemaContractArray _schemaField = null;
    private FreshnessContractArray _freshnessField = null;
    private DataQualityContractArray _dataQualityField = null;
    private String _rawContractField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Entity = SCHEMA.getField("entity");
    private static final RecordDataSchema.Field FIELD_Schema = SCHEMA.getField("schema");
    private static final RecordDataSchema.Field FIELD_Freshness = SCHEMA.getField("freshness");
    private static final RecordDataSchema.Field FIELD_DataQuality = SCHEMA.getField("dataQuality");
    private static final RecordDataSchema.Field FIELD_RawContract = SCHEMA.getField("rawContract");

    public DataContractProperties() {
        super(new DataMap(7, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public DataContractProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEntity() {
        if (this._entityField != null) {
            return true;
        }
        return this._map.containsKey("entity");
    }

    public void removeEntity() {
        this._map.remove("entity");
    }

    @Nullable
    public Urn getEntity(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntity();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityField != null) {
                    return this._entityField;
                }
                Object __rawValue = this._map.get("entity");
                this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._entityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getEntity() {
        if (this._entityField != null) {
            return this._entityField;
        }
        Object __rawValue = this._map.get("entity");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entity");
        }
        this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityField;
    }

    public DataContractProperties setEntity(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entity of com.linkedin.datacontract.DataContractProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
            }
        }
        return this;
    }

    public DataContractProperties setEntity(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entity of com.linkedin.datacontract.DataContractProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityField = value;
        return this;
    }

    public boolean hasSchema() {
        if (this._schemaField != null) {
            return true;
        }
        return this._map.containsKey("schema");
    }

    public void removeSchema() {
        this._map.remove("schema");
    }

    @Nullable
    public SchemaContractArray getSchema(GetMode mode) {
        return this.getSchema();
    }

    @Nullable
    public SchemaContractArray getSchema() {
        if (this._schemaField != null) {
            return this._schemaField;
        }
        Object __rawValue = this._map.get("schema");
        this._schemaField = __rawValue == null ? null : new SchemaContractArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._schemaField;
    }

    public DataContractProperties setSchema(@Nullable SchemaContractArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSchema(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSchema();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "schema", value.data());
                this._schemaField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "schema", value.data());
                this._schemaField = value;
            }
        }
        return this;
    }

    public DataContractProperties setSchema(@Nonnull SchemaContractArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field schema of com.linkedin.datacontract.DataContractProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "schema", value.data());
        this._schemaField = value;
        return this;
    }

    public boolean hasFreshness() {
        if (this._freshnessField != null) {
            return true;
        }
        return this._map.containsKey("freshness");
    }

    public void removeFreshness() {
        this._map.remove("freshness");
    }

    @Nullable
    public FreshnessContractArray getFreshness(GetMode mode) {
        return this.getFreshness();
    }

    @Nullable
    public FreshnessContractArray getFreshness() {
        if (this._freshnessField != null) {
            return this._freshnessField;
        }
        Object __rawValue = this._map.get("freshness");
        this._freshnessField = __rawValue == null ? null : new FreshnessContractArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._freshnessField;
    }

    public DataContractProperties setFreshness(@Nullable FreshnessContractArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFreshness(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFreshness();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "freshness", value.data());
                this._freshnessField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "freshness", value.data());
                this._freshnessField = value;
            }
        }
        return this;
    }

    public DataContractProperties setFreshness(@Nonnull FreshnessContractArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field freshness of com.linkedin.datacontract.DataContractProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "freshness", value.data());
        this._freshnessField = value;
        return this;
    }

    public boolean hasDataQuality() {
        if (this._dataQualityField != null) {
            return true;
        }
        return this._map.containsKey("dataQuality");
    }

    public void removeDataQuality() {
        this._map.remove("dataQuality");
    }

    @Nullable
    public DataQualityContractArray getDataQuality(GetMode mode) {
        return this.getDataQuality();
    }

    @Nullable
    public DataQualityContractArray getDataQuality() {
        if (this._dataQualityField != null) {
            return this._dataQualityField;
        }
        Object __rawValue = this._map.get("dataQuality");
        this._dataQualityField = __rawValue == null ? null : new DataQualityContractArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._dataQualityField;
    }

    public DataContractProperties setDataQuality(@Nullable DataQualityContractArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDataQuality(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDataQuality();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "dataQuality", value.data());
                this._dataQualityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "dataQuality", value.data());
                this._dataQualityField = value;
            }
        }
        return this;
    }

    public DataContractProperties setDataQuality(@Nonnull DataQualityContractArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field dataQuality of com.linkedin.datacontract.DataContractProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "dataQuality", value.data());
        this._dataQualityField = value;
        return this;
    }

    public boolean hasRawContract() {
        if (this._rawContractField != null) {
            return true;
        }
        return this._map.containsKey("rawContract");
    }

    public void removeRawContract() {
        this._map.remove("rawContract");
    }

    @Nullable
    public String getRawContract(GetMode mode) {
        return this.getRawContract();
    }

    @Nullable
    public String getRawContract() {
        if (this._rawContractField != null) {
            return this._rawContractField;
        }
        Object __rawValue = this._map.get("rawContract");
        this._rawContractField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._rawContractField;
    }

    public DataContractProperties setRawContract(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRawContract(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRawContract();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "rawContract", value);
                this._rawContractField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "rawContract", value);
                this._rawContractField = value;
            }
        }
        return this;
    }

    public DataContractProperties setRawContract(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field rawContract of com.linkedin.datacontract.DataContractProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "rawContract", value);
        this._rawContractField = value;
        return this;
    }

    @Override
    public DataContractProperties clone() throws CloneNotSupportedException {
        DataContractProperties __clone = (DataContractProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataContractProperties copy() throws CloneNotSupportedException {
        DataContractProperties __copy = (DataContractProperties)super.copy();
        __copy._schemaField = null;
        __copy._rawContractField = null;
        __copy._dataQualityField = null;
        __copy._freshnessField = null;
        __copy._entityField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataContractProperties __objectRef;

        private ChangeListener(DataContractProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "schema": {
                    this.__objectRef._schemaField = null;
                    break;
                }
                case "rawContract": {
                    this.__objectRef._rawContractField = null;
                    break;
                }
                case "dataQuality": {
                    this.__objectRef._dataQualityField = null;
                    break;
                }
                case "freshness": {
                    this.__objectRef._freshnessField = null;
                    break;
                }
                case "entity": {
                    this.__objectRef._entityField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec entity() {
            return new PathSpec(this.getPathComponents(), "entity");
        }

        public SchemaContractArray.Fields schema() {
            return new SchemaContractArray.Fields(this.getPathComponents(), "schema");
        }

        public PathSpec schema(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "schema");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public FreshnessContractArray.Fields freshness() {
            return new FreshnessContractArray.Fields(this.getPathComponents(), "freshness");
        }

        public PathSpec freshness(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "freshness");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public DataQualityContractArray.Fields dataQuality() {
            return new DataQualityContractArray.Fields(this.getPathComponents(), "dataQuality");
        }

        public PathSpec dataQuality(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "dataQuality");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec rawContract() {
            return new PathSpec(this.getPathComponents(), "rawContract");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private SchemaContractArray.ProjectionMask _schemaMask;
        private FreshnessContractArray.ProjectionMask _freshnessMask;
        private DataQualityContractArray.ProjectionMask _dataQualityMask;

        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withEntity() {
            this.getDataMap().put("entity", 1);
            return this;
        }

        public ProjectionMask withSchema(Function<SchemaContractArray.ProjectionMask, SchemaContractArray.ProjectionMask> nestedMask) {
            this._schemaMask = nestedMask.apply(this._schemaMask == null ? SchemaContractArray.createMask() : this._schemaMask);
            this.getDataMap().put("schema", this._schemaMask.getDataMap());
            return this;
        }

        public ProjectionMask withSchema() {
            this._schemaMask = null;
            this.getDataMap().put("schema", 1);
            return this;
        }

        public ProjectionMask withSchema(Function<SchemaContractArray.ProjectionMask, SchemaContractArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._schemaMask = nestedMask.apply(this._schemaMask == null ? SchemaContractArray.createMask() : this._schemaMask);
            this.getDataMap().put("schema", this._schemaMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("schema").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("schema").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withSchema(Integer start, Integer count) {
            this._schemaMask = null;
            this.getDataMap().put("schema", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("schema").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("schema").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFreshness(Function<FreshnessContractArray.ProjectionMask, FreshnessContractArray.ProjectionMask> nestedMask) {
            this._freshnessMask = nestedMask.apply(this._freshnessMask == null ? FreshnessContractArray.createMask() : this._freshnessMask);
            this.getDataMap().put("freshness", this._freshnessMask.getDataMap());
            return this;
        }

        public ProjectionMask withFreshness() {
            this._freshnessMask = null;
            this.getDataMap().put("freshness", 1);
            return this;
        }

        public ProjectionMask withFreshness(Function<FreshnessContractArray.ProjectionMask, FreshnessContractArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._freshnessMask = nestedMask.apply(this._freshnessMask == null ? FreshnessContractArray.createMask() : this._freshnessMask);
            this.getDataMap().put("freshness", this._freshnessMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("freshness").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("freshness").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFreshness(Integer start, Integer count) {
            this._freshnessMask = null;
            this.getDataMap().put("freshness", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("freshness").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("freshness").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDataQuality(Function<DataQualityContractArray.ProjectionMask, DataQualityContractArray.ProjectionMask> nestedMask) {
            this._dataQualityMask = nestedMask.apply(this._dataQualityMask == null ? DataQualityContractArray.createMask() : this._dataQualityMask);
            this.getDataMap().put("dataQuality", this._dataQualityMask.getDataMap());
            return this;
        }

        public ProjectionMask withDataQuality() {
            this._dataQualityMask = null;
            this.getDataMap().put("dataQuality", 1);
            return this;
        }

        public ProjectionMask withDataQuality(Function<DataQualityContractArray.ProjectionMask, DataQualityContractArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._dataQualityMask = nestedMask.apply(this._dataQualityMask == null ? DataQualityContractArray.createMask() : this._dataQualityMask);
            this.getDataMap().put("dataQuality", this._dataQualityMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("dataQuality").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("dataQuality").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDataQuality(Integer start, Integer count) {
            this._dataQualityMask = null;
            this.getDataMap().put("dataQuality", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("dataQuality").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("dataQuality").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withRawContract() {
            this.getDataMap().put("rawContract", 1);
            return this;
        }
    }
}

