/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.annotation;

import com.linkedin.data.message.Message;
import com.linkedin.data.message.MessageList;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.annotation.PathSpecBasedSchemaAnnotationVisitor;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.compatibility.CompatibilityMessage;
import com.linkedin.data.schema.compatibility.CompatibilityResult;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public interface SchemaAnnotationHandler {
    public ResolutionResult resolve(List<Pair<String, Object>> var1, ResolutionMetaData var2);

    public String getAnnotationNamespace();

    public AnnotationValidationResult validate(Map<String, Object> var1, ValidationMetaData var2);

    default public SchemaVisitor getVisitor() {
        return new PathSpecBasedSchemaAnnotationVisitor(this);
    }

    default public boolean implementsCheckCompatibility() {
        return false;
    }

    default public AnnotationCompatibilityResult checkCompatibility(Map<String, Object> prevResolvedProperties, Map<String, Object> currResolvedProperties, CompatibilityCheckContext prevContext, CompatibilityCheckContext currContext) {
        return new AnnotationCompatibilityResult();
    }

    public static class ResolutionMetaData {
        public DataSchema _dataSchemaUnderResolution;

        public DataSchema getDataSchemaUnderResolution() {
            return this._dataSchemaUnderResolution;
        }

        public void setDataSchemaUnderResolution(DataSchema dataSchemaUnderResolution) {
            this._dataSchemaUnderResolution = dataSchemaUnderResolution;
        }
    }

    public static class ValidationMetaData {
        DataSchema _dataSchema;
        ArrayDeque<String> _pathToSchema;

        public DataSchema getDataSchema() {
            return this._dataSchema;
        }

        public void setDataSchema(DataSchema dataSchema) {
            this._dataSchema = dataSchema;
        }

        public ArrayDeque<String> getPathToSchema() {
            return this._pathToSchema;
        }

        public void setPathToSchema(ArrayDeque<String> pathToSchema) {
            this._pathToSchema = pathToSchema;
        }
    }

    public static class AnnotationValidationResult {
        boolean _isValid = true;
        List<String> _paths = new ArrayList<String>();
        MessageList<Message> _messages = new MessageList();

        public boolean isValid() {
            return this._isValid;
        }

        public void setValid(boolean valid) {
            this._isValid = valid;
        }

        public List<String> getPaths() {
            return this._paths;
        }

        public void setPaths(List<String> paths) {
            this._paths = paths;
        }

        public MessageList<Message> getMessages() {
            return this._messages;
        }

        public void setMessages(MessageList<Message> messages) {
            this._messages = messages;
        }

        public void addMessage(List<String> path, String format, Object ... args) {
            this._messages.add(new Message(path.toArray(), format, args));
        }

        public void addMessage(Message msg) {
            this._messages.add(msg);
        }

        public void addMessages(Collection<? extends Message> messages) {
            this._messages.addAll(messages);
        }
    }

    public static class ResolutionResult {
        boolean _isError = false;
        MessageList<Message> _messages;
        Map<String, Object> _resolvedResult = Collections.emptyMap();

        public boolean isError() {
            return this._isError;
        }

        public void setError(boolean error) {
            this._isError = error;
        }

        public MessageList<Message> getMessages() {
            return this._messages;
        }

        public void setMessages(MessageList<Message> messages) {
            this._messages = messages;
        }

        public void addMessages(Collection<? extends Message> messages) {
            this._messages.addAll(messages);
        }

        public void addMessage(List<String> path, String format, Object ... args) {
            this._messages.add(new Message(path.toArray(), format, args));
        }

        public Map<String, Object> getResolvedResult() {
            return this._resolvedResult;
        }

        public void setResolvedResult(Map<String, Object> resolvedResult) {
            this._resolvedResult = resolvedResult;
        }
    }

    public static class AnnotationCompatibilityResult
    implements CompatibilityResult {
        private final MessageList<CompatibilityMessage> _messages = new MessageList();

        public void addMessage(CompatibilityMessage message) {
            this._messages.add(message);
        }

        @Override
        public Collection<CompatibilityMessage> getMessages() {
            return this._messages;
        }

        @Override
        public boolean isError() {
            return this._messages.isError();
        }
    }

    public static class CompatibilityCheckContext {
        DataSchema _currentSchema;
        RecordDataSchema.Field _schemaField;
        UnionDataSchema.Member _unionMember;
        PathSpec _pathSpecToSchema;

        public DataSchema getCurrentDataSchema() {
            return this._currentSchema;
        }

        public void setCurrentDataSchema(DataSchema currentSchema) {
            this._currentSchema = currentSchema;
        }

        public RecordDataSchema.Field getSchemaField() {
            return this._schemaField;
        }

        public void setSchemaField(RecordDataSchema.Field schemaField) {
            this._schemaField = schemaField;
        }

        public UnionDataSchema.Member getUnionMember() {
            return this._unionMember;
        }

        public void setUnionMember(UnionDataSchema.Member unionMember) {
            this._unionMember = unionMember;
        }

        public PathSpec getPathSpecToSchema() {
            return this._pathSpecToSchema;
        }

        public void setPathSpecToSchema(PathSpec pathSpecToSchema) {
            this._pathSpecToSchema = pathSpecToSchema;
        }
    }
}

