/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.annotation;

import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaTraverse;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.StringDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.annotation.AnnotationEntry;
import com.linkedin.data.schema.annotation.CurrentSchemaEntryMode;
import com.linkedin.data.schema.annotation.DataSchemaRichContextTraverser;
import com.linkedin.data.schema.annotation.SchemaAnnotationHandler;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.annotation.SchemaVisitorTraversalResult;
import com.linkedin.data.schema.annotation.TraverserContext;
import com.linkedin.data.schema.util.CopySchemaUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PathSpecBasedSchemaAnnotationVisitor
implements SchemaVisitor {
    private final SchemaAnnotationHandler _handler;
    private final SchemaVisitorTraversalResult _schemaVisitorTraversalResult = new SchemaVisitorTraversalResult();
    final String OVERRIDE_PATH_ERROR_MSG_TEMPLATE_MAL_FORMATTED_KEY = "MalFormatted key as PathSpec found: %s";
    final String OVERRIDE_PATH_ERROR_MSG_ENTRIES_NOT_IN_MAP = "Overrides entries should be key-value pairs that form a map";
    final String OVERRIDE_PATH_ERROR_MSG_ENTRIES_NOT_FOR_INCLUDED = "Overrides entries in record schema properties should be pointing to fields in included record schemas only. The pathSpec defined %s is not pointing to a included field.";
    final String RECORD_SCHEMA_LEVEL_ANNOTATION_NOT_ALLOWED = "Found annotations annotated at record schema level for annotation namespace \"%s\", which is not allowed";
    private final IdentityHashMap<DataSchema, DataSchema> _seenDataSchemaMapping = new IdentityHashMap();
    private DataSchema _schemaConstructed = null;
    private Map<String, Set<String>> _directedEdges = new HashMap<String, Set<String>>();
    private HashSet<Pair<String, String>> _cycleCache = new HashSet();

    private boolean detectCycle(String startSchemaName, String endSchemaName) {
        if (startSchemaName.equals(endSchemaName) || this._cycleCache.contains(ImmutablePair.of(startSchemaName, endSchemaName))) {
            return true;
        }
        HashSet<String> visited = new HashSet<String>();
        boolean wouldFormCycle = PathSpecBasedSchemaAnnotationVisitor.checkReachability(endSchemaName, startSchemaName, visited, this._directedEdges);
        if (wouldFormCycle) {
            this._cycleCache.add(ImmutablePair.of(startSchemaName, endSchemaName));
        }
        return wouldFormCycle;
    }

    private static boolean checkReachability(String currentSchemaName, String targetSchemaName, HashSet<String> visited, Map<String, Set<String>> edges) {
        visited.add(currentSchemaName);
        if (currentSchemaName.equals(targetSchemaName)) {
            return true;
        }
        Set nextNodes = edges.computeIfAbsent(currentSchemaName, key -> new HashSet());
        for (String nextNode : nextNodes) {
            if (visited.contains(nextNode) || !PathSpecBasedSchemaAnnotationVisitor.checkReachability(nextNode, targetSchemaName, visited, edges)) continue;
            return true;
        }
        return false;
    }

    public PathSpecBasedSchemaAnnotationVisitor(SchemaAnnotationHandler handler) {
        this._handler = handler;
        assert (this._handler != null && this._handler.getAnnotationNamespace() != null);
    }

    @Override
    public SchemaVisitor.VisitorContext getInitialVisitorContext() {
        return new PathSpecTraverseVisitorContext();
    }

    @Override
    public SchemaVisitorTraversalResult getSchemaVisitorTraversalResult() {
        return this._schemaVisitorTraversalResult;
    }

    @Override
    public void callbackOnContext(TraverserContext context, DataSchemaTraverse.Order order) {
        if (order == DataSchemaTraverse.Order.POST_ORDER) {
            SchemaVisitor.VisitorContext postVisitContext = context.getVisitorContext();
            List<AnnotationEntry> annotationEntries = ((PathSpecTraverseVisitorContext)postVisitContext).getAnnotationEntriesFromParentSchema();
            for (AnnotationEntry annotationEntry2 : annotationEntries) {
                if (!annotationEntry2.isOverride() || annotationEntry2.getOverridePathValidStatus() != AnnotationEntry.OverridePathValidStatus.UNCHECKED) continue;
                this.markAnnotationEntryInvalid(annotationEntry2, OverridePathErrorMsg.DOES_NOT_MATCH_NAME);
            }
            if (context.getParentSchema() == null) {
                this.getSchemaVisitorTraversalResult().setConstructedSchema(this._schemaConstructed);
            }
            return;
        }
        SchemaVisitor.VisitorContext visitorContext = context.getVisitorContext();
        PathSpecTraverseVisitorContext newVisitorContext = new PathSpecTraverseVisitorContext();
        DataSchema newSchema = null;
        DataSchema parentSchema = context.getParentSchema();
        DataSchema currentSchema = context.getCurrentSchema();
        List<AnnotationEntry> currentAnnotationEntries = ((PathSpecTraverseVisitorContext)visitorContext).getAnnotationEntriesFromParentSchema();
        if (parentSchema != null && parentSchema.getType() != DataSchema.Type.TYPEREF) {
            List<String> schemaPathSpec = context.getSchemaPathSpec();
            String pathSpecMatchingSegment = schemaPathSpec.isEmpty() ? null : schemaPathSpec.get(schemaPathSpec.size() - 1);
            currentAnnotationEntries = currentAnnotationEntries.stream().filter(annotationEntry -> annotationEntry.getOverridePathValidStatus() == AnnotationEntry.OverridePathValidStatus.UNCHECKED && annotationEntry.getRemainingPaths().size() > 0 && Objects.equals(annotationEntry.getRemainingPaths().peekFirst(), pathSpecMatchingSegment)).peek(annotationEntry -> {
                annotationEntry.getMatchedPaths().add(pathSpecMatchingSegment);
                annotationEntry.getRemainingPaths().pollFirst();
            }).collect(Collectors.toList());
        }
        assert (currentAnnotationEntries.stream().filter(AnnotationEntry::isOverride).allMatch(annotationEntry -> annotationEntry.getOverridePathValidStatus() == AnnotationEntry.OverridePathValidStatus.UNCHECKED));
        if (parentSchema != null) {
            switch (parentSchema.getType()) {
                case RECORD: {
                    RecordDataSchema.Field enclosingField = context.getEnclosingField();
                    ArrayList<String> fullTraversePath = new ArrayList<String>(context.getTraversePath());
                    fullTraversePath.remove(fullTraversePath.size() - 1);
                    currentAnnotationEntries.addAll(this.generateAnnotationEntryFromField(enclosingField, (List<String>)fullTraversePath));
                    break;
                }
                case TYPEREF: {
                    currentAnnotationEntries.addAll(this.generateAnnotationEntryFromTypeRefSchema((TyperefDataSchema)parentSchema, context.getTraversePath()));
                    break;
                }
            }
        }
        currentAnnotationEntries.addAll(this.generateAnnotationEntryFromNamedSchema(currentSchema, context.getTraversePath()));
        if (currentSchema.getType() == DataSchema.Type.RECORD) {
            Iterator<AnnotationEntry> currentSchemaFullName = ((RecordDataSchema)currentSchema).getFullName();
            for (AnnotationEntry annotationEntry3 : currentAnnotationEntries) {
                String overrideStartSchemaName = annotationEntry3.getStartSchemaName();
                if (this.detectCycle(overrideStartSchemaName, (String)((Object)currentSchemaFullName))) {
                    this.getSchemaVisitorTraversalResult().addMessage(context.getTraversePath(), "Found overrides that forms a cyclic-referencing: Overrides entry in traverser path \"%s\" with its pathSpec value \"%s\" is pointing to the field with traverser path \"%s\" and schema name \"%s\", this is causing cyclic-referencing.", new PathSpec(annotationEntry3.getPathToAnnotatedTarget().toArray(new String[0])).toString(), annotationEntry3.getOverridePathSpecStr(), new PathSpec(context.getTraversePath().toArray(new String[0])).toString(), currentSchemaFullName);
                    context.setShouldContinue(Boolean.FALSE);
                    newVisitorContext.setAnnotationEntriesFromParentSchema(currentAnnotationEntries);
                    context.setVisitorContext(newVisitorContext);
                    return;
                }
                this._directedEdges.computeIfAbsent(overrideStartSchemaName, key -> new HashSet()).add(currentSchemaFullName);
            }
        }
        try {
            if (DataSchemaRichContextTraverser.isLeafSchema(currentSchema)) {
                newSchema = this.createOrReUseSchemaAndAttachToParent(context, currentAnnotationEntries.size() != 0);
                newSchema.getResolvedProperties().putAll(this.resolveAnnotationEntries(currentAnnotationEntries, context.getSchemaPathSpec()));
                for (AnnotationEntry annotationEntry4 : currentAnnotationEntries) {
                    if (!annotationEntry4.isOverride()) continue;
                    if (annotationEntry4.getRemainingPaths().size() == 0) {
                        annotationEntry4.setOverridePathValidStatus(AnnotationEntry.OverridePathValidStatus.VALID);
                        continue;
                    }
                    this.markAnnotationEntryInvalid(annotationEntry4, OverridePathErrorMsg.TOO_LONG);
                }
            } else if (currentSchema.isComplex()) {
                assert (currentAnnotationEntries.stream().noneMatch(AnnotationEntry::isOverride) || currentAnnotationEntries.stream().allMatch(AnnotationEntry::isOverride));
                if (currentSchema.getType() != DataSchema.Type.TYPEREF) {
                    for (AnnotationEntry annotationEntry4 : currentAnnotationEntries) {
                        if (!annotationEntry4.isOverride() || annotationEntry4.getRemainingPaths().size() != 0) continue;
                        this.markAnnotationEntryInvalid(annotationEntry4, OverridePathErrorMsg.TOO_SHORT);
                    }
                }
                if (currentAnnotationEntries.stream().anyMatch(annotationEntry -> !annotationEntry.isOverride() || annotationEntry.getOverridePathValidStatus() == AnnotationEntry.OverridePathValidStatus.UNCHECKED)) {
                    newSchema = this.createOrReUseSchemaAndAttachToParent(context, true);
                    context.setShouldContinue(Boolean.TRUE);
                } else {
                    context.setShouldContinue(!this._seenDataSchemaMapping.containsKey(currentSchema));
                    newSchema = this.createOrReUseSchemaAndAttachToParent(context, false);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(String.format("encounter unexpected CloneNotSupportedException at traverse path location %s", Arrays.toString(context.getTraversePath().toArray())), e);
        }
        currentAnnotationEntries.addAll(this.generateAnnotationEntryFromInclude(currentSchema, context.getTraversePath()));
        newVisitorContext.setAnnotationEntriesFromParentSchema(currentAnnotationEntries);
        newVisitorContext.setOutputParentSchema(newSchema);
        context.setVisitorContext(newVisitorContext);
    }

    private void markAnnotationEntryInvalid(AnnotationEntry annotationEntry, OverridePathErrorMsg overridePathErrorMsg) {
        annotationEntry.setOverridePathValidStatus(AnnotationEntry.OverridePathValidStatus.INVALID);
        this.getSchemaVisitorTraversalResult().addMessage(annotationEntry.getPathToAnnotatedTarget(), overridePathErrorMsg.toString(), annotationEntry.getOverridePathSpecStr());
    }

    private List<AnnotationEntry> generateAnnotationEntryFromInclude(DataSchema dataSchema, List<String> pathToAnnotatedTarget) {
        if (dataSchema.getType() != DataSchema.Type.RECORD) {
            return new ArrayList<AnnotationEntry>();
        }
        if (((RecordDataSchema)dataSchema).getInclude().size() == 0 && dataSchema.getProperties().get(this.getAnnotationNamespace()) != null) {
            this.getSchemaVisitorTraversalResult().addMessage(pathToAnnotatedTarget, "Found annotations annotated at record schema level for annotation namespace \"%s\", which is not allowed", this.getAnnotationNamespace());
            return new ArrayList<AnnotationEntry>();
        }
        List<AnnotationEntry> overridesForIncludes = this.constructOverrideAnnotationEntryFromProperties(dataSchema.getProperties(), AnnotationEntry.AnnotationType.OVERRIDE_RECORD_INCLUDE, pathToAnnotatedTarget, dataSchema, ((RecordDataSchema)dataSchema).getFullName());
        Set includedFieldsNames = ((RecordDataSchema)dataSchema).getInclude().stream().map(DataSchema::getDereferencedDataSchema).flatMap(recordDataSchema -> ((RecordDataSchema)recordDataSchema).getFields().stream()).map(RecordDataSchema.Field::getName).collect(Collectors.toSet());
        for (AnnotationEntry annotationEntry : overridesForIncludes) {
            if (includedFieldsNames.contains(annotationEntry.getRemainingPaths().peekFirst())) continue;
            annotationEntry.setOverridePathValidStatus(AnnotationEntry.OverridePathValidStatus.INVALID);
            this.getSchemaVisitorTraversalResult().addMessage(annotationEntry.getPathToAnnotatedTarget(), "Overrides entries in record schema properties should be pointing to fields in included record schemas only. The pathSpec defined %s is not pointing to a included field.", annotationEntry.getOverridePathSpecStr());
        }
        return overridesForIncludes;
    }

    private List<AnnotationEntry> generateAnnotationEntryFromField(RecordDataSchema.Field field, List<String> pathToAnnotatedTarget) {
        if (field.getProperties().get(this.getAnnotationNamespace()) == null) {
            return new ArrayList<AnnotationEntry>();
        }
        if (DataSchemaRichContextTraverser.isLeafSchema(field.getType().getDereferencedDataSchema())) {
            return this.constructNonOverrideAnnotationEntryFromProperties(field.getProperties().get(this.getAnnotationNamespace()), AnnotationEntry.AnnotationType.NON_OVERRIDE_RECORD_FIELD, pathToAnnotatedTarget, field);
        }
        return this.constructOverrideAnnotationEntryFromProperties(field.getProperties(), AnnotationEntry.AnnotationType.OVERRIDE_RECORD_FIELD, pathToAnnotatedTarget, field, field.getRecord().getFullName());
    }

    private List<AnnotationEntry> generateAnnotationEntryFromTypeRefSchema(TyperefDataSchema dataSchema, List<String> pathToAnnotatedTarget) {
        if (dataSchema.getProperties().get(this.getAnnotationNamespace()) == null) {
            return new ArrayList<AnnotationEntry>();
        }
        ArrayList<AnnotationEntry> typeRefAnnotationEntries = new ArrayList<AnnotationEntry>();
        if (DataSchemaRichContextTraverser.isLeafSchema(dataSchema.getDereferencedDataSchema())) {
            typeRefAnnotationEntries.addAll(this.constructNonOverrideAnnotationEntryFromProperties(dataSchema.getProperties().get(this.getAnnotationNamespace()), AnnotationEntry.AnnotationType.NON_OVERRIDE_TYPE_REF, pathToAnnotatedTarget, dataSchema));
        } else {
            List<AnnotationEntry> annotationEntryToReturn = this.constructOverrideAnnotationEntryFromProperties(dataSchema.getProperties(), AnnotationEntry.AnnotationType.OVERRIDE_TYPE_REF_OVERRIDE, pathToAnnotatedTarget, dataSchema, dataSchema.getFullName());
            typeRefAnnotationEntries.addAll(annotationEntryToReturn);
            typeRefAnnotationEntries.forEach(annotationEntry -> annotationEntry.getMatchedPaths().add(dataSchema.getFullName()));
        }
        return typeRefAnnotationEntries;
    }

    private List<AnnotationEntry> generateAnnotationEntryFromNamedSchema(DataSchema dataSchema, List<String> pathToAnnotatedTarget) {
        AnnotationEntry.AnnotationType annotationType;
        if (dataSchema.getProperties().get(this.getAnnotationNamespace()) == null) {
            return new ArrayList<AnnotationEntry>();
        }
        switch (dataSchema.getType()) {
            case FIXED: {
                annotationType = AnnotationEntry.AnnotationType.NON_OVERRIDE_FIXED;
                break;
            }
            case ENUM: {
                annotationType = AnnotationEntry.AnnotationType.NON_OVERRIDE_ENUM;
                break;
            }
            default: {
                return new ArrayList<AnnotationEntry>();
            }
        }
        return Arrays.asList(new AnnotationEntry("", dataSchema.getProperties().get(this.getAnnotationNamespace()), annotationType, pathToAnnotatedTarget, dataSchema));
    }

    private List<AnnotationEntry> constructNonOverrideAnnotationEntryFromProperties(Object annotationValue, AnnotationEntry.AnnotationType annotationType, List<String> pathToAnnotatedTarget, Object annotatedTarget) {
        AnnotationEntry annotationEntry = new AnnotationEntry("", annotationValue, annotationType, pathToAnnotatedTarget, annotatedTarget);
        return new ArrayList<AnnotationEntry>(Arrays.asList(annotationEntry));
    }

    private List<AnnotationEntry> constructOverrideAnnotationEntryFromProperties(Map<String, Object> schemaProperties, AnnotationEntry.AnnotationType annotationType, List<String> pathToAnnotatedTarget, Object annotatedTarget, String startSchemaName) {
        Map properties = schemaProperties.getOrDefault(this.getAnnotationNamespace(), Collections.emptyMap());
        if (!(properties instanceof Map)) {
            this.getSchemaVisitorTraversalResult().addMessage(pathToAnnotatedTarget, "Overrides entries should be key-value pairs that form a map", new Object[0]);
            return new ArrayList<AnnotationEntry>();
        }
        Map propertiesMap = properties;
        ArrayList<AnnotationEntry> annotationEntryToReturn = new ArrayList<AnnotationEntry>();
        for (Map.Entry entry : propertiesMap.entrySet()) {
            if (!PathSpec.validatePathSpecString((String)entry.getKey())) {
                this.getSchemaVisitorTraversalResult().addMessage(pathToAnnotatedTarget, "MalFormatted key as PathSpec found: %s", entry.getKey());
                continue;
            }
            AnnotationEntry annotationEntry = new AnnotationEntry((String)entry.getKey(), entry.getValue(), annotationType, pathToAnnotatedTarget, annotatedTarget);
            annotationEntry.setStartSchemaName(startSchemaName);
            annotationEntryToReturn.add(annotationEntry);
        }
        return annotationEntryToReturn;
    }

    private DataSchema createOrReUseSchemaAndAttachToParent(TraverserContext context, boolean hasOverridesNotResolved) throws CloneNotSupportedException {
        DataSchema currentDataSchema = context.getCurrentSchema();
        CurrentSchemaEntryMode currentSchemaEntryMode = context.getCurrentSchemaEntryMode();
        DataSchema newSchema = null;
        if (hasOverridesNotResolved) {
            newSchema = CopySchemaUtil.buildSkeletonSchema(currentDataSchema);
        } else if (this._seenDataSchemaMapping.containsKey(currentDataSchema)) {
            newSchema = this._seenDataSchemaMapping.get(currentDataSchema);
        } else {
            newSchema = CopySchemaUtil.buildSkeletonSchema(currentDataSchema);
            this._seenDataSchemaMapping.put(currentDataSchema, newSchema);
        }
        PathSpecTraverseVisitorContext oldVisitorContext = (PathSpecTraverseVisitorContext)context.getVisitorContext();
        DataSchema outputParentSchema = oldVisitorContext.getOutputParentSchema();
        if (outputParentSchema == null) {
            this._schemaConstructed = newSchema;
            return newSchema;
        }
        switch (currentSchemaEntryMode) {
            case FIELD: {
                assert (outputParentSchema.getType() == DataSchema.Type.RECORD);
                PathSpecBasedSchemaAnnotationVisitor.addField(context.getEnclosingField(), newSchema, (RecordDataSchema)outputParentSchema);
                break;
            }
            case MAP_KEY: {
                assert (outputParentSchema.getType() == DataSchema.Type.MAP);
                MapDataSchema mapDataSchema = (MapDataSchema)outputParentSchema;
                mapDataSchema.setKey((StringDataSchema)newSchema);
                break;
            }
            case MAP_VALUE: {
                assert (outputParentSchema.getType() == DataSchema.Type.MAP);
                MapDataSchema mapDataSchema = (MapDataSchema)outputParentSchema;
                mapDataSchema.setValues(newSchema);
                break;
            }
            case ARRAY_VALUE: {
                assert (outputParentSchema.getType() == DataSchema.Type.ARRAY);
                ArrayDataSchema arrayDataSchema = (ArrayDataSchema)outputParentSchema;
                arrayDataSchema.setItems(newSchema);
                break;
            }
            case UNION_MEMBER: {
                assert (outputParentSchema.getType() == DataSchema.Type.UNION);
                PathSpecBasedSchemaAnnotationVisitor.addUnionMember(context.getEnclosingUnionMember(), newSchema, (UnionDataSchema)outputParentSchema);
                break;
            }
            case TYPEREF_REF: {
                TyperefDataSchema typerefDataSchema = (TyperefDataSchema)outputParentSchema;
                typerefDataSchema.setReferencedType(newSchema);
                break;
            }
        }
        return newSchema;
    }

    static void addField(RecordDataSchema.Field origField, DataSchema updatedFieldSchema, RecordDataSchema enclosingSchema) {
        RecordDataSchema.Field newField = CopySchemaUtil.copyField(origField, updatedFieldSchema);
        newField.setRecord(enclosingSchema);
        ArrayList<RecordDataSchema.Field> fields = new ArrayList<RecordDataSchema.Field>(enclosingSchema.getFields());
        fields.add(newField);
        enclosingSchema.setFields(fields, new StringBuilder());
    }

    static void addUnionMember(UnionDataSchema.Member origMember, DataSchema updatedMemberSchema, UnionDataSchema enclosingSchema) {
        UnionDataSchema.Member newUnionMember = CopySchemaUtil.copyUnionMember(origMember, updatedMemberSchema);
        ArrayList<UnionDataSchema.Member> unionMembers = new ArrayList<UnionDataSchema.Member>(enclosingSchema.getMembers());
        unionMembers.add(newUnionMember);
        enclosingSchema.setMembers(unionMembers, new StringBuilder());
    }

    private Map<String, Object> resolveAnnotationEntries(List<AnnotationEntry> propertiesOverrides, List<String> pathSpecComponents) {
        List<Pair<String, Object>> propertiesOverridesPairs = propertiesOverrides.stream().map(annotationEntry -> new ImmutablePair<String, Object>(annotationEntry.getOverridePathSpecStr(), annotationEntry.getAnnotationValue())).collect(Collectors.toList());
        SchemaAnnotationHandler.ResolutionResult result = this._handler.resolve(propertiesOverridesPairs, new SchemaAnnotationHandler.ResolutionMetaData());
        if (result.isError()) {
            this.getSchemaVisitorTraversalResult().addMessage(pathSpecComponents, "Annotations override resolution failed in handlers for %s", this.getAnnotationNamespace());
            this.getSchemaVisitorTraversalResult().addMessages(pathSpecComponents, result.getMessages());
        }
        return result.getResolvedResult();
    }

    private String getAnnotationNamespace() {
        return this._handler.getAnnotationNamespace();
    }

    static class PathSpecTraverseVisitorContext
    implements SchemaVisitor.VisitorContext {
        private List<AnnotationEntry> _annotationEntriesFromParentSchema = new ArrayList<AnnotationEntry>();
        private DataSchema _outputParentSchema = null;

        PathSpecTraverseVisitorContext() {
        }

        List<AnnotationEntry> getAnnotationEntriesFromParentSchema() {
            return this._annotationEntriesFromParentSchema;
        }

        void setAnnotationEntriesFromParentSchema(List<AnnotationEntry> annotationEntriesFromParentSchema) {
            this._annotationEntriesFromParentSchema = annotationEntriesFromParentSchema;
        }

        public DataSchema getOutputParentSchema() {
            return this._outputParentSchema;
        }

        public void setOutputParentSchema(DataSchema outputParentSchema) {
            this._outputParentSchema = outputParentSchema;
        }
    }

    static enum OverridePathErrorMsg {
        DOES_NOT_MATCH_NAME("Overriding pathSpec defined %s does not point to a valid primitive field"),
        TOO_LONG("Overriding pathSpec defined %s does not point to a valid primitive field: Path might be too long"),
        TOO_SHORT("Overriding pathSpec defined %s does not point to a valid primitive field: Path might be too short");

        private final String _error_msg;

        private OverridePathErrorMsg(String error_msg) {
            this._error_msg = error_msg;
        }

        public String toString() {
            return this._error_msg;
        }
    }
}

