/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.annotation;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaTraverse;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.annotation.SchemaAnnotationHandler;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.annotation.SchemaVisitorTraversalResult;
import com.linkedin.data.schema.annotation.TraverserContext;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AnnotationCheckResolvedPropertiesVisitor
implements SchemaVisitor {
    private Map<PathSpec, Pair<SchemaAnnotationHandler.CompatibilityCheckContext, Map<String, Object>>> _nodeToResolvedPropertiesMap = new HashMap<PathSpec, Pair<SchemaAnnotationHandler.CompatibilityCheckContext, Map<String, Object>>>();
    private static final String FIELD_INDICATOR = "$field";
    private static final String UNION_MEMBER_KEY_INDICATOR = "$unionMemberKey";

    @Override
    public void callbackOnContext(TraverserContext context, DataSchemaTraverse.Order order) {
        PathSpec pathSpec;
        if (order == DataSchemaTraverse.Order.POST_ORDER) {
            return;
        }
        DataSchema currentSchema = context.getCurrentSchema();
        RecordDataSchema.Field schemaField = context.getEnclosingField();
        UnionDataSchema.Member unionMember = context.getEnclosingUnionMember();
        ArrayDeque<String> pathToSchema = new ArrayDeque<String>(context.getSchemaPathSpec());
        pathToSchema.addFirst(((NamedDataSchema)context.getTopLevelSchema()).getName());
        if (schemaField != null && pathToSchema.peekLast().equals(context.getEnclosingField().getName())) {
            pathToSchema.addLast(FIELD_INDICATOR);
            pathSpec = new PathSpec(pathToSchema);
            this._nodeToResolvedPropertiesMap.put(pathSpec, new ImmutablePair<SchemaAnnotationHandler.CompatibilityCheckContext, Map<String, Object>>(this.generateCompatibilityCheckContext(schemaField, unionMember, currentSchema, pathSpec), this.chooseProperties(schemaField.getResolvedProperties(), schemaField.getProperties())));
            pathToSchema.removeLast();
        } else if (unionMember != null && pathToSchema.peekLast().equals(context.getEnclosingUnionMember().getUnionMemberKey())) {
            pathToSchema.addLast(UNION_MEMBER_KEY_INDICATOR);
            pathSpec = new PathSpec(pathToSchema);
            this._nodeToResolvedPropertiesMap.put(pathSpec, new ImmutablePair<SchemaAnnotationHandler.CompatibilityCheckContext, Map<String, Object>>(this.generateCompatibilityCheckContext(schemaField, unionMember, currentSchema, pathSpec), unionMember.getProperties()));
            pathToSchema.removeLast();
        }
        Map<String, Object> properties = this.chooseProperties(currentSchema.getResolvedProperties(), currentSchema.getProperties());
        PathSpec pathSpec2 = new PathSpec(pathToSchema);
        this._nodeToResolvedPropertiesMap.put(pathSpec2, new ImmutablePair<SchemaAnnotationHandler.CompatibilityCheckContext, Map<String, Object>>(this.generateCompatibilityCheckContext(schemaField, unionMember, currentSchema, pathSpec2), properties));
    }

    @Override
    public SchemaVisitor.VisitorContext getInitialVisitorContext() {
        return new SchemaVisitor.VisitorContext(){};
    }

    @Override
    public SchemaVisitorTraversalResult getSchemaVisitorTraversalResult() {
        return null;
    }

    @Override
    public boolean shouldIncludeTyperefsInPathSpec() {
        return true;
    }

    public Map<PathSpec, Pair<SchemaAnnotationHandler.CompatibilityCheckContext, Map<String, Object>>> getNodeToResolvedPropertiesMap() {
        return this._nodeToResolvedPropertiesMap;
    }

    private Map<String, Object> chooseProperties(Map<String, Object> preferredProperties, Map<String, Object> fallbackProperties) {
        return preferredProperties.isEmpty() ? fallbackProperties : preferredProperties;
    }

    private SchemaAnnotationHandler.CompatibilityCheckContext generateCompatibilityCheckContext(RecordDataSchema.Field schemaField, UnionDataSchema.Member unionMember, DataSchema currentSchema, PathSpec pathSpec) {
        SchemaAnnotationHandler.CompatibilityCheckContext checkContext = new SchemaAnnotationHandler.CompatibilityCheckContext();
        checkContext.setPathSpecToSchema(pathSpec);
        checkContext.setCurrentDataSchema(currentSchema);
        checkContext.setSchemaField(schemaField);
        checkContext.setUnionMember(unionMember);
        return checkContext;
    }
}

